/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.mapping;

import java.io.Serializable;
import org.alfresco.model.ContentModel;
import org.alfresco.opencmis.mapping.AbstractSimpleLuceneBuilder;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;

public class ContentStreamLengthLuceneBuilder
extends AbstractSimpleLuceneBuilder {
    private DictionaryService dictionaryService;

    public ContentStreamLengthLuceneBuilder(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    @Override
    public String getLuceneFieldName() {
        StringBuilder field = new StringBuilder(128);
        field.append("@");
        field.append(ContentModel.PROP_CONTENT);
        field.append(".size");
        return field.toString();
    }

    @Override
    protected String getValueAsString(Serializable value) {
        Object converted = DefaultTypeConverter.INSTANCE.convert(this.dictionaryService.getDataType(DataTypeDefinition.LONG), (Object)value);
        String asString = DefaultTypeConverter.INSTANCE.convert(String.class, converted);
        return asString;
    }

    @Override
    protected QName getQNameForExists() {
        return ContentModel.PROP_CONTENT;
    }

    @Override
    protected DataTypeDefinition getInDataType() {
        return this.dictionaryService.getDataType(DataTypeDefinition.LONG);
    }
}

