/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.DictionaryListener;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class DictionaryBootstrap
implements DictionaryListener {
    private List<String> models = new ArrayList<String>();
    private List<String> resourceBundles = new ArrayList<String>();
    private DictionaryDAO dictionaryDAO = null;
    private TenantService tenantService;
    private Properties globalProperties;
    private static Log logger = LogFactory.getLog(DictionaryBootstrap.class);

    public void setDictionaryDAO(DictionaryDAO dictionaryDAO) {
        this.dictionaryDAO = dictionaryDAO;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setGlobalProperties(Properties globalProperties) {
        this.globalProperties = globalProperties;
    }

    public void setModels(List<String> modelResources) {
        this.models = modelResources;
    }

    public void setLabels(List<String> labels) {
        this.resourceBundles = labels;
    }

    public void bootstrap() {
        this.onDictionaryInit();
        this.initStaticMessages();
        this.register();
    }

    private void register() {
        this.dictionaryDAO.registerListener(this);
    }

    @Override
    public void onDictionaryInit() {
        Collection<QName> modelsBefore;
        int modelsBeforeCnt;
        long startTime = System.currentTimeMillis();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("onDictionaryInit: [" + String.valueOf(Thread.currentThread()) + "]"));
        }
        int n = modelsBeforeCnt = (modelsBefore = this.dictionaryDAO.getModels(true)) != null ? modelsBefore.size() : 0;
        if (this.tenantService == null || !this.tenantService.isTenantUser()) {
            int modelsAfterCnt;
            for (String bootstrapModel : this.models) {
                InputStream modelStream = this.getClass().getClassLoader().getResourceAsStream(bootstrapModel);
                if (modelStream == null) {
                    throw new DictionaryException("d_dictionary.bootstrap.model_not_found", bootstrapModel);
                }
                try {
                    M2Model model = M2Model.createModel(modelStream);
                    model.setConfigProperties(this.globalProperties);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Loading model: " + model.getName() + " (from " + bootstrapModel + ")"));
                    }
                    this.dictionaryDAO.putModel(model);
                }
                catch (DictionaryException e) {
                    throw new DictionaryException("d_dictionary.bootstrap.model_not_imported", (Throwable)((Object)e), bootstrapModel);
                }
                finally {
                    try {
                        modelStream.close();
                    }
                    catch (IOException ioe) {
                        logger.warn((Object)("Failed to close model input stream for '" + bootstrapModel + "': " + String.valueOf(ioe)));
                    }
                }
            }
            Collection<QName> modelsAfter = this.dictionaryDAO.getModels(true);
            int n2 = modelsAfterCnt = modelsAfter != null ? modelsAfter.size() : 0;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Model count: before=" + modelsBeforeCnt + ", load=" + this.models.size() + ", after=" + modelsAfterCnt + " in " + (System.currentTimeMillis() - startTime) + " msecs [" + String.valueOf(Thread.currentThread()) + "]"));
            }
        }
    }

    @Override
    public void afterDictionaryInit() {
    }

    @Override
    public void afterDictionaryDestroy() {
    }

    private void initStaticMessages() {
        for (String resourceBundle : this.resourceBundles) {
            I18NUtil.registerResourceBundle((String)resourceBundle);
        }
    }
}

