/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.dictionary.M2Aspect;
import org.alfresco.repo.dictionary.M2AssociationDefinition;
import org.alfresco.repo.dictionary.M2ChildAssociation;
import org.alfresco.repo.dictionary.M2ChildAssociationDefinition;
import org.alfresco.repo.dictionary.M2Class;
import org.alfresco.repo.dictionary.M2ClassAssociation;
import org.alfresco.repo.dictionary.M2Label;
import org.alfresco.repo.dictionary.M2ModelDiff;
import org.alfresco.repo.dictionary.M2Property;
import org.alfresco.repo.dictionary.M2PropertyDefinition;
import org.alfresco.repo.dictionary.M2PropertyOverride;
import org.alfresco.repo.dictionary.ModelQuery;
import org.alfresco.repo.i18n.StaticMessageLookup;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ChildAssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassAttributeDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;

class M2ClassDefinition
implements ClassDefinition {
    private static final String ERR_CLASS_NOT_DEFINED_NAMESPACE = "d_dictionary.class_definition.class.namespace_not_defined";
    private static final String ERR_PROPERTY_NOT_DEFINED_NAMESPACE = "d_dictionary.class_definition.property.namespace_not_defined";
    private static final String ERR_DUPLICATE_PROPERTY_DEFINITION = "d_dictionary.class_definition.duplicate.property_definition";
    private static final String ERR_DUPLICATE_PROPERTY_EXISTING_DEF = "d_dictionary.class_definition.duplicate.property_existing_def";
    private static final String ERR_ASSOCIATION_NOT_DEFINED_NAMESPACE = "d_dictionary.class_definition.association.namespace_not_defined";
    private static final String ERR_DUPLICATE_ASSOCIATION_DEFINITION = "d_dictionary.class_definition.duplicate.association_definition";
    private static final String ERR_DUPLICATE_ASSOCIATION_EXISTING_DEF = "d_dictionary.class_definition.duplicate.association_existing_def";
    private static final String ERR_DUPLICATE_PROPERTY_AND_PROPERTY_OVERRIDE = "d_dictionary.class_definition.duplicate.property_and_property_override";
    private static final String ERR_DUPLICATE_PROPERTY_OVERRIDE = "d_dictionary.class_definition.duplicate.property_override_definition";
    private static final String ERR_PARENT_NOT_FOUND = "d_dictionary.class_definition.class.parent_not_found";
    private static final String ERR_PROPERTY_NOT_EXIST = "d_dictionary.class_definition.property_not_exist";
    private static final String ERR_MANDATORY_ASPECT_NOT_FOUND = "d_dictionary.class_definition.mandatory_aspect_not_found";
    private static final String ERR_DUPLICATE_PROPERTY_IN_CLASS_HIERARCHY = "d_dictionary.class_definition.duplicate.property_in_class_hierarchy";
    private static final String ERR_DUPLICATE_ASSOCIATION_IN_CLASS_HIERARCHY = "d_dictionary.class_definition.duplicate.association_in_class_hierarchy";
    protected ModelDefinition model;
    protected M2Class m2Class;
    protected QName name;
    protected QName parentName = null;
    protected ClassDefinition parentClassDefinition;
    private Map<QName, M2PropertyOverride> propertyOverrides = new HashMap<QName, M2PropertyOverride>();
    private Map<QName, PropertyDefinition> properties = new HashMap<QName, PropertyDefinition>();
    private Map<QName, PropertyDefinition> inheritedProperties = new HashMap<QName, PropertyDefinition>();
    private Map<QName, AssociationDefinition> associations = new HashMap<QName, AssociationDefinition>();
    private Map<QName, AssociationDefinition> inheritedAssociations = new HashMap<QName, AssociationDefinition>();
    private Map<QName, ChildAssociationDefinition> inheritedChildAssociations = new HashMap<QName, ChildAssociationDefinition>();
    private List<AspectDefinition> defaultAspects = new ArrayList<AspectDefinition>();
    private List<QName> defaultAspectNames = new ArrayList<QName>();
    private List<AspectDefinition> inheritedDefaultAspects = new ArrayList<AspectDefinition>();
    private Set<QName> inheritedDefaultAspectNames = new HashSet<QName>();
    private Boolean archive = null;
    private Boolean inheritedArchive = null;
    private Boolean includedInSuperTypeQuery = null;
    private Boolean inheritedIncludedInSuperTypeQuery = null;
    private String analyserResourceBundleName;
    private transient MessageLookup staticMessageLookup = new StaticMessageLookup();

    M2ClassDefinition(ModelDefinition model, M2Class m2Class, NamespacePrefixResolver resolver, Map<QName, PropertyDefinition> modelProperties, Map<QName, AssociationDefinition> modelAssociations) {
        ClassAttributeDefinition existingDef;
        ClassAttributeDefinition def;
        this.model = model;
        this.m2Class = m2Class;
        this.name = QName.createQName(m2Class.getName(), resolver);
        if (!model.isNamespaceDefined(this.name.getNamespaceURI())) {
            throw new DictionaryException(ERR_CLASS_NOT_DEFINED_NAMESPACE, this.name.toPrefixString(), this.name.getNamespaceURI(), model.getName().toPrefixString());
        }
        this.archive = m2Class.getArchive();
        this.includedInSuperTypeQuery = m2Class.getIncludedInSuperTypeQuery();
        if (m2Class.getParentName() != null && m2Class.getParentName().length() > 0) {
            this.parentName = QName.createQName(m2Class.getParentName(), resolver);
        }
        for (M2Property property : m2Class.getProperties()) {
            def = new M2PropertyDefinition(this, property, resolver);
            if (!model.isNamespaceDefined(def.getName().getNamespaceURI()) && !model.isNamespaceImported(def.getName().getNamespaceURI())) {
                throw new DictionaryException(ERR_PROPERTY_NOT_DEFINED_NAMESPACE, def.getName().toPrefixString(), def.getName().getNamespaceURI(), model.getName().toPrefixString());
            }
            if (this.properties.containsKey(def.getName())) {
                throw new DictionaryException.DuplicateDefinitionException(ERR_DUPLICATE_PROPERTY_DEFINITION, def.getName().toPrefixString(), this.name.toPrefixString());
            }
            existingDef = modelProperties.get(def.getName());
            if (existingDef != null) {
                throw new DictionaryException.DuplicateDefinitionException(ERR_DUPLICATE_PROPERTY_EXISTING_DEF, def.getName().toPrefixString(), this.name.toPrefixString(), existingDef.getContainerClass().getName().toPrefixString());
            }
            this.properties.put(def.getName(), (PropertyDefinition)def);
            modelProperties.put(def.getName(), (PropertyDefinition)def);
        }
        for (M2ClassAssociation assoc : m2Class.getAssociations()) {
            def = assoc instanceof M2ChildAssociation ? new M2ChildAssociationDefinition((ClassDefinition)this, (M2ChildAssociation)assoc, resolver) : new M2AssociationDefinition(this, assoc, resolver);
            if (!model.isNamespaceDefined(def.getName().getNamespaceURI())) {
                throw new DictionaryException(ERR_ASSOCIATION_NOT_DEFINED_NAMESPACE, def.getName().toPrefixString(), def.getName().getNamespaceURI(), model.getName().toPrefixString());
            }
            if (this.associations.containsKey(def.getName())) {
                throw new DictionaryException.DuplicateDefinitionException(ERR_DUPLICATE_ASSOCIATION_DEFINITION, def.getName().toPrefixString(), this.name.toPrefixString());
            }
            existingDef = modelAssociations.get(def.getName());
            if (existingDef != null) {
                throw new DictionaryException.DuplicateDefinitionException(ERR_DUPLICATE_ASSOCIATION_EXISTING_DEF, def.getName().toPrefixString(), this.name.toPrefixString(), existingDef.getSourceClass().getName().toPrefixString());
            }
            this.associations.put(def.getName(), (AssociationDefinition)def);
            modelAssociations.put(def.getName(), (AssociationDefinition)def);
        }
        for (M2PropertyOverride override : m2Class.getPropertyOverrides()) {
            QName overrideName = QName.createQName(override.getName(), resolver);
            if (this.properties.containsKey(overrideName)) {
                throw new DictionaryException.DuplicateDefinitionException(ERR_DUPLICATE_PROPERTY_AND_PROPERTY_OVERRIDE, overrideName.toPrefixString(), this.name.toPrefixString());
            }
            if (this.propertyOverrides.containsKey(overrideName)) {
                throw new DictionaryException.DuplicateDefinitionException(ERR_DUPLICATE_PROPERTY_OVERRIDE, overrideName.toPrefixString(), this.name.toPrefixString());
            }
            this.propertyOverrides.put(overrideName, override);
        }
        for (String aspectName : m2Class.getMandatoryAspects()) {
            QName name = QName.createQName(aspectName, resolver);
            if (this.defaultAspectNames.contains(name)) continue;
            this.defaultAspectNames.add(name);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(120);
        sb.append("ClassDef").append("[name=").append(this.name).append("]");
        return sb.toString();
    }

    void resolveDependencies(ModelQuery query, NamespacePrefixResolver prefixResolver, Map<QName, ConstraintDefinition> modelConstraints) {
        if (this.parentName != null) {
            ClassDefinition parent = query.getClass(this.parentName);
            if (parent == null) {
                throw new DictionaryException(ERR_PARENT_NOT_FOUND, this.parentName.toPrefixString(), this.name.toPrefixString());
            }
            this.parentClassDefinition = parent;
        }
        for (PropertyDefinition propertyDefinition : this.properties.values()) {
            ((M2PropertyDefinition)propertyDefinition).resolveDependencies(query, prefixResolver, modelConstraints);
        }
        for (AssociationDefinition associationDefinition : this.associations.values()) {
            ((M2AssociationDefinition)associationDefinition).resolveDependencies(query);
        }
        for (Map.Entry entry : this.propertyOverrides.entrySet()) {
            PropertyDefinition propDef = query.getProperty((QName)entry.getKey());
            if (propDef != null) continue;
            throw new DictionaryException(ERR_PROPERTY_NOT_EXIST, this.name.toPrefixString(), ((QName)entry.getKey()).toPrefixString());
        }
        for (QName qName : this.defaultAspectNames) {
            AspectDefinition aspect = query.getAspect(qName);
            if (aspect == null) {
                throw new DictionaryException(ERR_MANDATORY_ASPECT_NOT_FOUND, qName.toPrefixString(), this.name.toPrefixString());
            }
            this.defaultAspects.add(aspect);
        }
    }

    void resolveInheritance(ModelQuery query, NamespacePrefixResolver prefixResolver, Map<QName, ConstraintDefinition> modelConstraints) {
        ClassDefinition parentClass;
        ClassDefinition classDefinition = parentClass = this.parentName == null ? null : query.getClass(this.parentName);
        if (parentClass != null) {
            for (PropertyDefinition propertyDefinition : parentClass.getProperties().values()) {
                M2PropertyOverride override = this.propertyOverrides.get(propertyDefinition.getName());
                if (override == null) {
                    this.inheritedProperties.put(propertyDefinition.getName(), propertyDefinition);
                    continue;
                }
                this.inheritedProperties.put(propertyDefinition.getName(), new M2PropertyDefinition(this, propertyDefinition, override, prefixResolver, modelConstraints));
            }
        }
        for (PropertyDefinition propertyDefinition : this.properties.values()) {
            if (this.inheritedProperties.containsKey(propertyDefinition.getName())) {
                throw new DictionaryException.DuplicateDefinitionException(ERR_DUPLICATE_PROPERTY_IN_CLASS_HIERARCHY, propertyDefinition.getName().toPrefixString(), this.name.toPrefixString());
            }
            this.inheritedProperties.put(propertyDefinition.getName(), propertyDefinition);
        }
        if (parentClass != null) {
            this.inheritedAssociations.putAll(parentClass.getAssociations());
        }
        for (AssociationDefinition associationDefinition : this.associations.values()) {
            if (this.inheritedAssociations.containsKey(associationDefinition.getName())) {
                throw new DictionaryException.DuplicateDefinitionException(ERR_DUPLICATE_ASSOCIATION_IN_CLASS_HIERARCHY, associationDefinition.getName().toPrefixString(), this.name.toPrefixString());
            }
            this.inheritedAssociations.put(associationDefinition.getName(), associationDefinition);
        }
        for (AssociationDefinition associationDefinition : this.inheritedAssociations.values()) {
            if (!(associationDefinition instanceof ChildAssociationDefinition)) continue;
            this.inheritedChildAssociations.put(associationDefinition.getName(), (ChildAssociationDefinition)associationDefinition);
        }
        if (parentClass != null) {
            this.inheritedDefaultAspects.addAll(parentClass.getDefaultAspects());
        }
        for (AspectDefinition aspectDefinition : this.defaultAspects) {
            if (this.inheritedDefaultAspects.contains(aspectDefinition)) continue;
            this.inheritedDefaultAspects.add(aspectDefinition);
        }
        for (AspectDefinition aspectDefinition : this.inheritedDefaultAspects) {
            this.inheritedDefaultAspectNames.add(aspectDefinition.getName());
        }
        if (parentClass != null && this.archive == null) {
            this.inheritedArchive = ((M2ClassDefinition)parentClass).getArchive();
        }
        if (parentClass != null && this.includedInSuperTypeQuery == null) {
            this.inheritedIncludedInSuperTypeQuery = ((M2ClassDefinition)parentClass).getIncludedInSuperTypeQuery();
        }
    }

    @Override
    public ModelDefinition getModel() {
        return this.model;
    }

    @Override
    public QName getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.getDescription(this.staticMessageLookup);
    }

    @Override
    public String getTitle() {
        return this.getTitle(this.staticMessageLookup);
    }

    @Override
    public String getTitle(MessageLookup messageLookup) {
        String value = M2Label.getLabel(this.model, messageLookup, "class", this.name, "title");
        if (value == null) {
            value = this.m2Class.getTitle();
        }
        return value;
    }

    @Override
    public String getDescription(MessageLookup messageLookup) {
        String value = M2Label.getLabel(this.model, messageLookup, "class", this.name, "description");
        if (value == null) {
            value = this.m2Class.getDescription();
        }
        return value;
    }

    @Override
    public QName getParentName() {
        return this.parentName;
    }

    @Override
    public boolean isAspect() {
        return this.m2Class instanceof M2Aspect;
    }

    @Override
    public Boolean getArchive() {
        return this.archive == null ? this.inheritedArchive : this.archive;
    }

    @Override
    public Boolean getIncludedInSuperTypeQuery() {
        if (this.includedInSuperTypeQuery != null) {
            return this.includedInSuperTypeQuery;
        }
        if (this.inheritedIncludedInSuperTypeQuery != null) {
            return this.inheritedIncludedInSuperTypeQuery;
        }
        return Boolean.TRUE;
    }

    @Override
    public Map<QName, PropertyDefinition> getProperties() {
        return Collections.unmodifiableMap(this.inheritedProperties);
    }

    @Override
    public Map<QName, Serializable> getDefaultValues() {
        HashMap<QName, String> result = new HashMap<QName, String>(5);
        for (Map.Entry<QName, PropertyDefinition> entry : this.inheritedProperties.entrySet()) {
            PropertyDefinition propertyDefinition = entry.getValue();
            String defaultValue = propertyDefinition.getDefaultValue();
            if (defaultValue == null) continue;
            result.put(entry.getKey(), defaultValue);
        }
        return Collections.unmodifiableMap(result);
    }

    @Override
    public Map<QName, AssociationDefinition> getAssociations() {
        return Collections.unmodifiableMap(this.inheritedAssociations);
    }

    @Override
    public List<AspectDefinition> getDefaultAspects() {
        return this.inheritedDefaultAspects;
    }

    @Override
    public List<AspectDefinition> getDefaultAspects(boolean inherited) {
        return inherited ? this.getDefaultAspects() : this.defaultAspects;
    }

    @Override
    public Set<QName> getDefaultAspectNames() {
        return this.inheritedDefaultAspectNames;
    }

    @Override
    public boolean isContainer() {
        return !this.inheritedChildAssociations.isEmpty();
    }

    @Override
    public Map<QName, ChildAssociationDefinition> getChildAssociations() {
        return Collections.unmodifiableMap(this.inheritedChildAssociations);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof M2ClassDefinition)) {
            return false;
        }
        return this.name.equals(((M2ClassDefinition)obj).name);
    }

    List<M2ModelDiff> diffClass(ClassDefinition classDef) {
        ArrayList<M2ModelDiff> modelDiffs = new ArrayList<M2ModelDiff>();
        boolean isUpdated = false;
        boolean isUpdatedIncrementally = false;
        if (this == classDef) {
            return modelDiffs;
        }
        if (!this.getName().equals(classDef.getName())) {
            isUpdated = true;
        }
        if (!EqualsHelper.nullSafeEquals((String)this.getTitle(null), (String)classDef.getTitle(null), (boolean)false)) {
            isUpdatedIncrementally = true;
        }
        if (!EqualsHelper.nullSafeEquals((String)this.getDescription(null), (String)classDef.getDescription(null), (boolean)false)) {
            isUpdatedIncrementally = true;
        }
        if (this.getParentName() != null) {
            if (!this.getParentName().equals(classDef.getParentName())) {
                isUpdated = true;
            }
        } else if (classDef.getParentName() != null) {
            isUpdated = true;
        }
        if (this.isAspect() != classDef.isAspect()) {
            isUpdated = true;
        }
        if (this.isContainer() != classDef.isContainer()) {
            if (this.isContainer()) {
                isUpdated = true;
            }
            if (classDef.isContainer()) {
                isUpdatedIncrementally = true;
            }
        }
        Collection<M2ModelDiff> propertyDiffs = M2PropertyDefinition.diffPropertyLists(this.getProperties().values(), classDef.getProperties().values());
        modelDiffs.addAll(propertyDiffs);
        Collection<M2ModelDiff> assocDiffs = M2AssociationDefinition.diffAssocLists(this.getAssociations().values(), classDef.getAssociations().values());
        modelDiffs.addAll(assocDiffs);
        for (AspectDefinition newAspect : classDef.getDefaultAspects(false)) {
            boolean found = false;
            for (AspectDefinition previousAspect : this.getDefaultAspects(false)) {
                if (!newAspect.getName().equals(previousAspect.getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            isUpdated = true;
        }
        if (this.getArchive() == null) {
            if (classDef.getArchive() != null) {
                isUpdatedIncrementally = true;
            }
        } else {
            Boolean classArchive = classDef.getArchive();
            if (classArchive == null || classArchive.booleanValue() != this.getArchive().booleanValue()) {
                isUpdatedIncrementally = true;
            }
        }
        if (this.getIncludedInSuperTypeQuery() == null) {
            if (classDef.getIncludedInSuperTypeQuery() != null) {
                isUpdatedIncrementally = true;
            }
        } else {
            Boolean classIncludedInSuperTypeQuery = classDef.getIncludedInSuperTypeQuery();
            if (classIncludedInSuperTypeQuery == null || classIncludedInSuperTypeQuery.booleanValue() != this.getIncludedInSuperTypeQuery().booleanValue()) {
                isUpdatedIncrementally = true;
            }
        }
        String modelDiffType = this.isAspect() ? "ASPECT" : "TYPE";
        if (isUpdated) {
            modelDiffs.add(new M2ModelDiff(this.name, modelDiffType, "updated"));
        } else if (isUpdatedIncrementally) {
            modelDiffs.add(new M2ModelDiff(this.name, modelDiffType, "updated_inc"));
        } else {
            modelDiffs.add(new M2ModelDiff(this.name, modelDiffType, "unchanged"));
        }
        return modelDiffs;
    }

    static List<M2ModelDiff> diffClassLists(Collection<ClassDefinition> previousClasses, Collection<ClassDefinition> newClasses, String M2ModelDiffType) {
        boolean found;
        ArrayList<M2ModelDiff> modelDiffs = new ArrayList<M2ModelDiff>();
        for (ClassDefinition previousClass : previousClasses) {
            found = false;
            for (ClassDefinition newClass : newClasses) {
                if (!newClass.getName().equals(previousClass.getName())) continue;
                modelDiffs.addAll(((M2ClassDefinition)previousClass).diffClass(newClass));
                found = true;
                break;
            }
            if (found) continue;
            modelDiffs.add(new M2ModelDiff(previousClass.getName(), M2ModelDiffType, "deleted"));
        }
        for (ClassDefinition newClass : newClasses) {
            found = false;
            for (ClassDefinition previousClass : previousClasses) {
                if (!newClass.getName().equals(previousClass.getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            modelDiffs.add(new M2ModelDiff(newClass.getName(), M2ModelDiffType, "created"));
        }
        return modelDiffs;
    }

    @Override
    public ClassDefinition getParentClassDefinition() {
        return this.parentClassDefinition;
    }
}

