/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl;

import java.io.Serializable;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.PropertyArgument;
import org.alfresco.repo.search.impl.querymodel.impl.BaseDynamicArgument;
import org.alfresco.service.cmr.repository.NodeRef;

public class BasePropertyArgument
extends BaseDynamicArgument
implements PropertyArgument {
    private String propertyName;
    private String selector;

    public BasePropertyArgument(String name, boolean queryable, boolean orderable, String selector, String propertyName) {
        super(name, queryable, orderable);
        this.selector = selector;
        this.propertyName = propertyName;
    }

    @Override
    public String getSelector() {
        return this.selector;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public Serializable getValue(FunctionEvaluationContext context) {
        NodeRef nodeRef = context.getNodeRefs().get(this.getSelector());
        return context.getProperty(nodeRef, this.getPropertyName());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BasePropertyArgument[");
        builder.append("name=").append(this.getName()).append(", ");
        builder.append("selector=").append(this.getSelector()).append(", ");
        builder.append("propertName=").append(this.getPropertyName()).append(", ");
        builder.append("]");
        return builder.toString();
    }
}

