/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.lucene;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.search.adaptor.QueryParserExpressionAdaptor;
import org.alfresco.repo.search.impl.querymodel.Argument;
import org.alfresco.repo.search.impl.querymodel.Constraint;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.impl.BaseConjunction;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilderComponent;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.QueryBuilderContext;

public class LuceneConjunction<Q, S, E extends Throwable>
extends BaseConjunction
implements LuceneQueryBuilderComponent<Q, S, E> {
    public LuceneConjunction(List<Constraint> constraints) {
        super(constraints);
    }

    @Override
    public Q addComponent(Set<String> selectors, Map<String, Argument> functionArgs, QueryBuilderContext<Q, S, E> luceneContext, FunctionEvaluationContext functionContext) throws E {
        QueryParserExpressionAdaptor<Q, E> expressionAdaptor = luceneContext.getLuceneQueryParserAdaptor().getExpressionAdaptor();
        boolean must = false;
        boolean mustNot = false;
        for (Constraint constraint : this.getConstraints()) {
            if (constraint instanceof LuceneQueryBuilderComponent) {
                LuceneQueryBuilderComponent luceneQueryBuilderComponent = (LuceneQueryBuilderComponent)((Object)constraint);
                Q constraintQuery = luceneQueryBuilderComponent.addComponent(selectors, functionArgs, luceneContext, functionContext);
                if (constraintQuery == null) continue;
                switch (constraint.getOccur()) {
                    case DEFAULT: 
                    case MANDATORY: {
                        expressionAdaptor.addRequired(constraintQuery, constraint.getBoost());
                        must = true;
                        break;
                    }
                    case OPTIONAL: {
                        expressionAdaptor.addOptional(constraintQuery, constraint.getBoost());
                        break;
                    }
                    case EXCLUDE: {
                        expressionAdaptor.addExcluded(constraintQuery, constraint.getBoost());
                        mustNot = true;
                    }
                }
                continue;
            }
            throw new UnsupportedOperationException();
        }
        if (!must && mustNot) {
            expressionAdaptor.addRequired(luceneContext.getLuceneQueryParserAdaptor().getMatchAllNodesQuery());
        }
        return expressionAdaptor.getQuery();
    }
}

