/*
 * #%L
 * Alfresco Data model classes
 * %%
 * Copyright (C) 2005 - 2016 Alfresco Software Limited
 * %%
 * This file is part of the Alfresco software. 
 * If the software was purchased under a paid Alfresco license, the terms of 
 * the paid license agreement will prevail.  Otherwise, the software is 
 * provided under the following open source license terms:
 * 
 * Alfresco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Alfresco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with Alfresco. If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.alfresco.repo.dictionary;

import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.namespace.QName;

/**
 * Access to model items.
 * 
 * @author David Caruana
 *
 */
/* package */ interface ModelQuery
{
    /**
     * Gets the specified data type
     * 
     * @param name
     *            name of the data type
     * @return data type definition
     */
    public DataTypeDefinition getDataType(QName name);

    /**
     * Gets the data type for the specified Java Class
     * 
     * @param javaClass
     *            the java class
     * @return the data type definition (or null, if mapping is not available)
     */
    public DataTypeDefinition getDataType(Class javaClass);

    /**
     * Gets the specified type
     * 
     * @param name
     *            name of the type
     * @return type definition
     */
    public TypeDefinition getType(QName name);

    /**
     * Gets the specified aspect
     * 
     * @param name
     *            name of the aspect
     * @return aspect definition
     */
    public AspectDefinition getAspect(QName name);

    /**
     * Gets the specified class
     * 
     * @param name
     *            name of the class
     * @return class definition
     */
    public ClassDefinition getClass(QName name);

    /**
     * Gets the specified property
     * 
     * @param name
     *            name of the property
     * @return property definition
     */
    public PropertyDefinition getProperty(QName name);

    /**
     * Gets the specified property constraint
     * 
     * @param name
     *            the qualified name of the property constraint
     * @return ConstraintDefinition
     */
    public ConstraintDefinition getConstraint(QName name);

    /**
     * Gets the specified association
     * 
     * @param name
     *            name of the association
     * @return association definition
     */
    public AssociationDefinition getAssociation(QName name);

}
