/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import java.util.Date;
import java.util.HashSet;
import org.alfresco.repo.security.authentication.InMemoryTicketComponentImpl;
import org.alfresco.service.cmr.repository.datatype.Duration;
import org.junit.Assert;
import org.junit.Test;

public class InMemoryTicketComponentTest {
    @Test
    public void testTicketCollectionReadinessDoNotExpire() {
        Duration validDuration = new Duration("PT1H");
        InMemoryTicketComponentImpl.ExpiryMode expireMode = InMemoryTicketComponentImpl.ExpiryMode.DO_NOT_EXPIRE;
        String randomUserName = "someUserName";
        Date someDate = null;
        this.checkEqualsAndHashCode(validDuration, expireMode, someDate, "someUserName");
    }

    @Test
    public void testTicketCollectionReadinessAfterInactivity() {
        Duration validDuration = new Duration("PT1H");
        InMemoryTicketComponentImpl.ExpiryMode expireMode = InMemoryTicketComponentImpl.ExpiryMode.AFTER_INACTIVITY;
        String randomUserName = "someUserName";
        Date someDate = new Date();
        this.checkEqualsAndHashCode(validDuration, expireMode, someDate, "someUserName");
        this.checkInvalidExpireDateParameter(validDuration, expireMode, "someUserName");
    }

    @Test
    public void testTicketCollectionReadinessAfterFixTime() {
        Duration validDuration = new Duration("PT1H");
        InMemoryTicketComponentImpl.ExpiryMode expireMode = InMemoryTicketComponentImpl.ExpiryMode.AFTER_FIXED_TIME;
        String randomUserName = "someUserName";
        Date someDate = new Date();
        this.checkEqualsAndHashCode(validDuration, expireMode, someDate, "someUserName");
        this.checkInvalidExpireDateParameter(validDuration, expireMode, "someUserName");
    }

    private void checkEqualsAndHashCode(Duration validDuration, InMemoryTicketComponentImpl.ExpiryMode expireMode, Date someDate, String randomUserName) {
        InMemoryTicketComponentImpl.Ticket ticket1 = new InMemoryTicketComponentImpl.Ticket(expireMode, someDate, randomUserName, validDuration);
        InMemoryTicketComponentImpl.Ticket ticket2 = new InMemoryTicketComponentImpl.Ticket(expireMode, someDate, randomUserName, validDuration);
        ticket1.equals((Object)ticket2);
        HashSet<InMemoryTicketComponentImpl.Ticket> aSet = new HashSet<InMemoryTicketComponentImpl.Ticket>();
        for (int i = 0; i < 100000; ++i) {
            InMemoryTicketComponentImpl.Ticket ticket = new InMemoryTicketComponentImpl.Ticket(expireMode, someDate, randomUserName, validDuration);
            aSet.add(ticket);
        }
    }

    private void checkInvalidExpireDateParameter(Duration validDuration, InMemoryTicketComponentImpl.ExpiryMode expireMode, String randomUserName) {
        try {
            this.checkEqualsAndHashCode(validDuration, expireMode, null, randomUserName);
            Assert.fail((String)"expire date should not be allowed as null in this  expireMode case");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

