/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.repo.content.ContentContext;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.DirectAccessUrl;

@AlfrescoPublicApi
public interface ContentStore {
    public static final ContentContext NEW_CONTENT_CONTEXT = new ContentContext(null, null);
    public static final String PROTOCOL_DELIMITER = "://";

    public boolean isContentUrlSupported(String var1);

    public boolean isWriteSupported();

    public long getSpaceFree();

    public long getSpaceTotal();

    public String getRootLocation();

    public boolean exists(String var1);

    public ContentReader getReader(String var1);

    public ContentWriter getWriter(ContentContext var1);

    public boolean delete(String var1);

    default public boolean isContentDirectUrlEnabled() {
        return false;
    }

    default public boolean isContentDirectUrlEnabled(String contentUrl) {
        return false;
    }

    @Deprecated
    default public DirectAccessUrl requestContentDirectUrl(String contentUrl, boolean attachment, String fileName) {
        return this.requestContentDirectUrl(contentUrl, attachment, fileName, null, null);
    }

    default public DirectAccessUrl requestContentDirectUrl(String contentUrl, boolean attachment, String fileName, String mimetype) {
        return this.requestContentDirectUrl(contentUrl, attachment, fileName, mimetype, null);
    }

    @Deprecated
    default public DirectAccessUrl requestContentDirectUrl(String contentUrl, boolean attachment, String fileName, Long validFor) {
        return this.requestContentDirectUrl(contentUrl, attachment, fileName, null, validFor);
    }

    default public DirectAccessUrl requestContentDirectUrl(String contentUrl, boolean attachment, String fileName, String mimetype, Long validFor) {
        throw new UnsupportedOperationException("Retrieving direct access URLs is not supported by this content store.");
    }

    default public Map<String, String> getStorageProperties(String contentUrl) {
        return Collections.emptyMap();
    }

    default public boolean requestSendContentToArchive(String contentUrl, Map<String, Serializable> archiveParams) {
        throw new UnsupportedOperationException("Request to archive content is not supported by this content store.");
    }

    default public boolean requestRestoreContentFromArchive(String contentUrl, Map<String, Serializable> restoreParams) {
        throw new UnsupportedOperationException("Request to restore content from archive is not supported by this content store.");
    }
}

