/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary.constraint;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.dictionary.constraint.AbstractConstraint;
import org.alfresco.service.cmr.dictionary.ConstraintException;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;

public class NumericRangeConstraint
extends AbstractConstraint {
    private static final String ERR_INVALID_MIN_VALUE = "d_dictionary.constraint.numeric_range.invalid_min_value";
    private static final String ERR_INVALID_MAX_VALUE = "d_dictionary.constraint.numeric_range.invalid_max_value";
    private static final String ERR_NON_NUMERIC = "d_dictionary.constraint.numeric_range.non_numeric";
    private static final String ERR_OUT_OF_RANGE = "d_dictionary.constraint.numeric_range.out_of_range";
    private double minValue = Double.MIN_VALUE;
    private double maxValue = Double.MAX_VALUE;

    @Override
    public String getType() {
        return "MINMAX";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(80);
        sb.append("NumericRangeConstraint").append("[ minValue=").append(this.minValue).append(", maxValue=").append(this.maxValue).append("]");
        return sb.toString();
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double minValue) {
        if (minValue > this.maxValue) {
            throw new DictionaryException(ERR_INVALID_MIN_VALUE, minValue);
        }
        this.minValue = minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double maxValue) {
        if (maxValue < this.minValue) {
            throw new DictionaryException(ERR_INVALID_MAX_VALUE, maxValue);
        }
        this.maxValue = maxValue;
    }

    @Override
    public Map<String, Object> getParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("minValue", this.minValue);
        params.put("maxValue", this.maxValue);
        return params;
    }

    @Override
    protected void evaluateSingleValue(Object value) {
        double checkValue = Double.NaN;
        try {
            checkValue = DefaultTypeConverter.INSTANCE.doubleValue(value);
        }
        catch (NumberFormatException e) {
            throw new ConstraintException(ERR_NON_NUMERIC, value);
        }
        if (Double.isInfinite(checkValue) || Double.isNaN(checkValue)) {
            throw new ConstraintException(ERR_OUT_OF_RANGE, checkValue, this.minValue, this.maxValue);
        }
        if (checkValue > this.maxValue || checkValue < this.minValue) {
            throw new ConstraintException(ERR_OUT_OF_RANGE, checkValue, this.minValue, this.maxValue);
        }
    }
}

