/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum MLAnalysisMode {
    LOCALE_ONLY{

        @Override
        public boolean includesAll() {
            return false;
        }

        @Override
        public boolean includesContained() {
            return false;
        }

        @Override
        public boolean includesContaining() {
            return false;
        }

        @Override
        public boolean includesExact() {
            return true;
        }

        @Override
        public boolean includesAllLanguageMatches() {
            return false;
        }

        @Override
        public boolean includesExactLanguageMatch() {
            return false;
        }

        @Override
        public boolean includesAllCountryMatches() {
            return false;
        }

        @Override
        public boolean includesExactCountryMatch() {
            return false;
        }
    }
    ,
    LOCALE_AND_ALL{

        @Override
        public boolean includesAll() {
            return true;
        }

        @Override
        public boolean includesContained() {
            return false;
        }

        @Override
        public boolean includesContaining() {
            return false;
        }

        @Override
        public boolean includesExact() {
            return true;
        }

        @Override
        public boolean includesAllLanguageMatches() {
            return false;
        }

        @Override
        public boolean includesExactLanguageMatch() {
            return false;
        }

        @Override
        public boolean includesAllCountryMatches() {
            return false;
        }

        @Override
        public boolean includesExactCountryMatch() {
            return false;
        }
    }
    ,
    LOCALE_AND_ALL_CONTAINING_LOCALES{

        @Override
        public boolean includesAll() {
            return false;
        }

        @Override
        public boolean includesContained() {
            return false;
        }

        @Override
        public boolean includesContaining() {
            return true;
        }

        @Override
        public boolean includesExact() {
            return true;
        }

        @Override
        public boolean includesAllLanguageMatches() {
            return false;
        }

        @Override
        public boolean includesExactLanguageMatch() {
            return false;
        }

        @Override
        public boolean includesAllCountryMatches() {
            return false;
        }

        @Override
        public boolean includesExactCountryMatch() {
            return false;
        }
    }
    ,
    LOCALE_AND_ALL_CONTAINING_LOCALES_AND_ALL{

        @Override
        public boolean includesAll() {
            return true;
        }

        @Override
        public boolean includesContained() {
            return false;
        }

        @Override
        public boolean includesContaining() {
            return true;
        }

        @Override
        public boolean includesExact() {
            return true;
        }

        @Override
        public boolean includesAllLanguageMatches() {
            return false;
        }

        @Override
        public boolean includesExactLanguageMatch() {
            return false;
        }

        @Override
        public boolean includesAllCountryMatches() {
            return false;
        }

        @Override
        public boolean includesExactCountryMatch() {
            return false;
        }
    }
    ,
    LOCALE_AND_ALL_CONTAINED_LOCALES{

        @Override
        public boolean includesAll() {
            return false;
        }

        @Override
        public boolean includesContained() {
            return true;
        }

        @Override
        public boolean includesContaining() {
            return false;
        }

        @Override
        public boolean includesExact() {
            return true;
        }

        @Override
        public boolean includesAllLanguageMatches() {
            return false;
        }

        @Override
        public boolean includesExactLanguageMatch() {
            return false;
        }

        @Override
        public boolean includesAllCountryMatches() {
            return false;
        }

        @Override
        public boolean includesExactCountryMatch() {
            return false;
        }
    }
    ,
    ALL_ONLY{

        @Override
        public boolean includesAll() {
            return true;
        }

        @Override
        public boolean includesContained() {
            return false;
        }

        @Override
        public boolean includesContaining() {
            return false;
        }

        @Override
        public boolean includesExact() {
            return false;
        }

        @Override
        public boolean includesAllLanguageMatches() {
            return false;
        }

        @Override
        public boolean includesExactLanguageMatch() {
            return false;
        }

        @Override
        public boolean includesAllCountryMatches() {
            return false;
        }

        @Override
        public boolean includesExactCountryMatch() {
            return false;
        }
    }
    ,
    ALL_LANGUAGES{

        @Override
        public boolean includesAll() {
            return false;
        }

        @Override
        public boolean includesContained() {
            return false;
        }

        @Override
        public boolean includesContaining() {
            return false;
        }

        @Override
        public boolean includesExact() {
            return false;
        }

        @Override
        public boolean includesAllLanguageMatches() {
            return true;
        }

        @Override
        public boolean includesExactLanguageMatch() {
            return false;
        }

        @Override
        public boolean includesAllCountryMatches() {
            return false;
        }

        @Override
        public boolean includesExactCountryMatch() {
            return false;
        }
    }
    ,
    ALL_LANGUAGES_AND_ALL{

        @Override
        public boolean includesAll() {
            return true;
        }

        @Override
        public boolean includesContained() {
            return false;
        }

        @Override
        public boolean includesContaining() {
            return false;
        }

        @Override
        public boolean includesExact() {
            return false;
        }

        @Override
        public boolean includesAllLanguageMatches() {
            return true;
        }

        @Override
        public boolean includesExactLanguageMatch() {
            return false;
        }

        @Override
        public boolean includesAllCountryMatches() {
            return false;
        }

        @Override
        public boolean includesExactCountryMatch() {
            return false;
        }
    }
    ,
    EXACT_LANGUAGE{

        @Override
        public boolean includesAll() {
            return false;
        }

        @Override
        public boolean includesContained() {
            return false;
        }

        @Override
        public boolean includesContaining() {
            return false;
        }

        @Override
        public boolean includesExact() {
            return false;
        }

        @Override
        public boolean includesAllLanguageMatches() {
            return false;
        }

        @Override
        public boolean includesExactLanguageMatch() {
            return true;
        }

        @Override
        public boolean includesAllCountryMatches() {
            return false;
        }

        @Override
        public boolean includesExactCountryMatch() {
            return false;
        }
    }
    ,
    EXACT_LANGUAGE_AND_ALL{

        @Override
        public boolean includesAll() {
            return true;
        }

        @Override
        public boolean includesContained() {
            return false;
        }

        @Override
        public boolean includesContaining() {
            return false;
        }

        @Override
        public boolean includesExact() {
            return false;
        }

        @Override
        public boolean includesAllLanguageMatches() {
            return false;
        }

        @Override
        public boolean includesExactLanguageMatch() {
            return true;
        }

        @Override
        public boolean includesAllCountryMatches() {
            return false;
        }

        @Override
        public boolean includesExactCountryMatch() {
            return false;
        }
    }
    ,
    EXACT_COUNRTY{

        @Override
        public boolean includesAll() {
            return false;
        }

        @Override
        public boolean includesContained() {
            return false;
        }

        @Override
        public boolean includesContaining() {
            return false;
        }

        @Override
        public boolean includesExact() {
            return false;
        }

        @Override
        public boolean includesAllLanguageMatches() {
            return false;
        }

        @Override
        public boolean includesExactLanguageMatch() {
            return false;
        }

        @Override
        public boolean includesAllCountryMatches() {
            return false;
        }

        @Override
        public boolean includesExactCountryMatch() {
            return true;
        }
    }
    ,
    EXACT_COUNTRY_AND_ALL{

        @Override
        public boolean includesAll() {
            return true;
        }

        @Override
        public boolean includesContained() {
            return false;
        }

        @Override
        public boolean includesContaining() {
            return false;
        }

        @Override
        public boolean includesExact() {
            return false;
        }

        @Override
        public boolean includesAllLanguageMatches() {
            return false;
        }

        @Override
        public boolean includesExactLanguageMatch() {
            return false;
        }

        @Override
        public boolean includesAllCountryMatches() {
            return false;
        }

        @Override
        public boolean includesExactCountryMatch() {
            return true;
        }
    }
    ,
    ALL_COUNTRIES{

        @Override
        public boolean includesAll() {
            return false;
        }

        @Override
        public boolean includesContained() {
            return false;
        }

        @Override
        public boolean includesContaining() {
            return false;
        }

        @Override
        public boolean includesExact() {
            return false;
        }

        @Override
        public boolean includesAllLanguageMatches() {
            return false;
        }

        @Override
        public boolean includesExactLanguageMatch() {
            return false;
        }

        @Override
        public boolean includesAllCountryMatches() {
            return true;
        }

        @Override
        public boolean includesExactCountryMatch() {
            return false;
        }
    }
    ,
    ALL_COUNTRIES_AND_ALL{

        @Override
        public boolean includesAll() {
            return true;
        }

        @Override
        public boolean includesContained() {
            return false;
        }

        @Override
        public boolean includesContaining() {
            return false;
        }

        @Override
        public boolean includesExact() {
            return false;
        }

        @Override
        public boolean includesAllLanguageMatches() {
            return false;
        }

        @Override
        public boolean includesExactLanguageMatch() {
            return false;
        }

        @Override
        public boolean includesAllCountryMatches() {
            return true;
        }

        @Override
        public boolean includesExactCountryMatch() {
            return false;
        }
    };


    public static MLAnalysisMode getMLAnalysisMode(String mode) {
        for (MLAnalysisMode test : MLAnalysisMode.values()) {
            if (!test.toString().equalsIgnoreCase(mode)) continue;
            return test;
        }
        throw new AlfrescoRuntimeException("Unknown ML Analysis mode " + mode);
    }

    public abstract boolean includesAll();

    public abstract boolean includesContained();

    public abstract boolean includesContaining();

    public abstract boolean includesExact();

    public abstract boolean includesAllLanguageMatches();

    public abstract boolean includesExactLanguageMatch();

    public abstract boolean includesAllCountryMatches();

    public abstract boolean includesExactCountryMatch();

    public static Set<Locale> getLocales(MLAnalysisMode mlAnalaysisMode, Locale locale, boolean withWildcards) {
        boolean v;
        HashSet<Locale> locales = new HashSet<Locale>();
        boolean l = locale.getLanguage().length() != 0;
        boolean c = locale.getCountry().length() != 0;
        boolean bl = v = locale.getVariant().length() != 0;
        if (mlAnalaysisMode.includesAll()) {
            if (withWildcards) {
                locales.add(new Locale("", "", ""));
                locales.add(new Locale("*", "", ""));
            } else {
                locales.add(new Locale("", "", ""));
            }
        }
        if (mlAnalaysisMode.includesExact()) {
            locales.add(locale);
        }
        if (mlAnalaysisMode.includesContaining()) {
            if (v) {
                Locale noVarient = new Locale(locale.getLanguage(), locale.getCountry(), "");
                locales.add(noVarient);
                Locale noCountry = new Locale(locale.getLanguage(), "", "");
                locales.add(noCountry);
            }
            if (c) {
                Locale noCountry = new Locale(locale.getLanguage(), "", "");
                locales.add(noCountry);
            }
        }
        if (mlAnalaysisMode.includesContained() && !v) {
            if (!c) {
                if (!l) {
                    if (withWildcards) {
                        locales.add(new Locale("", "", ""));
                        locales.add(new Locale("*", "", ""));
                    } else {
                        for (Locale toAdd : Locale.getAvailableLocales()) {
                            locales.add(toAdd);
                        }
                    }
                } else if (withWildcards) {
                    locales.add(new Locale(locale.getLanguage(), "", ""));
                    locales.add(new Locale(locale.getLanguage(), "*", ""));
                } else {
                    for (Locale toAdd : Locale.getAvailableLocales()) {
                        if (!locale.getLanguage().equals("") && !locale.getLanguage().equals(toAdd.getLanguage())) continue;
                        locales.add(toAdd);
                    }
                }
            } else if (withWildcards) {
                locales.add(new Locale(locale.getLanguage(), locale.getCountry(), ""));
                locales.add(new Locale(locale.getLanguage(), locale.getCountry(), "*"));
            } else {
                for (Locale toAdd : Locale.getAvailableLocales()) {
                    if (!locale.getLanguage().equals("") && !locale.getLanguage().equals(toAdd.getLanguage()) || !locale.getCountry().equals("") && !locale.getCountry().equals(toAdd.getCountry())) continue;
                    locales.add(toAdd);
                }
            }
        }
        if (mlAnalaysisMode.includesAllLanguageMatches()) {
            if (withWildcards) {
                locales.add(new Locale(locale.getLanguage(), "", ""));
                locales.add(new Locale(locale.getLanguage(), "*", ""));
            } else {
                for (Locale toAdd : Locale.getAvailableLocales()) {
                    if (!locale.getLanguage().equals("") && !locale.getLanguage().equals(toAdd.getLanguage())) continue;
                    locales.add(toAdd);
                }
            }
        }
        if (mlAnalaysisMode.includesExactLanguageMatch()) {
            if (withWildcards) {
                locales.add(new Locale(locale.getLanguage(), "", ""));
            } else {
                locales.add(new Locale(locale.getLanguage(), "", ""));
            }
        }
        if (mlAnalaysisMode.includesAllCountryMatches()) {
            if (withWildcards) {
                locales.add(new Locale(locale.getLanguage(), locale.getCountry(), ""));
                if (locale.getCountry().equals("")) {
                    locales.add(new Locale(locale.getLanguage(), "*", ""));
                } else {
                    locales.add(new Locale(locale.getLanguage(), locale.getCountry(), "*"));
                }
            } else {
                for (Locale toAdd : Locale.getAvailableLocales()) {
                    if (!locale.getLanguage().equals("") && !locale.getLanguage().equals(toAdd.getLanguage()) || !locale.getCountry().equals("") && !locale.getCountry().equals(toAdd.getCountry())) continue;
                    locales.add(toAdd);
                }
            }
        }
        if (mlAnalaysisMode.includesExactCountryMatch()) {
            if (withWildcards) {
                if (locale.getCountry().equals("")) {
                    locales.add(new Locale(locale.getLanguage(), "", ""));
                    locales.add(new Locale(locale.getLanguage(), "*", ""));
                } else {
                    locales.add(new Locale(locale.getLanguage(), locale.getCountry(), ""));
                }
            } else if (locale.getCountry().equals("")) {
                for (Locale toAdd : Locale.getAvailableLocales()) {
                    if (!locale.getLanguage().equals("") && !locale.getLanguage().equals(toAdd.getLanguage())) continue;
                    locales.add(toAdd);
                }
            } else {
                locales.add(new Locale(locale.getLanguage(), locale.getCountry(), ""));
            }
        }
        return locales;
    }
}

