/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.namespace;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespacePrefixResolverProvider;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QNameMap<K, V>
implements Map,
Cloneable,
Serializable {
    private static final long serialVersionUID = -6578946123712939602L;
    protected static Log logger = LogFactory.getLog(QNameMap.class);
    protected Map<String, Object> contents = new HashMap<String, Object>(16, 1.0f);
    protected NamespacePrefixResolverProvider provider = null;

    public QNameMap(NamespacePrefixResolverProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("NamespacePrefixResolverProvider is mandatory.");
        }
        this.provider = provider;
    }

    protected QNameMap() {
    }

    protected final NamespacePrefixResolver getResolver() {
        return this.provider.getNamespacePrefixResolver();
    }

    @Override
    public final int size() {
        return this.contents.size();
    }

    @Override
    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.contents.containsKey(QName.resolveToQNameString(this.getResolver(), key.toString()));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.contents.containsValue(value);
    }

    public Object get(Object key) {
        String qnameKey = QName.resolveToQNameString(this.getResolver(), key.toString());
        Object obj = this.contents.get(qnameKey);
        return obj;
    }

    public Object put(Object key, Object value) {
        return this.contents.put(QName.resolveToQNameString(this.getResolver(), key.toString()), value);
    }

    public Object remove(Object key) {
        return this.contents.remove(QName.resolveToQNameString(this.getResolver(), key.toString()));
    }

    public void putAll(Map t) {
        for (Object key : t.keySet()) {
            this.put(key, t.get(key));
        }
    }

    @Override
    public void clear() {
        this.contents.clear();
    }

    public Set<String> keySet() {
        return this.contents.keySet();
    }

    public Collection values() {
        return this.contents.values();
    }

    public Set entrySet() {
        return this.contents.entrySet();
    }

    public String toString() {
        return this.contents.toString();
    }

    public Object clone() {
        QNameMap<K, V> map = new QNameMap<K, V>(this.provider);
        map.putAll((Map)this);
        return map;
    }

    public Map<QName, V> getMapOfQNames() {
        HashMap<QName, Object> map = new HashMap<QName, Object>(this.contents.size());
        for (Map.Entry<String, Object> entry : this.contents.entrySet()) {
            QName key = QName.createQName(entry.getKey());
            map.put(key, entry.getValue());
        }
        return map;
    }
}

