/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.io.IOException;
import java.util.Date;
import org.alfresco.util.ShutdownIndicator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public abstract class ConfigScheduler<Data> {
    public static final String CONFIG_SCHEDULER = "configScheduler";
    private static final Log defaultLog = LogFactory.getLog(ConfigScheduler.class);
    private static StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
    private final String jobName;
    private Log log;
    private CronExpression cronExpression;
    private CronExpression initialAndOnErrorCronExpression;
    private Scheduler scheduler;
    private JobKey jobKey;
    private boolean normalCronSchedule;
    protected Data data;
    private ThreadLocal<Data> threadData = ThreadLocal.withInitial(() -> this.data);
    private ShutdownIndicator shutdownIndicator;

    public ConfigScheduler(Object client) {
        this.jobName = client.getClass().getName() + "Job@" + Integer.toHexString(System.identityHashCode(client));
    }

    public void setShutdownIndicator(ShutdownIndicator shutdownIndicator) {
        this.shutdownIndicator = shutdownIndicator;
    }

    private boolean shuttingDown() {
        return this.shutdownIndicator != null && this.shutdownIndicator.isShuttingDown();
    }

    public abstract boolean readConfig() throws IOException;

    public abstract Data createData();

    public synchronized Data getData() {
        Data data = this.threadData.get();
        if (data == null) {
            data = this.createData();
            this.setData(data);
        }
        return data;
    }

    private synchronized void setData(Data data) {
        this.data = data;
        this.threadData = ThreadLocal.withInitial(() -> data);
    }

    private synchronized void clearData() {
        this.data = null;
        this.threadData.remove();
    }

    public void run(boolean enabled, Log log, CronExpression cronExpression, CronExpression initialAndOnErrorCronExpression) {
        this.clearPreviousSchedule();
        this.clearData();
        if (enabled) {
            this.log = log == null ? defaultLog : log;
            Date now = new Date();
            if (cronExpression != null && initialAndOnErrorCronExpression != null && cronExpression.getNextValidTimeAfter(now) != null && initialAndOnErrorCronExpression.getNextValidTimeAfter(now) != null) {
                this.cronExpression = cronExpression;
                this.initialAndOnErrorCronExpression = initialAndOnErrorCronExpression;
                this.schedule();
            } else {
                this.readConfigAndReplace(false);
            }
        }
    }

    private synchronized void schedule() {
        try {
            this.scheduler = schedulerFactory.getScheduler();
            JobDetail job = JobBuilder.newJob().withIdentity(this.jobName).ofType(ConfigSchedulerJob.class).build();
            this.jobKey = job.getKey();
            job.getJobDataMap().put(CONFIG_SCHEDULER, (Object)this);
            CronExpression cronExpression = this.normalCronSchedule ? this.cronExpression : this.initialAndOnErrorCronExpression;
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(this.jobName + "Trigger", "DEFAULT").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((CronExpression)cronExpression)).build();
            this.scheduler.startDelayed(0);
            this.scheduler.scheduleJob(job, (Trigger)trigger);
            this.log.debug((Object)("Schedule set " + String.valueOf(cronExpression)));
        }
        catch (Exception e) {
            this.log.error((Object)("Error scheduling " + e.getMessage()));
        }
    }

    private void clearPreviousSchedule() {
        if (this.scheduler != null) {
            try {
                this.scheduler.deleteJob(this.jobKey);
                this.scheduler = null;
                this.jobKey = null;
            }
            catch (Exception e) {
                this.log.error((Object)("Error clearing previous schedule " + e.getMessage()));
            }
        }
    }

    public boolean readConfigAndReplace(boolean scheduledRead) {
        boolean successReadingConfig = true;
        if (!this.shuttingDown()) {
            this.log.debug((Object)((scheduledRead ? "Scheduled" : "Unscheduled") + " config read started"));
            Data data = this.getData();
            try {
                Data newData = this.createData();
                this.threadData.set(newData);
                successReadingConfig = this.readConfig();
                data = newData;
                this.log.debug((Object)("Config read finished " + String.valueOf(data) + (successReadingConfig ? "" : ". Config replaced but there were problems") + "\n"));
            }
            catch (Exception e) {
                successReadingConfig = false;
                this.log.error((Object)("Config read failed. " + e.getMessage()), (Throwable)e);
            }
            this.setData(data);
        }
        return successReadingConfig;
    }

    private void changeScheduleOnStateChange(boolean successReadingConfig) {
        if (this.normalCronSchedule && !successReadingConfig || !this.normalCronSchedule && successReadingConfig) {
            this.normalCronSchedule = !this.normalCronSchedule;
            this.clearPreviousSchedule();
            this.schedule();
        }
    }

    public static class ConfigSchedulerJob
    implements Job {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(JobExecutionContext context) throws JobExecutionException {
            ConfigScheduler configScheduler;
            JobDataMap dataMap = context.getJobDetail().getJobDataMap();
            ConfigScheduler configScheduler2 = configScheduler = (ConfigScheduler)dataMap.get((Object)ConfigScheduler.CONFIG_SCHEDULER);
            synchronized (configScheduler2) {
                boolean successReadingConfig = configScheduler.readConfigAndReplace(true);
                configScheduler.changeScheduleOnStateChange(successReadingConfig);
            }
        }
    }
}

