/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.search.impl.querymodel.Argument;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.ListArgument;
import org.alfresco.repo.search.impl.querymodel.impl.BaseStaticArgument;

public class BaseListArgument
extends BaseStaticArgument
implements ListArgument {
    private List<Argument> arguments;

    public BaseListArgument(String name, List<Argument> arguments) {
        super(name, false, false);
        this.arguments = arguments;
    }

    @Override
    public List<Argument> getArguments() {
        return this.arguments;
    }

    @Override
    public Serializable getValue(FunctionEvaluationContext context) {
        ArrayList<Serializable> answer = new ArrayList<Serializable>(this.arguments.size());
        for (Argument argument : this.arguments) {
            Serializable value = argument.getValue(context);
            answer.add(value);
        }
        return answer;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BaseListArgument[");
        builder.append("name=").append(this.getName()).append(", ");
        builder.append("values=").append(this.getArguments());
        builder.append("]");
        return builder.toString();
    }

    @Override
    public boolean isQueryable() {
        for (Argument arg : this.arguments) {
            if (arg.isQueryable()) continue;
            return false;
        }
        return true;
    }
}

