/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.lucene.functions;

import java.util.Map;
import java.util.Set;
import org.alfresco.repo.search.adaptor.QueryParserAdaptor;
import org.alfresco.repo.search.impl.querymodel.Argument;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.PropertyArgument;
import org.alfresco.repo.search.impl.querymodel.impl.functions.FTSProximity;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilderComponent;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.QueryBuilderContext;

public class LuceneFTSProximity<Q, S, E extends Throwable>
extends FTSProximity
implements LuceneQueryBuilderComponent<Q, S, E> {
    @Override
    public Q addComponent(Set<String> selectors, Map<String, Argument> functionArgs, QueryBuilderContext<Q, S, E> luceneContext, FunctionEvaluationContext functionContext) throws E {
        Q query;
        PropertyArgument propArg;
        QueryParserAdaptor<Q, S, E> lqpa = luceneContext.getLuceneQueryParserAdaptor();
        Argument argument = functionArgs.get("First");
        String first = (String)((Object)argument.getValue(functionContext));
        argument = functionArgs.get("Last");
        String last = (String)((Object)argument.getValue(functionContext));
        int slop = 100;
        argument = functionArgs.get("Slop");
        if (argument != null) {
            String val = (String)((Object)argument.getValue(functionContext));
            try {
                slop = Integer.parseInt(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((propArg = (PropertyArgument)functionArgs.get("Property")) != null) {
            String prop = propArg.getPropertyName();
            query = lqpa.getSpanQuery(functionContext.getLuceneFieldName(prop), first, last, slop, true);
        } else {
            query = lqpa.getSpanQuery(lqpa.getField(), first, last, slop, true);
        }
        return query;
    }
}

