/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.mapping;

import java.io.Serializable;
import org.alfresco.opencmis.mapping.BaseLuceneBuilder;
import org.alfresco.repo.search.adaptor.AnalysisMode;
import org.alfresco.repo.search.adaptor.LuceneFunction;
import org.alfresco.repo.search.adaptor.QueryParserAdaptor;
import org.alfresco.repo.search.impl.querymodel.PredicateMode;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.namespace.QName;

public abstract class AbstractSimpleLuceneBuilder
extends BaseLuceneBuilder {
    protected AbstractSimpleLuceneBuilder() {
    }

    protected abstract String getValueAsString(Serializable var1);

    protected String getRangeMax() {
        return "\uffff";
    }

    protected String getRangeMin() {
        return "\u0000";
    }

    protected abstract DataTypeDefinition getInDataType();

    protected abstract QName getQNameForExists();

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneEquality(QueryParserAdaptor<Q, S, E> lqpa, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws E {
        return lqpa.getFieldQuery(this.getLuceneFieldName(), this.getValueAsString(value), AnalysisMode.IDENTIFIER, luceneFunction);
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneExists(QueryParserAdaptor<Q, S, E> lqpa, Boolean not) throws E {
        if (not.booleanValue()) {
            return lqpa.getFieldQuery("ISNULL", this.getQNameForExists().toString(), AnalysisMode.DEFAULT, LuceneFunction.FIELD);
        }
        return lqpa.getFieldQuery("ISNOTNULL", this.getQNameForExists().toString(), AnalysisMode.DEFAULT, LuceneFunction.FIELD);
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneGreaterThan(QueryParserAdaptor<Q, S, E> lqpa, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws E {
        String field = this.getLuceneFieldName();
        String stringValue = this.getValueAsString(value);
        return lqpa.getRangeQuery(field, stringValue, this.getRangeMax(), false, true, AnalysisMode.IDENTIFIER, luceneFunction);
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneGreaterThanOrEquals(QueryParserAdaptor<Q, S, E> lqpa, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws E {
        String field = this.getLuceneFieldName();
        String stringValue = this.getValueAsString(value);
        return lqpa.getRangeQuery(field, stringValue, this.getRangeMax(), true, true, AnalysisMode.IDENTIFIER, luceneFunction);
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneLessThan(QueryParserAdaptor<Q, S, E> lqpa, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws E {
        String field = this.getLuceneFieldName();
        String stringValue = this.getValueAsString(value);
        return lqpa.getRangeQuery(field, this.getRangeMin(), stringValue, true, false, AnalysisMode.IDENTIFIER, luceneFunction);
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneLessThanOrEquals(QueryParserAdaptor<Q, S, E> lqpa, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws E {
        String field = this.getLuceneFieldName();
        String stringValue = this.getValueAsString(value);
        return lqpa.getRangeQuery(field, this.getRangeMin(), stringValue, true, true, AnalysisMode.IDENTIFIER, luceneFunction);
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneLike(QueryParserAdaptor<Q, S, E> lqpa, Serializable value, Boolean not) throws E {
        String field = this.getLuceneFieldName();
        String stringValue = this.getValueAsString(value);
        Q q = lqpa.getLikeQuery(field, stringValue, AnalysisMode.IDENTIFIER);
        if (not.booleanValue()) {
            q = lqpa.getNegatedQuery(q);
        }
        return q;
    }

    @Override
    public <Q, S, E extends Throwable> String getLuceneSortField(QueryParserAdaptor<Q, S, E> lqpa) throws E {
        return this.getLuceneFieldName();
    }
}

