/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Label;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2Namespace;
import org.alfresco.repo.dictionary.M2NamespaceDefinition;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.dictionary.NamespaceDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;

public class M2ModelDefinition
implements ModelDefinition {
    private QName name;
    private M2Model model;
    private String analyserResourceBundleName;
    private DictionaryDAO dictionaryDAO;

    M2ModelDefinition(M2Model model, NamespacePrefixResolver resolver, DictionaryDAO dictionaryDAO) {
        this.name = QName.createQName(model.getName(), resolver);
        this.model = model;
        this.dictionaryDAO = dictionaryDAO;
    }

    @Override
    public QName getName() {
        return this.name;
    }

    @Override
    public String getDescription(MessageLookup messageLookup) {
        String value = M2Label.getLabel(this, messageLookup, null, null, "description");
        if (value == null) {
            value = this.model.getDescription();
        }
        return value;
    }

    @Override
    public String getAuthor() {
        return this.model.getAuthor();
    }

    @Override
    public Date getPublishedDate() {
        return this.model.getPublishedDate();
    }

    @Override
    public String getVersion() {
        return this.model.getVersion();
    }

    @Override
    public Collection<NamespaceDefinition> getNamespaces() {
        ArrayList<NamespaceDefinition> namespaces = new ArrayList<NamespaceDefinition>();
        for (M2Namespace namespace : this.model.getNamespaces()) {
            namespaces.add(new M2NamespaceDefinition(this, namespace.getUri(), namespace.getPrefix()));
        }
        return namespaces;
    }

    @Override
    public boolean isNamespaceDefined(String uri) {
        for (M2Namespace namespace : this.model.getNamespaces()) {
            if (!namespace.getUri().equals(uri)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<NamespaceDefinition> getImportedNamespaces() {
        ArrayList<NamespaceDefinition> namespaces = new ArrayList<NamespaceDefinition>();
        for (M2Namespace namespace : this.model.getImports()) {
            namespaces.add(new M2NamespaceDefinition(this, namespace.getUri(), namespace.getPrefix()));
        }
        return namespaces;
    }

    @Override
    public boolean isNamespaceImported(String uri) {
        for (M2Namespace namespace : this.model.getImports()) {
            if (!namespace.getUri().equals(uri)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void toXML(ModelDefinition.XMLBindingType bindingType, OutputStream xml) {
        this.model.toXML(bindingType, xml);
    }

    @Override
    public long getChecksum(ModelDefinition.XMLBindingType bindingType) {
        return this.model.getChecksum(bindingType);
    }

    @Override
    public DictionaryDAO getDictionaryDAO() {
        return this.dictionaryDAO;
    }
}

