/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import jakarta.servlet.ServletContext;
import java.io.IOException;
import org.alfresco.util.BaseApplicationContextHelper;
import org.apache.chemistry.opencmis.commons.server.CmisServiceFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.web.context.support.GenericWebApplicationContext;

public class WebApplicationContextLoader {
    private static ConfigurableApplicationContext instance;
    private static boolean useLazyLoading;
    private static boolean noAutoStart;

    public static synchronized ConfigurableApplicationContext getApplicationContext(ServletContext servletContext, String[] configLocations) {
        AbstractApplicationContext ctx = (AbstractApplicationContext)BaseApplicationContextHelper.getApplicationContext(configLocations);
        CmisServiceFactory factory = (CmisServiceFactory)ctx.getBean("CMISServiceFactory");
        DefaultListableBeanFactory dlbf = new DefaultListableBeanFactory((BeanFactory)ctx.getBeanFactory());
        GenericWebApplicationContext gwac = new GenericWebApplicationContext(dlbf);
        servletContext.setAttribute(GenericWebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)gwac);
        servletContext.setAttribute("org.apache.chemistry.opencmis.servicesfactory", (Object)factory);
        gwac.setServletContext(servletContext);
        gwac.refresh();
        return gwac;
    }

    public static synchronized ConfigurableApplicationContext getApplicationContext(ServletContext servletContext, String[] configLocations, String[] classLocations) throws IOException {
        AbstractApplicationContext ctx = (AbstractApplicationContext)BaseApplicationContextHelper.getApplicationContext(configLocations, classLocations);
        DefaultListableBeanFactory dlbf = new DefaultListableBeanFactory((BeanFactory)ctx.getBeanFactory());
        GenericWebApplicationContext gwac = new GenericWebApplicationContext(dlbf);
        CmisServiceFactory factory = (CmisServiceFactory)ctx.getBean("CMISServiceFactory");
        servletContext.setAttribute(GenericWebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)gwac);
        servletContext.setAttribute("org.apache.chemistry.opencmis.servicesfactory", (Object)factory);
        gwac.setServletContext(servletContext);
        gwac.refresh();
        return gwac;
    }

    public static void setUseLazyLoading(boolean lazyLoading) {
        useLazyLoading = lazyLoading;
    }

    public static boolean isUsingLazyLoading() {
        return useLazyLoading;
    }

    public static void setNoAutoStart(boolean noAutoStart) {
        WebApplicationContextLoader.noAutoStart = noAutoStart;
    }

    public static boolean isNoAutoStart() {
        return noAutoStart;
    }

    public static boolean isContextLoaded() {
        return instance != null;
    }

    static {
        useLazyLoading = false;
        noAutoStart = false;
    }

    protected static class WebApplicationContext
    extends GenericWebApplicationContext {
        protected WebApplicationContext(ServletContext servletContext, AbstractApplicationContext ctx) throws BeansException {
            super((DefaultListableBeanFactory)ctx.getBeanFactory(), servletContext);
        }
    }
}

