/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.search;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.alfresco.api.AlfrescoPublicApi;

@AlfrescoPublicApi
public class IntervalSet {
    private final String start;
    private final String end;
    private String label;
    private final boolean startInclusive;
    private final boolean endInclusive;

    @JsonCreator
    public IntervalSet(@JsonProperty(value="start") String start, @JsonProperty(value="end") String end, @JsonProperty(value="label") String label, @JsonProperty(value="startInclusive") Boolean startInclusive, @JsonProperty(value="endInclusive") Boolean endInclusive) {
        this.start = start;
        this.end = end;
        this.label = label;
        this.startInclusive = startInclusive == null ? true : startInclusive;
        this.endInclusive = endInclusive == null ? true : endInclusive;
    }

    public String getStart() {
        return this.start;
    }

    public String getEnd() {
        return this.end;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isStartInclusive() {
        return this.startInclusive;
    }

    public boolean isEndInclusive() {
        return this.endInclusive;
    }

    public String toParam() {
        StringBuilder sb = new StringBuilder("{!afts");
        if (this.label != null && !this.label.isEmpty()) {
            sb.append(" key=" + this.label);
        }
        sb.append("}").append(this.toRange());
        return sb.toString();
    }

    public String toRange() {
        StringBuilder sb = new StringBuilder("");
        sb.append(this.startInclusive ? "[" : "(").append(this.start).append("," + this.end).append(this.endInclusive ? "]" : ")");
        return sb.toString();
    }

    public String toAFTSQuery() {
        StringBuilder sb = new StringBuilder("");
        sb.append(this.startInclusive ? "[" : "<").append("\"").append(this.start).append("\"").append(" TO ").append("\"").append(this.end).append("\"").append(this.endInclusive ? "]" : ">");
        return sb.toString();
    }

    public String toString() {
        return "IntervalSet{start=" + this.start + ", end=" + this.end + ", label='" + this.label + "', startInclusive=" + this.startInclusive + ", endInclusive=" + this.endInclusive + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntervalSet that = (IntervalSet)o;
        if (this.startInclusive != that.startInclusive) {
            return false;
        }
        if (this.endInclusive != that.endInclusive) {
            return false;
        }
        if (this.start != null ? !this.start.equals(that.start) : that.start != null) {
            return false;
        }
        if (this.end != null ? !this.end.equals(that.end) : that.end != null) {
            return false;
        }
        return !(this.label != null ? !this.label.equals(that.label) : that.label != null);
    }

    public int hashCode() {
        int result = this.start != null ? this.start.hashCode() : 0;
        result = 31 * result + (this.end != null ? this.end.hashCode() : 0);
        result = 31 * result + (this.startInclusive ? 1 : 0);
        result = 31 * result + (this.endInclusive ? 1 : 0);
        return result;
    }
}

