/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import junit.framework.TestCase;
import org.alfresco.util.SearchLanguageConversion;

public class SearchLanguageConversionTest
extends TestCase {
    private static final String BAD_STRING = "\\ | ! \" \u00a3 $ % ^ & * ( ) _ { } [ ] @ # ~ ' : ; , . < > + ? / \\\\ \\* \\? \\_";

    public void testEscapeXPathLike() {
        String good = SearchLanguageConversion.escapeForXPathLike((String)BAD_STRING);
        SearchLanguageConversionTest.assertEquals((String)"Escaping for xpath failed", (String)"\\\\ | ! \" \u00a3 $ \\% ^ & * ( ) \\_ { } \\[ \\] @ # ~ ' : ; , . < > + ? / \\\\\\\\ \\\\* \\\\? \\\\\\_", (String)good);
    }

    public void testEscapeRegex() {
        String good = SearchLanguageConversion.escapeForRegex((String)BAD_STRING);
        SearchLanguageConversionTest.assertEquals((String)"Escaping for regex failed", (String)"\\\\ \\| ! \" \u00a3 \\$ % \\^ & \\* \\( \\) _ \\{ \\} \\[ \\] @ # ~ ' : ; , \\. < > \\+ \\? / \\\\\\\\ \\\\\\* \\\\\\? \\\\_", (String)good);
    }

    public void testEscapeLucene() {
        String good = SearchLanguageConversion.escapeForLucene((String)BAD_STRING);
        SearchLanguageConversionTest.assertEquals((String)"Escaping for Lucene failed", (String)"\\\\ \\| \\! \\\" \u00a3 $ % \\^ \\& \\* \\( \\) _ \\{ \\} \\[ \\] @ # \\~ ' \\: ; , . < > \\+ \\? \\/ \\\\\\\\ \\\\\\* \\\\\\? \\\\_", (String)good);
    }

    public void testConvertXPathLikeToRegex() {
        String good = SearchLanguageConversion.convertXPathLikeToRegex((String)BAD_STRING);
        SearchLanguageConversionTest.assertEquals((String)"XPath like to regex failed", (String)"(?s) \\| ! \" \u00a3 \\$ .* \\^ & \\* \\( \\) . \\{ \\} \\[ \\] @ # ~ ' : ; , \\. < > \\+ \\? / \\\\ \\* \\? _", (String)good);
    }

    public void testConvertXPathLikeToLucene() {
        String good = SearchLanguageConversion.convertXPathLikeToLucene((String)BAD_STRING);
        SearchLanguageConversionTest.assertEquals((String)"XPath like to Lucene failed", (String)" \\| \\! \\\" \u00a3 $ * \\^ \\& \\* \\( \\) ? \\{ \\} \\[ \\] @ # \\~ ' \\: ; , . < > \\+ \\? \\/ \\\\ \\* \\? _", (String)good);
    }

    public void testSqlToLucene() {
        String sqlLike = "AB%_*?\\%\\_";
        String lucene = "AB*?\\*\\?%_";
        String converted = SearchLanguageConversion.convert((SearchLanguageConversion.LanguageDefinition)SearchLanguageConversion.DEF_SQL_LIKE, (SearchLanguageConversion.LanguageDefinition)SearchLanguageConversion.DEF_LUCENE, (String)sqlLike);
        SearchLanguageConversionTest.assertEquals((String)lucene, (String)converted);
    }

    public void testLuceneToRegexp() {
        String lucene = "AB*?\\*\\?.*.";
        String regexp = "AB.*.\\*\\?\\..*\\.";
        String converted = SearchLanguageConversion.convert((SearchLanguageConversion.LanguageDefinition)SearchLanguageConversion.DEF_LUCENE, (SearchLanguageConversion.LanguageDefinition)SearchLanguageConversion.DEF_REGEX, (String)lucene);
        SearchLanguageConversionTest.assertEquals((String)regexp, (String)converted);
    }

    public void testLuceneToSql() {
        String lucene = "%_";
        String sql = "\\%\\_";
        String converted = SearchLanguageConversion.convert((SearchLanguageConversion.LanguageDefinition)SearchLanguageConversion.DEF_LUCENE, (SearchLanguageConversion.LanguageDefinition)SearchLanguageConversion.DEF_SQL_LIKE, (String)lucene);
        SearchLanguageConversionTest.assertEquals((String)sql, (String)converted);
    }

    public void testTokenizeString() {
        String[] res = SearchLanguageConversion.tokenizeString((String)"");
        SearchLanguageConversionTest.assertTrue((res.length == 1 ? 1 : 0) != 0);
        res = SearchLanguageConversion.tokenizeString((String)"bob");
        SearchLanguageConversionTest.assertTrue((res.length == 1 ? 1 : 0) != 0);
        SearchLanguageConversionTest.assertEquals((String)"bob", (String)res[0]);
        res = SearchLanguageConversion.tokenizeString((String)"   bob   ");
        SearchLanguageConversionTest.assertTrue((res.length == 1 ? 1 : 0) != 0);
        SearchLanguageConversionTest.assertEquals((String)"bob", (String)res[0]);
        res = SearchLanguageConversion.tokenizeString((String)"   bob hope ");
        SearchLanguageConversionTest.assertTrue((res.length == 2 ? 1 : 0) != 0);
        SearchLanguageConversionTest.assertEquals((String)"bob", (String)res[0]);
        SearchLanguageConversionTest.assertEquals((String)"hope", (String)res[1]);
        res = SearchLanguageConversion.tokenizeString((String)"   bob    hope ");
        SearchLanguageConversionTest.assertTrue((res.length == 2 ? 1 : 0) != 0);
        SearchLanguageConversionTest.assertEquals((String)"bob", (String)res[0]);
        SearchLanguageConversionTest.assertEquals((String)"hope", (String)res[1]);
        res = SearchLanguageConversion.tokenizeString((String)"    bob  no    hope  ");
        SearchLanguageConversionTest.assertTrue((res.length == 3 ? 1 : 0) != 0);
        SearchLanguageConversionTest.assertEquals((String)"bob", (String)res[0]);
        SearchLanguageConversionTest.assertEquals((String)"no", (String)res[1]);
        SearchLanguageConversionTest.assertEquals((String)"hope", (String)res[2]);
    }
}

