/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.dictionary;

import java.io.Serializable;
import org.alfresco.opencmis.dictionary.CMISAbstractDictionaryService;
import org.alfresco.opencmis.dictionary.CMISDictionaryRegistry;
import org.alfresco.opencmis.dictionary.CMISDictionaryRegistryImpl;
import org.alfresco.repo.cache.MemoryCache;
import org.alfresco.repo.cache.SimpleCache;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CMISAbstractDictionaryServiceTest {
    private CMISAbstractDictionaryService dictService;
    private SimpleCache<String, CMISDictionaryRegistry> cache;
    private boolean initCalled;
    private CMISDictionaryRegistry dictRegistry;

    @Before
    public void setUp() throws Exception {
        this.dictService = new CMISAbstractDictionaryService(){

            protected CMISDictionaryRegistry getRegistry() {
                CMISAbstractDictionaryServiceTest.this.initCalled = true;
                CMISAbstractDictionaryServiceTest.this.cache.put((Serializable)((Object)"cache_key"), (Object)CMISAbstractDictionaryServiceTest.this.dictRegistry);
                return CMISAbstractDictionaryServiceTest.this.dictRegistry;
            }

            protected CMISAbstractDictionaryService.DictionaryInitializer getCoreDictionaryInitializer() {
                return null;
            }

            protected CMISAbstractDictionaryService.DictionaryInitializer getTenantDictionaryInitializer() {
                return null;
            }
        };
        this.dictRegistry = new CMISDictionaryRegistryImpl();
        this.cache = new MemoryCache();
        this.dictService.setSingletonCache(this.cache);
        this.initCalled = false;
    }

    @Test
    public void canGetRegistryWhenInitNotYetCalled() {
        Assert.assertFalse((boolean)this.initCalled);
        CMISDictionaryRegistry registry = this.dictService.getRegistry();
        Assert.assertTrue((String)"init() should have been called.", (boolean)this.initCalled);
        Assert.assertSame((Object)this.dictRegistry, (Object)registry);
    }

    @Test
    public void canGetRegistryWhenInitAlreadyCalled() {
        this.dictService.getRegistry();
        Assert.assertTrue((boolean)this.initCalled);
        CMISDictionaryRegistry registry = this.dictService.getRegistry();
        Assert.assertTrue((String)"init() should have been called.", (boolean)this.initCalled);
        Assert.assertSame((Object)this.dictRegistry, (Object)registry);
    }
}

