/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.opencmis.mapping.BaseLuceneBuilder;
import org.alfresco.repo.search.adaptor.AnalysisMode;
import org.alfresco.repo.search.adaptor.LuceneFunction;
import org.alfresco.repo.search.adaptor.QueryParserAdaptor;
import org.alfresco.repo.search.impl.querymodel.PredicateMode;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;

public class ParentLuceneBuilder
extends BaseLuceneBuilder {
    private DictionaryService dictionaryService;

    public ParentLuceneBuilder(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    private <Q, S, E extends Throwable> StoreRef getStore(QueryParserAdaptor<Q, S, E> lqpa) {
        List stores = lqpa.getSearchParameters().getStores();
        if (((ArrayList)stores).size() < 1) {
            return StoreRef.STORE_REF_WORKSPACE_SPACESSTORE;
        }
        return (StoreRef)((ArrayList)stores).get(0);
    }

    @Override
    public String getLuceneFieldName() {
        return "PARENT";
    }

    private <Q, S, E extends Throwable> String getValueAsString(QueryParserAdaptor<Q, S, E> lqpa, Serializable value) {
        Object nodeRefStr = (String)((Object)value);
        if (!NodeRef.isNodeRef((String)((Object)value))) {
            StoreRef storeRef = this.getStore(lqpa);
            nodeRefStr = storeRef.toString() + "/" + (String)((Object)value);
        }
        Object converted = DefaultTypeConverter.INSTANCE.convert(this.dictionaryService.getDataType(DataTypeDefinition.NODE_REF), nodeRefStr);
        String asString = DefaultTypeConverter.INSTANCE.convert(String.class, converted);
        return asString;
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneEquality(QueryParserAdaptor<Q, S, E> lqpa, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws E {
        String field = this.getLuceneFieldName();
        String stringValue = this.getValueAsString(lqpa, value);
        return lqpa.getFieldQuery(field, stringValue, AnalysisMode.IDENTIFIER, luceneFunction);
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneExists(QueryParserAdaptor<Q, S, E> lqpa, Boolean not) throws E {
        if (not.booleanValue()) {
            return lqpa.getFieldQuery("ISROOT", "T", AnalysisMode.IDENTIFIER, LuceneFunction.FIELD);
        }
        return lqpa.getNegatedQuery(lqpa.getFieldQuery("ISROOT", "T", AnalysisMode.IDENTIFIER, LuceneFunction.FIELD));
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneLike(QueryParserAdaptor<Q, S, E> lqpa, Serializable value, Boolean not) throws E {
        String field = this.getLuceneFieldName();
        String stringValue = this.getValueAsString(lqpa, value);
        Q q = lqpa.getLikeQuery(field, stringValue, AnalysisMode.IDENTIFIER);
        if (not.booleanValue()) {
            return lqpa.getNegatedQuery(q);
        }
        return q;
    }

    @Override
    public <Q, S, E extends Throwable> String getLuceneSortField(QueryParserAdaptor<Q, S, E> lqpa) {
        return this.getLuceneFieldName();
    }
}

