/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.search.impl.querymodel.Argument;
import org.alfresco.repo.search.impl.querymodel.Constraint;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.FunctionalConstraint;
import org.alfresco.repo.search.impl.querymodel.Join;
import org.alfresco.repo.search.impl.querymodel.JoinType;
import org.alfresco.repo.search.impl.querymodel.PropertyArgument;
import org.alfresco.repo.search.impl.querymodel.Selector;
import org.alfresco.repo.search.impl.querymodel.Source;
import org.alfresco.repo.search.impl.querymodel.impl.DuplicateSelectorNameException;

public class BaseJoin
implements Join {
    private Constraint joinConstraint;
    private JoinType joinType;
    private Source left;
    private Source right;

    public BaseJoin(Source left, Source right, JoinType joinType, Constraint joinConstraint) {
        this.left = left;
        this.right = right;
        this.joinType = joinType;
        this.joinConstraint = joinConstraint;
    }

    @Override
    public Constraint getJoinCondition() {
        return this.joinConstraint;
    }

    @Override
    public JoinType getJoinType() {
        return this.joinType;
    }

    @Override
    public Source getLeft() {
        return this.left;
    }

    @Override
    public Source getRight() {
        return this.right;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BaseJoin[");
        builder.append("Left=" + String.valueOf(this.getLeft())).append(", ");
        builder.append("Right=" + String.valueOf(this.getRight())).append(", ");
        builder.append("JoinType=" + String.valueOf((Object)this.getJoinType())).append(", ");
        builder.append("Condition=" + String.valueOf(this.getJoinCondition()));
        builder.append("]");
        return builder.toString();
    }

    @Override
    public Map<String, Selector> getSelectors() {
        HashMap<String, Selector> answer = new HashMap<String, Selector>();
        Map<String, Selector> leftSelectors = this.left.getSelectors();
        for (String selectorName : leftSelectors.keySet()) {
            Selector selector;
            if (answer.put(selectorName, selector = leftSelectors.get(selectorName)) == null) continue;
            throw new DuplicateSelectorNameException("There is a duplicate selector name for " + selectorName);
        }
        Map<String, Selector> rightSelectors = this.right.getSelectors();
        for (String selectorName : rightSelectors.keySet()) {
            Selector selector;
            if (answer.put(selectorName, selector = rightSelectors.get(selectorName)) == null) continue;
            throw new DuplicateSelectorNameException("There is a duplicate selector name for " + selectorName);
        }
        return answer;
    }

    @Override
    public Selector getSelector(String name) {
        Map<String, Selector> answer = this.getSelectors();
        return answer.get(name);
    }

    @Override
    public List<Set<String>> getSelectorGroups(FunctionEvaluationContext functionContext) {
        PropertyArgument propertyArgument;
        String name;
        ArrayList<Set<String>> answer = new ArrayList<Set<String>>();
        List<Set<String>> left = this.getLeft().getSelectorGroups(functionContext);
        List<Set<String>> right = this.getRight().getSelectorGroups(functionContext);
        FunctionalConstraint joinCondition = (FunctionalConstraint)this.getJoinCondition();
        if (!joinCondition.getFunction().getName().equals("Equals")) {
            throw new UnsupportedOperationException("Only equi-joins are supported");
        }
        Argument lhs = joinCondition.getFunctionArguments().get("LHS");
        Argument rhs = joinCondition.getFunctionArguments().get("RHS");
        String lhsSelector = null;
        String rhsSelector = null;
        if (lhs instanceof PropertyArgument && functionContext.isObjectId(name = (propertyArgument = (PropertyArgument)lhs).getPropertyName())) {
            lhsSelector = propertyArgument.getSelector();
        }
        if (rhs instanceof PropertyArgument && functionContext.isObjectId(name = (propertyArgument = (PropertyArgument)rhs).getPropertyName())) {
            rhsSelector = propertyArgument.getSelector();
        }
        if ((this.getJoinType() == JoinType.INNER || this.getJoinType() == JoinType.LEFT) && lhsSelector != null && rhsSelector != null) {
            block0: for (Set<String> toAddTo : left) {
                if (toAddTo.contains(lhsSelector)) {
                    for (Set<String> toMove : right) {
                        if (!toMove.contains(rhsSelector)) continue;
                        toAddTo.addAll(toMove);
                        toMove.clear();
                        break block0;
                    }
                } else {
                    if (!toAddTo.contains(rhsSelector)) continue;
                    for (Set<String> toMove : right) {
                        if (!toMove.contains(lhsSelector)) continue;
                        toAddTo.addAll(toMove);
                        toMove.clear();
                        break block0;
                    }
                }
                break;
            }
        }
        for (Set<String> group : left) {
            if (group.size() <= 0) continue;
            answer.add(group);
        }
        for (Set<String> group : right) {
            if (group.size() <= 0) continue;
            answer.add(group);
        }
        return answer;
    }

    @Override
    public void setJoinType(JoinType joinType) {
        this.joinType = joinType;
    }
}

