/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.repo.dictionary.CompiledModel;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.DictionaryRegistry;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2Namespace;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractDictionaryRegistry
implements DictionaryRegistry {
    protected static final Log logger = LogFactory.getLog(AbstractDictionaryRegistry.class);
    protected DictionaryDAO dictionaryDAO;
    private Map<String, List<CompiledModel>> uriToModels = new ConcurrentHashMap<String, List<CompiledModel>>(0);
    private Map<QName, CompiledModel> compiledModels = new ConcurrentHashMap<QName, CompiledModel>(0);
    private ReadWriteLock urisCacheRWLock = new ReentrantReadWriteLock(true);
    private List<String> urisCache = new ArrayList<String>(20);
    private Map<String, String> prefixesCache = new ConcurrentHashMap<String, String>(0);

    public AbstractDictionaryRegistry(DictionaryDAO dictionaryDAO) {
        this.dictionaryDAO = dictionaryDAO;
    }

    @Override
    public void clear() {
        this.setCompiledModels(new HashMap<QName, CompiledModel>());
        this.setUriToModels(new HashMap<String, List<CompiledModel>>());
    }

    @Override
    public Map<String, List<CompiledModel>> getUriToModels() {
        HashMap<String, List<CompiledModel>> ret = new HashMap<String, List<CompiledModel>>();
        ret.putAll(this.uriToModels);
        return ret;
    }

    private void setUriToModels(Map<String, List<CompiledModel>> uriToModels) {
        this.uriToModels = uriToModels;
    }

    @Override
    public Map<QName, CompiledModel> getCompiledModels(boolean includeInherited) {
        return this.compiledModels;
    }

    private void setCompiledModels(Map<QName, CompiledModel> compiledModels) {
        this.compiledModels = compiledModels;
    }

    @Override
    public List<CompiledModel> getModelsForUri(String uri) {
        return this.getModelsForUriImpl(uri);
    }

    @Override
    public QName putModel(CompiledModel model) {
        return this.putModelImpl(model);
    }

    @Override
    public CompiledModel getModel(QName modelName) {
        CompiledModel model = this.getModelImpl(modelName);
        if (model == null) {
            throw new DictionaryException("d_dictionary.model.err.no_model", modelName);
        }
        return model;
    }

    @Override
    public boolean modelExists(QName modelName) {
        CompiledModel model = this.getModelImpl(modelName);
        return model != null;
    }

    @Override
    public void removeModel(QName modelName) {
        this.removeModelImpl(modelName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompiledModel removeModelImpl(QName modelName) {
        CompiledModel compiledModel = this.compiledModels.get(modelName);
        if (compiledModel != null) {
            M2Model model = compiledModel.getM2Model();
            for (M2Namespace namespace : model.getNamespaces()) {
                this.prefixesCache.remove(namespace.getPrefix());
                this.urisCacheRWLock.writeLock().lock();
                try {
                    this.urisCache.remove(namespace.getUri());
                }
                finally {
                    this.urisCacheRWLock.writeLock().unlock();
                }
                List<CompiledModel> models = this.uriToModels.get(namespace.getUri());
                if (models == null) continue;
                models.remove(compiledModel);
            }
            this.compiledModels.remove(modelName);
        }
        return compiledModel;
    }

    protected CompiledModel getModelImpl(QName modelName) {
        CompiledModel model = this.compiledModels.get(modelName);
        return model;
    }

    protected List<CompiledModel> getModelsForUriImpl(String uri) {
        List<CompiledModel> models = this.uriToModels.get(uri);
        if (models == null) {
            models = Collections.emptyList();
        }
        return new ArrayList<CompiledModel>(models);
    }

    protected void unmapUriToModel(String uri, CompiledModel model) {
        List<CompiledModel> models = this.uriToModels.get(uri);
        if (models != null) {
            models.remove(model);
        }
    }

    protected void mapUriToModel(String uri, CompiledModel model) {
        List<CompiledModel> models = this.uriToModels.get(uri);
        if (models == null) {
            models = new ArrayList<CompiledModel>();
            this.uriToModels.put(uri, models);
        }
        if (!models.contains(model)) {
            models.add(model);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected QName putModelImpl(CompiledModel model) {
        QName modelName = model.getModelDefinition().getName();
        CompiledModel previousVersion = this.getModelImpl(modelName);
        if (previousVersion != null) {
            for (M2Namespace namespace : previousVersion.getM2Model().getNamespaces()) {
                this.prefixesCache.remove(namespace.getPrefix());
                this.urisCacheRWLock.writeLock().lock();
                try {
                    this.urisCache.remove(namespace.getUri());
                }
                finally {
                    this.urisCacheRWLock.writeLock().unlock();
                }
                this.unmapUriToModel(namespace.getUri(), previousVersion);
            }
            for (M2Namespace importNamespace : previousVersion.getM2Model().getImports()) {
                this.unmapUriToModel(importNamespace.getUri(), previousVersion);
            }
        }
        M2Model m2Model = model.getM2Model();
        for (M2Namespace namespace : m2Model.getNamespaces()) {
            this.addURI(namespace.getUri());
            this.addPrefix(namespace.getPrefix(), namespace.getUri());
            this.mapUriToModel(namespace.getUri(), model);
        }
        for (M2Namespace importNamespace : m2Model.getImports()) {
            this.mapUriToModel(importNamespace.getUri(), model);
        }
        this.compiledModels.put(modelName, model);
        return modelName;
    }

    @Override
    public AspectDefinition getAspect(QName aspectName) {
        return this.getAspectImpl(aspectName);
    }

    protected AspectDefinition getAspectImpl(QName aspectName) {
        AspectDefinition aspect;
        block1: {
            CompiledModel model;
            List<CompiledModel> models;
            aspect = null;
            if (aspectName == null || (models = this.uriToModels.get(aspectName.getNamespaceURI())) == null || models.size() <= 0) break block1;
            Iterator<CompiledModel> iterator = models.iterator();
            while (iterator.hasNext() && (aspect = (model = iterator.next()).getAspect(aspectName)) == null) {
            }
        }
        return aspect;
    }

    @Override
    public AssociationDefinition getAssociation(QName assocName) {
        return this.getAssociationImpl(assocName);
    }

    protected AssociationDefinition getAssociationImpl(QName assocName) {
        AssociationDefinition assocDef;
        block1: {
            CompiledModel model;
            assocDef = null;
            List<CompiledModel> models = this.getModelsForUri(assocName.getNamespaceURI());
            if (models == null || models.size() <= 0) break block1;
            Iterator<CompiledModel> iterator = models.iterator();
            while (iterator.hasNext() && (assocDef = (model = iterator.next()).getAssociation(assocName)) == null) {
            }
        }
        return assocDef;
    }

    @Override
    public ClassDefinition getClass(QName className) {
        return this.getClassImpl(className);
    }

    protected ClassDefinition getClassImpl(QName className) {
        ClassDefinition classDef;
        block1: {
            CompiledModel model;
            classDef = null;
            List<CompiledModel> models = this.getModelsForUri(className.getNamespaceURI());
            if (models == null || models.size() <= 0) break block1;
            Iterator<CompiledModel> iterator = models.iterator();
            while (iterator.hasNext() && (classDef = (model = iterator.next()).getClass(className)) == null) {
            }
        }
        return classDef;
    }

    @Override
    public PropertyDefinition getProperty(QName propertyName) {
        return this.getPropertyImpl(propertyName);
    }

    protected PropertyDefinition getPropertyImpl(QName propertyName) {
        PropertyDefinition propDef;
        block1: {
            CompiledModel model;
            propDef = null;
            List<CompiledModel> models = this.getModelsForUri(propertyName.getNamespaceURI());
            if (models == null || models.size() <= 0) break block1;
            Iterator<CompiledModel> iterator = models.iterator();
            while (iterator.hasNext() && (propDef = (model = iterator.next()).getProperty(propertyName)) == null) {
            }
        }
        return propDef;
    }

    @Override
    public TypeDefinition getType(QName typeName) {
        return this.getTypeImpl(typeName);
    }

    protected TypeDefinition getTypeImpl(QName typeName) {
        TypeDefinition typeDef;
        block1: {
            CompiledModel model;
            List<CompiledModel> models;
            typeDef = null;
            if (typeName == null || (models = this.getModelsForUri(typeName.getNamespaceURI())) == null || models.size() <= 0) break block1;
            Iterator<CompiledModel> iterator = models.iterator();
            while (iterator.hasNext() && (typeDef = (model = iterator.next()).getType(typeName)) == null) {
            }
        }
        return typeDef;
    }

    @Override
    public ConstraintDefinition getConstraint(QName constraintQName) {
        return this.getConstraintImpl(constraintQName);
    }

    protected ConstraintDefinition getConstraintImpl(QName constraintQName) {
        ConstraintDefinition constraintDef;
        block1: {
            CompiledModel model;
            constraintDef = null;
            List<CompiledModel> models = this.getModelsForUri(constraintQName.getNamespaceURI());
            if (models == null || models.size() <= 0) break block1;
            Iterator<CompiledModel> iterator = models.iterator();
            while (iterator.hasNext() && (constraintDef = (model = iterator.next()).getConstraint(constraintQName)) == null) {
            }
        }
        return constraintDef;
    }

    @Override
    public DataTypeDefinition getDataType(QName typeName) {
        return this.getDataTypeImp(typeName);
    }

    protected DataTypeDefinition getDataTypeImp(QName typeName) {
        DataTypeDefinition dataType;
        block1: {
            CompiledModel model;
            List<CompiledModel> models;
            dataType = null;
            if (typeName == null || (models = this.getModelsForUri(typeName.getNamespaceURI())) == null || models.size() <= 0) break block1;
            Iterator<CompiledModel> iterator = models.iterator();
            while (iterator.hasNext() && (dataType = (model = iterator.next()).getDataType(typeName)) == null) {
            }
        }
        return dataType;
    }

    @Override
    public DataTypeDefinition getDataType(Class javaClass) {
        return this.getDataTypeImpl(javaClass);
    }

    protected DataTypeDefinition getDataTypeImpl(Class javaClass) {
        DataTypeDefinition dataTypeDef;
        block1: {
            CompiledModel model;
            dataTypeDef = null;
            if (javaClass == null) break block1;
            Iterator<CompiledModel> iterator = this.getCompiledModels(true).values().iterator();
            while (iterator.hasNext() && (dataTypeDef = (model = iterator.next()).getDataType(javaClass)) == null) {
            }
        }
        return dataTypeDef;
    }

    protected Map<String, String> getPrefixesCacheImpl() {
        return this.prefixesCache;
    }

    @Override
    public Map<String, String> getPrefixesCache() {
        return this.getPrefixesCacheImpl();
    }

    @Override
    public List<String> getUrisCache() {
        return this.getUrisCacheImpl();
    }

    protected List<String> getUrisCacheImpl() {
        this.urisCacheRWLock.readLock().lock();
        try {
            ArrayList<String> arrayList = new ArrayList<String>(this.urisCache);
            return arrayList;
        }
        finally {
            this.urisCacheRWLock.readLock().unlock();
        }
    }

    @Override
    public Collection<String> getPrefixes(String URI) {
        return this.getPrefixesImpl(URI);
    }

    protected Collection<String> getPrefixesImpl(String URI) {
        ArrayList<String> prefixes = new ArrayList<String>();
        for (String key : this.prefixesCache.keySet()) {
            String uri = this.prefixesCache.get(key);
            if (uri == null || !uri.equals(URI)) continue;
            prefixes.add(key);
        }
        return prefixes;
    }

    @Override
    public void addURI(String uri) {
        this.addURIImpl(uri);
    }

    protected void addURIImpl(String uri) {
        if (this.hasURI(uri)) {
            throw new NamespaceException("URI " + uri + " has already been defined");
        }
        this.urisCacheRWLock.writeLock().lock();
        try {
            this.urisCache.add(uri);
        }
        finally {
            this.urisCacheRWLock.writeLock().unlock();
        }
    }

    @Override
    public boolean hasURI(String uri) {
        this.urisCacheRWLock.readLock().lock();
        try {
            boolean bl = this.urisCache.contains(uri);
            return bl;
        }
        finally {
            this.urisCacheRWLock.readLock().unlock();
        }
    }

    @Override
    public void addPrefix(String prefix, String uri) {
        this.addPrefixImpl(prefix, uri);
    }

    @Override
    public boolean hasPrefix(String prefix) {
        return this.prefixesCache.containsKey(prefix);
    }

    protected void addPrefixImpl(String prefix, String uri) {
        this.urisCacheRWLock.readLock().lock();
        try {
            if (!this.urisCache.contains(uri)) {
                throw new NamespaceException("Namespace URI " + uri + " does not exist");
            }
            if (this.prefixesCache.containsKey(prefix)) {
                throw new NamespaceException(String.format("Namespace prefix '%s' is already in use for URI '%s' so cannot be registered for URI '%s'", prefix, this.prefixesCache.get(prefix), uri));
            }
            this.prefixesCache.put(prefix, uri);
        }
        finally {
            this.urisCacheRWLock.readLock().unlock();
        }
    }

    @Override
    public void removeURI(String uri) {
        this.removeURIImpl(uri);
    }

    @Override
    public void removePrefix(String prefix) {
        this.removePrefixImpl(prefix);
    }

    protected boolean removeURIImpl(String uri) {
        this.urisCacheRWLock.writeLock().lock();
        try {
            boolean bl = this.urisCache.remove(uri);
            return bl;
        }
        finally {
            this.urisCacheRWLock.writeLock().unlock();
        }
    }

    protected boolean removePrefixImpl(String prefix) {
        return this.prefixesCache.remove(prefix) != null;
    }

    @Override
    public Collection<QName> getTypes(boolean includeInherited) {
        ArrayList<QName> types = new ArrayList<QName>(100);
        for (QName model : this.getCompiledModels(includeInherited).keySet()) {
            for (TypeDefinition typeDef : this.getModel(model).getTypes()) {
                types.add(typeDef.getName());
            }
        }
        return types;
    }

    @Override
    public Collection<QName> getAssociations(boolean includeInherited) {
        ArrayList<QName> types = new ArrayList<QName>(100);
        for (QName model : this.getCompiledModels(includeInherited).keySet()) {
            for (AssociationDefinition assocDef : this.getModel(model).getAssociations()) {
                types.add(assocDef.getName());
            }
        }
        return types;
    }

    @Override
    public Collection<QName> getAspects(boolean includeInherited) {
        ArrayList<QName> types = new ArrayList<QName>(100);
        for (QName model : this.getCompiledModels(includeInherited).keySet()) {
            for (AspectDefinition aspectDef : this.getModel(model).getAspects()) {
                types.add(aspectDef.getName());
            }
        }
        return types;
    }

    protected abstract void initImpl();

    @Override
    public void init() {
        this.initImpl();
    }

    protected abstract void removeImpl();

    @Override
    public void remove() {
        this.uriToModels.clear();
        this.compiledModels.clear();
        this.urisCacheRWLock.writeLock().lock();
        try {
            this.urisCache.clear();
        }
        finally {
            this.urisCacheRWLock.writeLock().unlock();
        }
        this.prefixesCache.clear();
        this.removeImpl();
    }

    @Override
    public boolean isModelInherited(QName modelName) {
        CompiledModel model = this.compiledModels.get(modelName);
        return model != null;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        String namespaceURI = null;
        if (prefix != null) {
            namespaceURI = this.getPrefixesCache().get(prefix);
        }
        return namespaceURI;
    }
}

