/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Locale;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.AbstractModelTest;
import org.alfresco.repo.dictionary.DictionaryComponent;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.DictionaryNamespaceComponent;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.NamespaceDAO;
import org.alfresco.repo.i18n.StaticMessageLookup;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.namespace.QName;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class DictionaryComponentTest
extends AbstractModelTest {
    DictionaryNamespaceComponent ndc;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        NamespaceDAO nao = (NamespaceDAO)Mockito.mock(NamespaceDAO.class);
        Mockito.when((Object)nao.getPrefixes(ArgumentMatchers.anyString())).thenReturn(Arrays.asList("pref1"));
        Mockito.when((Object)nao.getPrefixes()).thenReturn(Arrays.asList("pref1", "pref2"));
        Mockito.when((Object)nao.getURIs()).thenReturn(Arrays.asList("uri1", "uri2"));
        Mockito.when((Object)nao.getNamespaceURI(ArgumentMatchers.anyString())).thenReturn((Object)"uri1");
        this.ndc = new DictionaryNamespaceComponent();
        this.ndc.setNamespaceDAO(nao);
    }

    public void testGetter() throws Exception {
        DictionaryComponentTest.assertNotNull((Object)this.ndc.getURIs());
        DictionaryComponentTest.assertNotNull((Object)this.ndc.getPrefixes());
        DictionaryComponentTest.assertNotNull((Object)this.ndc.getPrefixes("something"));
        DictionaryComponentTest.assertNotNull((Object)this.ndc.getNamespaceURI("something uri"));
    }

    public void testUnsupportedOperations() throws Exception {
        try {
            this.ndc.registerNamespace(null, null);
            DictionaryComponentTest.fail((String)"Should not be here");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.ndc.unregisterNamespace(null);
            DictionaryComponentTest.fail((String)"Should not be here");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testDCGetters() throws Exception {
        DictionaryComponent dc = new DictionaryComponent();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("<model name=\"test1:model6\" xmlns=\"http://www.alfresco.org/model/dictionary/1.0\">   <description>Another description - UPDATE1</description>   <author>Alfresco - UPDATE1</author>   <published>2009-08-01</published>   <version>2.0</version>   <imports>      <import uri=\"http://www.alfresco.org/model/dictionary/1.0\" prefix=\"d\"/>   </imports>   <namespaces>      <namespace uri=\"http://www.alfresco.org/model/test1/1.0\" prefix=\"test1\"/>   </namespaces>   <types>      <type name=\"test1:type1\">        <title>Type1 Title - UPDATE1</title>        <description>Type1 Description - UPDATE1</description>        <properties>           <property name=\"test1:prop1\">              <title>Prop1 Title - UPDATE1</title>              <description>Prop1 Description - UPDATE1</description>              <type>d:text</type>           </property>        </properties>      </type>   </types>   <aspects>      <aspect name=\"test1:aspect1\">        <title>Aspect1 Title</title>        <description>Aspect1 Description</description>        <properties>           <property name=\"test1:prop9\">              <title>Prop9 Title - UPDATE1</title>              <description>Prop9 Description - UPDATE1</description>              <type>d:text</type>           </property>        </properties>      </aspect>   </aspects></model>".getBytes());
        M2Model model = M2Model.createModel((InputStream)byteArrayInputStream);
        QName modelName = this.dictionaryDAO.putModel(model);
        dc.setDictionaryDAO((DictionaryDAO)this.dictionaryDAO);
        DictionaryComponentTest.assertNotNull((Object)dc.getAllModels());
        DictionaryComponentTest.assertNotNull((Object)dc.getAllDataTypes());
        DictionaryComponentTest.assertNotNull((Object)dc.getAllTypes());
        DictionaryComponentTest.assertNotNull((Object)dc.getAllAspects());
        DictionaryComponentTest.assertNotNull((Object)dc.getAllAssociations());
        DictionaryComponentTest.assertNotNull((Object)dc.getModel(modelName));
        DictionaryComponentTest.assertNotNull((Object)dc.getDataTypes(modelName));
        DictionaryComponentTest.assertNotNull((Object)dc.getTypes(modelName));
        DictionaryComponentTest.assertNotNull((Object)dc.getAspects(modelName));
        DictionaryComponentTest.assertNotNull((Object)dc.getAssociations(modelName));
        DictionaryComponentTest.assertNotNull((Object)dc.getConstraints(modelName));
        DictionaryComponentTest.assertNotNull((Object)dc.getProperties(modelName));
        DictionaryComponentTest.assertNotNull((Object)dc.getProperties(modelName, ContentModel.PROP_NAME));
        DictionaryComponentTest.assertNotNull((Object)dc.getAllProperties(ContentModel.PROP_NAME));
        DictionaryComponentTest.assertNotNull((Object)dc.getSubTypes(ContentModel.PROP_NAME, false));
        DictionaryComponentTest.assertNotNull((Object)dc.getSubAspects(ContentModel.ASPECT_HIDDEN, false));
        DictionaryComponentTest.assertNotNull((Object)dc.getConstraints(modelName, false));
        QName[] types = dc.getTypes(modelName).toArray(new QName[2]);
        QName text = QName.createQName((String)"http://www.alfresco.org/model/dictionary/1.0", (String)"text");
        QName testAspect = QName.createQName((String)modelName.getNamespaceURI(), (String)"aspect1");
        DictionaryComponentTest.assertTrue((types.length > 0 ? 1 : 0) != 0);
        DictionaryComponentTest.assertNotNull((Object)dc.getAnonymousType(types[0], Arrays.asList(testAspect)));
        DictionaryComponentTest.assertNotNull((Object)dc.getAnonymousType(types[0]));
        DictionaryComponentTest.assertNotNull((Object)dc.getPropertyDefs(testAspect));
        DataTypeDefinition dataTypeDefinition = dc.getDataType(text);
        DictionaryComponentTest.assertEquals((Object)dataTypeDefinition, (Object)dc.getDataType(Class.forName(dataTypeDefinition.getJavaClassName())));
    }

    public void testMessageLookup() throws Exception {
        DictionaryComponent dc = new DictionaryComponent();
        dc.setDictionaryDAO((DictionaryDAO)this.dictionaryDAO);
        dc.setMessageLookup((MessageLookup)new StaticMessageLookup());
        DictionaryComponentTest.assertNull((Object)dc.getMessage("fred"));
        DictionaryComponentTest.assertNull((Object)dc.getMessage("fred", Locale.getDefault()));
        DictionaryComponentTest.assertNull((Object)dc.getMessage("fred", new Object[]{"cat"}));
        DictionaryComponentTest.assertNull((Object)dc.getMessage("fred", Locale.getDefault(), new Object[]{"dog"}));
    }

    public void testLifeCycle() throws Exception {
        DictionaryComponent dc = new DictionaryComponent();
        dc.setDictionaryDAO((DictionaryDAO)this.dictionaryDAO);
        dc.init();
        dc.onEnableTenant();
        dc.onDisableTenant();
        dc.destroy();
        dc.init();
    }
}

