/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.service.cmr.search.StatsProcessorUsingMap;
import org.alfresco.service.cmr.search.StatsResultSet;
import org.alfresco.service.cmr.search.StatsResultStat;
import org.junit.Assert;
import org.junit.Test;

public class StatsProcessorTest {
    @Test
    public void testProcessMap() {
        StatsProcessorUsingMap processor = new StatsProcessorUsingMap(this.mappingData());
        StatsResultSet input = this.testData();
        StatsResultSet result = processor.process(input);
        Assert.assertNotNull((Object)result);
        List statsResults = result.getStats();
        Assert.assertEquals((long)5L, (long)statsResults.size());
        Assert.assertEquals((Object)"Princess", (Object)((StatsResultStat)statsResults.get(0)).getName());
        Assert.assertEquals((Object)"George", (Object)((StatsResultStat)statsResults.get(1)).getName());
        Assert.assertEquals((Object)"Queen", (Object)((StatsResultStat)statsResults.get(2)).getName());
        Assert.assertEquals((Object)"Prince", (Object)((StatsResultStat)statsResults.get(3)).getName());
        Assert.assertEquals((Object)"King", (Object)((StatsResultStat)statsResults.get(4)).getName());
    }

    private StatsResultSet testData() {
        ArrayList<StatsResultStat> stats = new ArrayList<StatsResultStat>();
        stats.add(new StatsResultStat("Kate", Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L), Long.valueOf(4L), Long.valueOf(5L)));
        stats.add(new StatsResultStat("George", Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L), Long.valueOf(4L), Long.valueOf(5L)));
        stats.add(new StatsResultStat("Liz", Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L), Long.valueOf(4L), Long.valueOf(5L)));
        stats.add(new StatsResultStat("William", Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L), Long.valueOf(4L), Long.valueOf(5L)));
        stats.add(new StatsResultStat("Charles", Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L), Long.valueOf(4L), Long.valueOf(5L)));
        StatsResultSetImpl res = new StatsResultSetImpl(2L, 3L, 4L, 5L, stats);
        return res;
    }

    private Map<String, String> mappingData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("Charles", "King");
        data.put("Liz", "Queen");
        data.put("William", "Prince");
        data.put("Kate", "Princess");
        return data;
    }

    public static class StatsResultSetImpl
    implements StatsResultSet {
        private Long numberFound;
        private Long sum;
        private Long max;
        private Long mean;
        private List<StatsResultStat> stats;

        public StatsResultSetImpl(Long numberFound, Long sum, Long max, Long mean, List<StatsResultStat> stats) {
            this.numberFound = numberFound;
            this.sum = sum;
            this.max = max;
            this.mean = mean;
            this.stats = stats;
        }

        public long getNumberFound() {
            return this.numberFound;
        }

        public Long getSum() {
            return this.sum;
        }

        public Long getMax() {
            return this.max;
        }

        public Long getMean() {
            return this.mean;
        }

        public List<StatsResultStat> getStats() {
            return this.stats;
        }
    }
}

