/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.tenant;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TenantContextHolder {
    private static Log logger = LogFactory.getLog(TenantContextHolder.class);
    private static final ThreadLocal<String> contextHolder = new ThreadLocal();

    public static String setTenantDomain(String tenantDomain) {
        String currentTenantDomain = TenantContextHolder.getTenantDomain();
        if (tenantDomain == null) {
            TenantContextHolder.clearTenantDomain();
            return currentTenantDomain;
        }
        if ((tenantDomain = tenantDomain.toLowerCase()).equals(currentTenantDomain)) {
            return currentTenantDomain;
        }
        contextHolder.set(tenantDomain);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Set tenant: " + tenantDomain));
        }
        return currentTenantDomain;
    }

    public static String getTenantDomain() {
        return contextHolder.get();
    }

    public static void clearTenantDomain() {
        String tenantDomain;
        if (logger.isTraceEnabled() && !"".equals(tenantDomain = TenantContextHolder.getTenantDomain())) {
            logger.trace((Object)("Clear tenant domain (was: " + TenantContextHolder.getTenantDomain() + ")"));
        }
        contextHolder.remove();
    }
}

