/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.io.IOException;
import junit.framework.TestCase;
import org.alfresco.util.ConfigScheduler;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.quartz.CronExpression;

public class ConfigSchedulerTest
extends TestCase {
    private static final Log log = LogFactory.getLog(ConfigSchedulerTest.class);
    private static boolean mockSuccessReadingConfig = true;
    private TestRegistry registry = new TestRegistry();
    private static int readConfigCount;
    private long startMs;

    @Before
    public void setUp() throws Exception {
        mockSuccessReadingConfig = true;
    }

    private String getMs() {
        return System.currentTimeMillis() - this.startMs + "ms: ";
    }

    public TestRegistry.Data assertDataChanged(TestRegistry.Data prevData, String msg) {
        System.out.println(this.getMs() + msg);
        TestRegistry.Data data = this.registry.getData();
        Assert.assertNotEquals((String)("The configuration data should have changed: " + msg), (Object)prevData, (Object)data);
        return data;
    }

    public TestRegistry.Data assertDataUnchanged(TestRegistry.Data prevData, String msg) {
        System.out.println(this.getMs() + msg);
        TestRegistry.Data data = this.registry.getData();
        ConfigSchedulerTest.assertEquals((String)("The configuration data should be the same: " + msg), (Object)prevData, (Object)data);
        return data;
    }

    @Test
    public void testSwitchingOfSchedule() throws Exception {
        readConfigCount = 0;
        this.registry.setInitialAndOnErrorCronExpression(new CronExpression("0/2 * * ? * * *"));
        this.registry.setCronExpression(new CronExpression("0/4 * * ? * * *"));
        Thread.sleep(4000L - System.currentTimeMillis() % 4000L);
        this.startMs = System.currentTimeMillis();
        mockSuccessReadingConfig = false;
        this.registry.afterPropertiesSet();
        TestRegistry.Data data = this.registry.getData();
        Thread.sleep(1000L);
        data = this.assertDataChanged(data, "There should have been a read after a few milliseconds that fails");
        Thread.sleep(2000L);
        data = this.assertDataChanged(data, "There should have been a read after 2 seconds that fails");
        Thread.sleep(2000L);
        data = this.assertDataChanged(data, "There should have been a read after 4 seconds that fails");
        Thread.sleep(2000L);
        data = this.assertDataChanged(data, "There should have been a read after 6 seconds that fails");
        mockSuccessReadingConfig = true;
        Thread.sleep(2000L);
        data = this.assertDataChanged(data, "There should have been a read after 8 seconds that succeeds");
        Thread.sleep(2000L);
        data = this.assertDataUnchanged(data, "There really should not have been a read until 12 seconds");
        Thread.sleep(2000L);
        data = this.assertDataChanged(data, "There should have been a read after 12 seconds that succeeds");
        mockSuccessReadingConfig = false;
        Thread.sleep(4000L);
        data = this.assertDataChanged(data, "There should have been a read after 16 seconds that fails");
        Thread.sleep(2000L);
        data = this.assertDataChanged(data, "There should have been a read after 18 seconds");
    }

    private static class TestRegistry {
        private CronExpression cronExpression;
        private CronExpression initialAndOnErrorCronExpression;
        private ConfigScheduler<Data> configScheduler = new ConfigScheduler(this){

            public boolean readConfig() throws IOException {
                return this.readConfig();
            }

            public Object createData() {
                return this.createData();
            }
        };

        private TestRegistry() {
        }

        public Data createData() {
            return new Data();
        }

        public Data getData() {
            return (Data)this.configScheduler.getData();
        }

        public void setCronExpression(CronExpression cronExpression) {
            this.cronExpression = cronExpression;
        }

        public void setInitialAndOnErrorCronExpression(CronExpression initialAndOnErrorCronExpression) {
            this.initialAndOnErrorCronExpression = initialAndOnErrorCronExpression;
        }

        public void afterPropertiesSet() {
            if (this.cronExpression != null) {
                PropertyCheck.mandatory((Object)this, (String)"initialAndOnErrorCronExpression", (Object)this.initialAndOnErrorCronExpression);
            }
            this.configScheduler.run(true, log, this.cronExpression, this.initialAndOnErrorCronExpression);
        }

        public boolean readConfig() {
            Data data = this.getData();
            data.registersData = "Can be anything " + ++readConfigCount;
            System.err.println(data.registersData);
            return mockSuccessReadingConfig;
        }

        static class Data {
            private String registersData;

            Data() {
            }

            public String toString() {
                return "register's data: " + this.registersData;
            }
        }
    }
}

