/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.namespace;

import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@AlfrescoPublicApi
public class RegexQNamePattern
implements QNamePattern {
    private static final Log logger = LogFactory.getLog(RegexQNamePattern.class);
    public static final QNamePattern MATCH_ALL = new QNamePattern(){

        @Override
        public boolean isMatch(QName qname) {
            return true;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return obj.getClass().equals(this.getClass());
        }
    };
    private String namespaceUriPattern;
    private String localNamePattern;
    private String combinedPattern;

    public RegexQNamePattern(String namespaceUriPattern, String localNamePattern) {
        this.namespaceUriPattern = namespaceUriPattern;
        this.localNamePattern = localNamePattern;
        this.combinedPattern = null;
    }

    public RegexQNamePattern(String combinedPattern) {
        this.combinedPattern = combinedPattern;
        this.namespaceUriPattern = null;
        this.localNamePattern = null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(56);
        sb.append("RegexQNamePattern[");
        if (this.combinedPattern != null) {
            sb.append(" pattern=").append(this.combinedPattern);
        } else {
            sb.append(" uri=").append(this.namespaceUriPattern);
            sb.append(", localname=").append(this.localNamePattern);
        }
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public boolean isMatch(QName qname) {
        boolean match = false;
        if (this.combinedPattern != null) {
            String qnameStr = qname.toString();
            match = qnameStr.matches(this.combinedPattern);
        } else {
            boolean bl = match = qname.getNamespaceURI().matches(this.namespaceUriPattern) && qname.getLocalName().matches(this.localNamePattern);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("QName matching: \n   matcher: " + String.valueOf(this) + "\n   qname: " + String.valueOf(qname) + "\n   result: " + match));
        }
        return match;
    }
}

