/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.alfresco.repo.dictionary.CompiledModel;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.CustomModelDefinition;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.dictionary.NamespaceDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.namespace.QName;

public class CustomModelDefinitionImpl
implements CustomModelDefinition {
    private final ModelDefinition m2ModelDefinition;
    private final boolean active;
    private final MessageLookup messageLookup;
    private final Collection<TypeDefinition> typeDefinitions;
    private final Collection<AspectDefinition> aspectDefinitions;
    private final Collection<ConstraintDefinition> modelDefinedConstraints;

    CustomModelDefinitionImpl(CompiledModel compiledModel, boolean active, MessageLookup messageLookup) {
        this.m2ModelDefinition = compiledModel.getModelDefinition();
        this.active = active;
        this.messageLookup = messageLookup;
        this.typeDefinitions = new ArrayList<TypeDefinition>(compiledModel.getTypes());
        this.aspectDefinitions = new ArrayList<AspectDefinition>(compiledModel.getAspects());
        this.modelDefinedConstraints = CustomModelDefinitionImpl.removeInlineConstraints(compiledModel);
    }

    public static List<ConstraintDefinition> removeInlineConstraints(CompiledModel compiledModel) {
        ArrayList<ConstraintDefinition> modelConstraints = new ArrayList<ConstraintDefinition>();
        HashSet<QName> propertyConstraints = new HashSet<QName>();
        for (PropertyDefinition propDef : compiledModel.getProperties()) {
            if (propDef.getConstraints().size() <= 0) continue;
            for (ConstraintDefinition propConst : propDef.getConstraints()) {
                propertyConstraints.add(propConst.getName());
            }
        }
        for (ConstraintDefinition constraint : compiledModel.getConstraints()) {
            if (propertyConstraints.contains(constraint.getName())) continue;
            modelConstraints.add(constraint);
        }
        return modelConstraints;
    }

    @Override
    public String getDescription() {
        return this.getDescription(this.messageLookup);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public String getAuthor() {
        return this.m2ModelDefinition.getAuthor();
    }

    @Override
    public long getChecksum(ModelDefinition.XMLBindingType xmlbindingtype) {
        return this.m2ModelDefinition.getChecksum(xmlbindingtype);
    }

    @Override
    public String getDescription(MessageLookup messagelookup) {
        return this.m2ModelDefinition.getDescription(messagelookup);
    }

    @Override
    public DictionaryDAO getDictionaryDAO() {
        return this.m2ModelDefinition.getDictionaryDAO();
    }

    @Override
    public Collection<NamespaceDefinition> getImportedNamespaces() {
        return this.m2ModelDefinition.getImportedNamespaces();
    }

    @Override
    public QName getName() {
        return this.m2ModelDefinition.getName();
    }

    @Override
    public Collection<NamespaceDefinition> getNamespaces() {
        return this.m2ModelDefinition.getNamespaces();
    }

    @Override
    public Date getPublishedDate() {
        return this.m2ModelDefinition.getPublishedDate();
    }

    @Override
    public String getVersion() {
        return this.m2ModelDefinition.getVersion();
    }

    @Override
    public boolean isNamespaceDefined(String uri) {
        return this.m2ModelDefinition.isNamespaceDefined(uri);
    }

    @Override
    public boolean isNamespaceImported(String uri) {
        return this.m2ModelDefinition.isNamespaceImported(uri);
    }

    @Override
    public void toXML(ModelDefinition.XMLBindingType xmlbindingtype, OutputStream xml) {
        this.m2ModelDefinition.toXML(xmlbindingtype, xml);
    }

    @Override
    public Collection<TypeDefinition> getTypeDefinitions() {
        return Collections.unmodifiableCollection(this.typeDefinitions);
    }

    @Override
    public Collection<AspectDefinition> getAspectDefinitions() {
        return Collections.unmodifiableCollection(this.aspectDefinitions);
    }

    @Override
    public Collection<ConstraintDefinition> getModelDefinedConstraints() {
        return Collections.unmodifiableCollection(this.modelDefinedConstraints);
    }
}

