/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.repository.datatype;

import java.io.IOException;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.util.CachingDateFormat;

@AlfrescoPublicApi
public class Duration
implements Comparable,
Serializable {
    static final long serialVersionUID = 3274526442325176068L;
    public static final String XML_DAY = "P1D";
    public static final String XML_WEEK = "P7D";
    public static final String XML_TWO_WEEKS = "P14D";
    public static final String XML_MONTH = "P1M";
    public static final String XML_QUARTER = "P3M";
    public static final String XML_SIX_MONTHS = "P6M";
    public static final String XML_YEAR = "P1Y";
    public static final Duration DAY = new Duration("P1D");
    public static final Duration WEEK = new Duration("P7D");
    public static final Duration TWO_WEEKS = new Duration("P14D");
    public static final Duration MONTH = new Duration("P1M");
    public static final Duration QUARTER = new Duration("P3M");
    public static final Duration SIX_MONTHS = new Duration("P6M");
    public static final Duration YEAR = new Duration("P1Y");
    private static final String s_parse = "-PYMDTHmS";
    private boolean m_positive = true;
    private int m_years = 0;
    private int m_months = 0;
    private int m_days = 0;
    private int m_hours = 0;
    private int m_mins = 0;
    private int m_seconds = 0;
    private int m_nanos = 0;

    public static Date add(Date date, Duration duration) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(1, (duration.m_positive ? 1 : -1) * duration.m_years);
        c.add(2, (duration.m_positive ? 1 : -1) * duration.m_months);
        c.add(5, (duration.m_positive ? 1 : -1) * duration.m_days);
        c.add(11, (duration.m_positive ? 1 : -1) * duration.m_hours);
        c.add(12, (duration.m_positive ? 1 : -1) * duration.m_mins);
        c.add(13, (duration.m_positive ? 1 : -1) * duration.m_seconds);
        c.add(14, (duration.m_positive ? 1 : -1) * duration.m_nanos / 1000000);
        return c.getTime();
    }

    public static Date subtract(Date date, Duration duration) {
        return Duration.add(date, duration.unaryMinus());
    }

    public Duration() {
    }

    public Duration(String duration) {
        if (duration.equals("P")) {
            throw new RuntimeException("Invalid period: P");
        }
        if (!duration.startsWith("P") && !duration.startsWith("-P")) {
            throw new RuntimeException("Invalid period: must start with P or -P");
        }
        boolean dateMode = true;
        int last = -1;
        Double nval = null;
        StringReader reader = new StringReader(duration);
        StreamTokenizer tok = new StreamTokenizer(reader);
        tok.resetSyntax();
        tok.eolIsSignificant(true);
        tok.parseNumbers();
        tok.ordinaryChars(45, 45);
        tok.ordinaryChars(80, 80);
        tok.ordinaryChars(89, 89);
        tok.ordinaryChars(77, 77);
        tok.ordinaryChars(68, 68);
        tok.ordinaryChars(84, 84);
        tok.ordinaryChars(72, 72);
        tok.ordinaryChars(109, 109);
        tok.ordinaryChars(83, 83);
        try {
            int token;
            while ((token = tok.nextToken()) != -1) {
                if (token == -2) {
                    nval = tok.nval;
                    continue;
                }
                if (token == -1) {
                    throw new RuntimeException("Invalid EOF in Duration");
                }
                if (token == 10) {
                    throw new RuntimeException("Invalid EOL in Duration");
                }
                if (token == -3) {
                    throw new RuntimeException("Invalid text in Duration: " + tok.sval);
                }
                if (tok.ttype == 45) {
                    last = this.checkIndex(last, "-");
                    this.m_positive = false;
                    continue;
                }
                if (tok.ttype == 80) {
                    last = this.checkIndex(last, "P");
                    continue;
                }
                if (tok.ttype == 89) {
                    last = this.checkIndex(last, "Y");
                    if (nval == null) {
                        throw new RuntimeException("IO Error parsing Duration: " + duration);
                    }
                    this.m_years = nval.intValue();
                    nval = null;
                    continue;
                }
                if (tok.ttype == 77) {
                    if (dateMode) {
                        last = this.checkIndex(last, "M");
                        if (nval == null) {
                            throw new RuntimeException("IO Error parsing Duration: " + duration);
                        }
                        this.m_months = nval.intValue();
                        nval = null;
                        continue;
                    }
                    last = this.checkIndex(last, "m");
                    if (nval == null) {
                        throw new RuntimeException("IO Error parsing Duration: " + duration);
                    }
                    this.m_mins = nval.intValue();
                    nval = null;
                    continue;
                }
                if (tok.ttype == 68) {
                    last = this.checkIndex(last, "D");
                    if (nval == null) {
                        throw new RuntimeException("IO Error parsing Duration: " + duration);
                    }
                    this.m_days = nval.intValue();
                    nval = null;
                    continue;
                }
                if (tok.ttype == 84) {
                    last = this.checkIndex(last, "T");
                    dateMode = false;
                    nval = null;
                    continue;
                }
                if (tok.ttype == 72) {
                    last = this.checkIndex(last, "H");
                    if (nval == null) {
                        throw new RuntimeException("IO Error parsing Duration: " + duration);
                    }
                    this.m_hours = nval.intValue();
                    nval = null;
                    continue;
                }
                if (tok.ttype == 83) {
                    last = this.checkIndex(last, "S");
                    if (nval == null) {
                        throw new RuntimeException("IO Error parsing Duration: " + duration);
                    }
                    this.m_seconds = nval.intValue();
                    this.m_nanos = (int)((long)(nval * 1.0E9) % 1000000000L);
                    nval = null;
                    continue;
                }
                throw new RuntimeException("IO Error parsing Duration: " + duration);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("IO Error parsing Duration: " + duration);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("IO Error parsing Duration: " + duration, e);
        }
    }

    private int checkIndex(int last, String search) {
        if (search == null || search.length() == 0) {
            throw new RuntimeException("Null or zero length serach");
        }
        int index = s_parse.indexOf(search);
        if (index > last) {
            return index;
        }
        throw new RuntimeException("Illegal position for identifier " + search);
    }

    public Duration(Date date) {
        this(date, new Date());
    }

    public Duration(String start, String end) {
        this(Duration.parseDate(start), Duration.parseDate(end));
    }

    private static Date parseDate(String stringDate) {
        SimpleDateFormat df = CachingDateFormat.getDateFormat();
        df.setLenient(true);
        ParsePosition pp = new ParsePosition(0);
        Date date = ((DateFormat)df).parse(stringDate, pp);
        if (pp.getIndex() < stringDate.length() || date == null) {
            date = new Date();
        }
        return date;
    }

    public Duration(Date start_in, Date end_in) {
        Date end;
        Date start;
        boolean positive = true;
        if (end_in.before(start_in)) {
            start = end_in;
            end = start_in;
            positive = false;
        } else {
            start = start_in;
            end = end_in;
            positive = true;
        }
        Calendar cstart = Calendar.getInstance();
        cstart.setTime(start);
        Calendar cend = Calendar.getInstance();
        cend.setTime(end);
        int millis = cend.get(14) - cstart.get(14);
        if (millis < 0) {
            millis += cstart.getActualMaximum(14) + 1;
        }
        cstart.add(14, millis);
        int seconds = cend.get(13) - cstart.get(13);
        if (seconds < 0) {
            seconds += cstart.getActualMaximum(13) + 1;
        }
        cstart.add(13, seconds);
        int minutes = cend.get(12) - cstart.get(12);
        if (minutes < 0) {
            minutes += cstart.getActualMaximum(12) + 1;
        }
        cstart.add(12, minutes);
        int hours = cend.get(11) - cstart.get(11);
        if (hours < 0) {
            hours += cstart.getActualMaximum(11) + 1;
        }
        cstart.add(11, hours);
        int days = cend.get(5) - cstart.get(5);
        if (days < 0) {
            days += cstart.getActualMaximum(5) + 1;
        }
        cstart.add(5, days);
        int months = cend.get(2) - cstart.get(2);
        if (months < 0) {
            months += cstart.getActualMaximum(2) + 1;
        }
        cstart.add(2, months);
        int years = cend.get(1) - cstart.get(1);
        this.m_positive = positive;
        this.m_years = years;
        this.m_months = months;
        this.m_days = days;
        this.m_hours = hours;
        this.m_mins = minutes;
        this.m_seconds = seconds;
        this.m_nanos = millis * 1000000;
    }

    public Duration(boolean positive_in, long months_in, long seconds_in, long nanos_in) {
        boolean positive = positive_in;
        long months = months_in;
        long seconds = seconds_in + nanos_in / 1000000000L;
        long nanos = nanos_in % 1000000000L;
        if (seconds > 0L && nanos < 0L) {
            --seconds;
            nanos += 1000000000L;
        } else if (seconds < 0L && nanos > 0L) {
            ++seconds;
            nanos -= 1000000000L;
        }
        if (months < 0L && seconds + nanos < 0L) {
            positive = !positive;
            months = -months;
            seconds = -seconds;
            nanos = -nanos;
        } else if (months == 0L && seconds + nanos < 0L) {
            positive = !positive;
            months = -months;
            seconds = -seconds;
            nanos = -nanos;
        } else {
            if (months > 0L && seconds + nanos < 0L) {
                throw new RuntimeException("Can not convert to period - incompatible signs for year_to_momth and day_to_second elements");
            }
            if (months < 0L && seconds + nanos > 0L) {
                throw new RuntimeException("Can not convert to period - incompatible signs for year_to_momth and day_to_second elements");
            }
        }
        this.m_positive = positive;
        this.m_years = (int)(months / 12L);
        this.m_months = (int)(months % 12L);
        this.m_days = (int)(seconds / 86400L);
        this.m_hours = (int)((seconds -= (long)(this.m_days * 3600 * 24)) / 3600L);
        this.m_mins = (int)((seconds -= (long)(this.m_hours * 3600)) / 60L);
        this.m_seconds = (int)(seconds -= (long)(this.m_mins * 60));
        this.m_nanos = (int)nanos;
    }

    public Duration add(Duration add) {
        long months = (long)(this.m_positive ? 1 : -1) * this.getTotalMonths() + (long)(add.m_positive ? 1 : -1) * add.getTotalMonths();
        long seconds = (long)(this.m_positive ? 1 : -1) * this.getTotalSeconds() + (long)(add.m_positive ? 1 : -1) * add.getTotalSeconds();
        long nanos = (long)(this.m_positive ? 1 : -1) * this.getTotalNanos() + (long)(add.m_positive ? 1 : -1) * add.getTotalNanos();
        Duration result = new Duration(true, months, seconds, nanos);
        return result;
    }

    public Duration subtract(Duration sub) {
        long months = (long)(this.m_positive ? 1 : -1) * this.getTotalMonths() - (long)(sub.m_positive ? 1 : -1) * sub.getTotalMonths();
        long seconds = (long)(this.m_positive ? 1 : -1) * this.getTotalSeconds() - (long)(sub.m_positive ? 1 : -1) * sub.getTotalSeconds();
        long nanos = (long)(this.m_positive ? 1 : -1) * this.getTotalNanos() - (long)(sub.m_positive ? 1 : -1) * sub.getTotalNanos();
        Duration result = new Duration(true, months, seconds, nanos);
        return result;
    }

    public Duration unaryMinus() {
        Duration result = new Duration(!this.m_positive, this.getTotalMonths(), this.getTotalSeconds(), this.getTotalNanos());
        return result;
    }

    public Duration divide(int d) {
        if (this.isYearToMonth()) {
            long months = this.getTotalMonths();
            Duration result = new Duration(this.m_positive, months /= (long)d, 0L, 0L);
            return result;
        }
        long seconds = this.getTotalSeconds();
        long nanos = seconds * (long)(1000000000 / d) % 1000000000L;
        Duration result = new Duration(this.m_positive, 0L, seconds /= (long)d, nanos += this.getTotalNanos() / (long)d);
        return result;
    }

    private long getTotalMonths() {
        return this.m_years * 12 + this.m_months;
    }

    private long getTotalSeconds() {
        return this.m_seconds + this.m_mins * 60 + this.m_hours * 3600 + this.m_days * 3600 * 24;
    }

    private long getTotalNanos() {
        return this.m_nanos;
    }

    public boolean isYearToMonth() {
        return this.m_years != 0 || this.m_months != 0;
    }

    public boolean isDayToSec() {
        return this.m_years == 0 && this.m_months == 0;
    }

    public boolean hasTime() {
        return this.m_hours != 0 || this.m_mins != 0 || this.m_seconds != 0 || this.m_nanos != 0;
    }

    public Duration getYearToMonth() {
        Duration result = new Duration(this.m_positive, this.getTotalMonths(), 0L, 0L);
        return result;
    }

    public Duration getDayToYear() {
        Duration result = new Duration(this.m_positive, 0L, this.getTotalSeconds(), this.getTotalNanos());
        return result;
    }

    public int compareTo(Object o) {
        if (!(o instanceof Duration)) {
            throw new RuntimeException("Can not compare Duration and " + o.getClass().getName());
        }
        Duration d = (Duration)o;
        if (this.m_positive != d.m_positive) {
            return this.m_positive ? 1 : -1;
        }
        if (this.getTotalMonths() != d.getTotalMonths()) {
            return (this.m_positive ? 1 : -1) * (int)(this.getTotalMonths() - d.getTotalMonths());
        }
        if (this.getTotalSeconds() != d.getTotalSeconds()) {
            return (this.m_positive ? 1 : -1) * (int)(this.getTotalSeconds() - d.getTotalSeconds());
        }
        if (this.getTotalNanos() != d.getTotalNanos()) {
            return (this.m_positive ? 1 : -1) * (int)(this.getTotalNanos() - d.getTotalNanos());
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Duration)) {
            return false;
        }
        Duration d = (Duration)o;
        return this.m_positive == d.m_positive && this.getTotalMonths() == d.getTotalMonths() && this.getTotalSeconds() == d.getTotalSeconds() && this.getTotalNanos() == d.getTotalNanos();
    }

    public int hashCode() {
        int hash = 17;
        hash = 37 * hash + (this.m_positive ? 1 : -1);
        hash = 37 * hash + (int)this.getTotalMonths();
        hash = 37 * hash + (int)this.getTotalSeconds();
        hash = 37 * hash + (int)this.getTotalNanos();
        return hash;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(128);
        if (!this.m_positive) {
            buffer.append("-");
        }
        buffer.append("P");
        buffer.append(this.m_years).append("Y");
        if (this.m_months != 0) {
            buffer.append(this.m_months).append("M");
        }
        if (this.m_days != 0) {
            buffer.append(this.m_days).append("D");
        }
        if (this.hasTime()) {
            buffer.append("T");
            if (this.m_hours != 0) {
                buffer.append(this.m_hours).append("H");
            }
            if (this.m_mins != 0) {
                buffer.append(this.m_mins).append("M");
            }
            if (this.m_seconds != 0 || this.m_nanos != 0) {
                BigDecimal a = new BigDecimal(this.m_seconds);
                BigDecimal b = new BigDecimal(this.m_nanos);
                a = a.add(b.divide(new BigDecimal(1000000000), 9, 6));
                NumberFormat nf = NumberFormat.getInstance();
                buffer.append(nf.format(a));
                buffer.append("S");
            }
        }
        return buffer.toString();
    }

    public String largestComponentformattedString() {
        StringBuffer buffer = new StringBuffer(128);
        if (!this.m_positive) {
            buffer.append("-");
        }
        if (this.m_years != 0) {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append(this.m_years);
            buffer.append(this.m_years == 1 ? " Year" : " Years");
            return buffer.toString();
        }
        if (this.m_months != 0) {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append(this.m_months);
            buffer.append(this.m_months == 1 ? " Month" : " Months");
            return buffer.toString();
        }
        if (this.m_days != 0) {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append(this.m_days);
            buffer.append(this.m_days == 1 ? " Day" : " Days");
            return buffer.toString();
        }
        if (this.m_hours != 0) {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append(this.m_hours);
            buffer.append(this.m_hours == 1 ? " Hour" : " Hours");
            return buffer.toString();
        }
        if (this.m_mins != 0) {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append(this.m_mins);
            buffer.append(this.m_mins == 1 ? " Minute" : " Minutes");
            return buffer.toString();
        }
        if (buffer.length() > 0) {
            buffer.append(" ");
        }
        BigDecimal a = new BigDecimal(this.m_seconds);
        BigDecimal b = new BigDecimal(this.m_nanos);
        a = a.add(b.divide(new BigDecimal(1000000000), 9, 6));
        NumberFormat nf = NumberFormat.getInstance();
        String formatted = nf.format(a);
        buffer.append(formatted);
        buffer.append(formatted.equals("1") ? " Second" : " Seconds");
        return buffer.toString();
    }

    public String formattedString() {
        StringBuffer buffer = new StringBuffer(128);
        if (!this.m_positive) {
            buffer.append("-");
        }
        if (this.m_years != 0) {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append(this.m_years);
            buffer.append(this.m_years == 1 ? " Year" : " Years");
        }
        if (this.m_months != 0) {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append(this.m_months);
            buffer.append(this.m_months == 1 ? " Month" : " Months");
        }
        if (this.m_days != 0) {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append(this.m_days);
            buffer.append(this.m_days == 1 ? " Day" : " Days");
        }
        if (this.hasTime()) {
            if (this.m_hours != 0) {
                if (buffer.length() > 0) {
                    buffer.append(" ");
                }
                buffer.append(this.m_hours);
                buffer.append(this.m_hours == 1 ? " Hour" : " Hours");
            }
            if (this.m_mins != 0) {
                if (buffer.length() > 0) {
                    buffer.append(" ");
                }
                buffer.append(this.m_mins);
                buffer.append(this.m_mins == 1 ? " Minute" : " Minutes");
            }
            if (this.m_seconds != 0 || this.m_nanos != 0) {
                if (buffer.length() > 0) {
                    buffer.append(" ");
                }
                BigDecimal a = new BigDecimal(this.m_seconds);
                BigDecimal b = new BigDecimal(this.m_nanos);
                a = a.add(b.divide(new BigDecimal(1000000000), 9, 6));
                NumberFormat nf = NumberFormat.getInstance();
                String formatted = nf.format(a);
                buffer.append(formatted);
                buffer.append(formatted.equals("1") ? " Second" : " Seconds");
            }
        }
        return buffer.toString();
    }

    public static void main(String[] args) {
        Duration test2;
        Duration test;
        Duration diff = new Duration("2002-04-02T01:01:01", "2003-03-01T00:00:00");
        System.out.println("Diff  " + String.valueOf(diff));
        try {
            test = new Duration("P");
            System.out.println("Just P" + String.valueOf(test));
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        try {
            test2 = new Duration("P Jones");
            System.out.println("P Jones" + String.valueOf(test2));
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        try {
            test2 = new Duration("P12Y Jones");
            System.out.println("P Jones" + String.valueOf(test2));
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        try {
            test = new Duration("PPPPPPPPPPPPPP");
            System.out.println("Just many P" + String.valueOf(test));
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        try {
            test = new Duration("PY");
            System.out.println("PY" + String.valueOf(test));
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        try {
            test = new Duration("PM");
            System.out.println("PM" + String.valueOf(test));
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        try {
            test = new Duration("PP");
            System.out.println("PP" + String.valueOf(test));
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        Date now = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(now);
        c.add(1, -1);
        c.add(2, 2);
        c.add(5, -3);
        c.add(11, 4);
        c.add(12, -5);
        c.add(13, 6);
        c.add(14, -7);
        diff = new Duration(c.getTime(), now);
        System.out.println("V:  " + String.valueOf(diff));
        Duration diff2 = new Duration(now, c.getTime());
        System.out.println("V:  " + String.valueOf(diff2));
        Duration a1 = new Duration("P2Y6M");
        Duration a2 = new Duration("P1DT2H3M1.5S");
        Duration d = new Duration("P2Y6M5DT12H35M30.100S");
        System.out.println("V:  " + String.valueOf(d));
        System.out.println("F:  " + d.formattedString());
        System.out.println(" D: " + String.valueOf(d.divide(2)));
        System.out.println(" +: " + String.valueOf(d.add(a1)));
        System.out.println(" +: " + String.valueOf(d.add(a1.add(a2))));
        d = new Duration("P1DT2H3M1.5S");
        System.out.println("V:  " + String.valueOf(d));
        System.out.println("F:  " + d.formattedString());
        System.out.println(" D: " + String.valueOf(d.divide(2)));
        System.out.println(" +: " + String.valueOf(d.add(a1)));
        System.out.println(" +: " + String.valueOf(d.add(a1.add(a2))));
        d = new Duration("PT1.5S");
        System.out.println("V:  " + String.valueOf(d));
        System.out.println("F:  " + d.formattedString());
        System.out.println(" D: " + String.valueOf(d.divide(2)));
        System.out.println(" +: " + String.valueOf(d.add(a1)));
        System.out.println(" +: " + String.valueOf(d.add(a1.add(a2))));
        d = new Duration("P20M");
        System.out.println("V:  " + String.valueOf(d));
        System.out.println("F:  " + d.formattedString());
        System.out.println(" D: " + String.valueOf(d.divide(2)));
        System.out.println(" +: " + String.valueOf(d.add(a1)));
        System.out.println(" +: " + String.valueOf(d.add(a1.add(a2))));
        d = new Duration("P0Y20M0D");
        System.out.println("V:  " + String.valueOf(d));
        System.out.println("F:  " + d.formattedString());
        System.out.println(" D: " + String.valueOf(d.divide(2)));
        System.out.println(" +: " + String.valueOf(d.add(a1)));
        System.out.println(" +: " + String.valueOf(d.add(a1.add(a2))));
        d = new Duration("-P60D");
        System.out.println("V:  " + String.valueOf(d));
        System.out.println("F:  " + d.formattedString());
        System.out.println(" D: " + String.valueOf(d.divide(10)));
        System.out.println(" +: " + String.valueOf(d.add(a2)));
        d = new Duration("P1H");
        System.out.println("V:  " + String.valueOf(d));
        System.out.println("F:  " + d.formattedString());
        System.out.println(" D: " + String.valueOf(d.divide(10)));
        System.out.println(" +: " + String.valueOf(d.add(a2)));
        d = new Duration("PT1H");
        System.out.println("V:  " + String.valueOf(d));
        System.out.println("F:  " + d.formattedString());
        System.out.println(" D: " + String.valueOf(d.divide(10)));
        System.out.println(" +: " + String.valueOf(d.add(a2)));
    }
}

