/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.search;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.alfresco.api.AlfrescoPublicApi;

@AlfrescoPublicApi
public class RangeParameters {
    private final String field;
    private final String start;
    private final String end;
    private final String gap;
    private final boolean hardend;
    private final List<String> other;
    private final List<String> include;
    private final String label;
    private final List<String> excludeFilters;

    @JsonCreator
    public RangeParameters(@JsonProperty(value="field") String field, @JsonProperty(value="start") String start, @JsonProperty(value="end") String end, @JsonProperty(value="gap") String gap, @JsonProperty(value="hardend") boolean hardend, @JsonProperty(value="other") List<String> other, @JsonProperty(value="include") List<String> include, @JsonProperty(value="label") String label, @JsonProperty(value="excludeFilters") List<String> excludeFilters) {
        this.field = field;
        this.start = start;
        this.end = end;
        this.gap = gap;
        this.hardend = hardend;
        this.other = other == null ? Collections.emptyList() : other;
        this.include = include == null ? Collections.emptyList() : include;
        this.label = label;
        this.excludeFilters = excludeFilters == null ? Collections.emptyList() : excludeFilters;
    }

    public String getField() {
        return this.field;
    }

    public String getStart() {
        return this.start;
    }

    public String getEnd() {
        return this.end;
    }

    public String getGap() {
        return this.gap;
    }

    public boolean isHardend() {
        return this.hardend;
    }

    public List<String> getOther() {
        return this.other;
    }

    public List<String> getInclude() {
        return this.include;
    }

    public String getLabel() {
        return this.label;
    }

    public List<String> getExcludeFilters() {
        return this.excludeFilters;
    }

    public String getRangeFirstBucketStartInclusive() {
        if (this.include != null && !this.include.isEmpty()) {
            Iterator<String> iterator = this.include.iterator();
            while (iterator.hasNext()) {
                String startInc;
                switch (startInc = iterator.next()) {
                    case "before": {
                        break;
                    }
                    case "edge": {
                        return "[";
                    }
                    case "lower": {
                        return "[";
                    }
                }
            }
            return "<";
        }
        return "[";
    }

    public String getRangeFirstBucketEndInclusive() {
        if (this.include != null && !this.include.isEmpty()) {
            Iterator<String> iterator = this.include.iterator();
            while (iterator.hasNext()) {
                String startInc;
                switch (startInc = iterator.next()) {
                    case "upper": {
                        return "]";
                    }
                    case "outer": {
                        if (this.other == null || !this.other.contains("before") && !this.other.contains("after")) break;
                        return "]";
                    }
                }
            }
        }
        return ">";
    }

    public String getRangeBucketStartInclusive() {
        if (this.include != null && !this.include.isEmpty()) {
            Iterator<String> iterator = this.include.iterator();
            while (iterator.hasNext()) {
                String key;
                switch (key = iterator.next()) {
                    case "lower": {
                        return "[";
                    }
                }
            }
            return "<";
        }
        return "[";
    }

    public String getRangeBucketEndInclusive() {
        if (this.include != null && !this.include.isEmpty()) {
            Iterator<String> iterator = this.include.iterator();
            while (iterator.hasNext()) {
                String key;
                switch (key = iterator.next()) {
                    case "upper": {
                        return "]";
                    }
                }
            }
        }
        return ">";
    }

    public String getRangeLastBucketEndInclusive() {
        if (this.include != null && !this.include.isEmpty()) {
            Iterator<String> iterator = this.include.iterator();
            while (iterator.hasNext()) {
                String key;
                switch (key = iterator.next()) {
                    case "edge": {
                        return "]";
                    }
                    case "upper": {
                        return "]";
                    }
                }
            }
            return ">";
        }
        return "]";
    }
}

