/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import org.alfresco.repo.dictionary.M2DataType;
import org.alfresco.repo.dictionary.M2Label;
import org.alfresco.repo.dictionary.ModelQuery;
import org.alfresco.repo.i18n.StaticMessageLookup;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;

class M2DataTypeDefinition
implements DataTypeDefinition {
    private static final String ERR_NOT_DEFINED_NAMESPACE = "d_dictionary.data_type.namespace_not_defined";
    private static final String ERR_JAVA_CLASS_NOT_SPECIFIED = "d_dictionary.data_type.java_class_not_specified";
    private static final String ERR_JAVA_CLASS_INVALID = "d_dictionary.data_type.java_class_invalid";
    private ModelDefinition model;
    private QName name;
    private M2DataType dataType;
    private String analyserResourceBundleName;
    private transient MessageLookup staticMessageLookup = new StaticMessageLookup();

    M2DataTypeDefinition(ModelDefinition model, M2DataType propertyType, NamespacePrefixResolver resolver) {
        this.model = model;
        this.name = QName.createQName(propertyType.getName(), resolver);
        if (!model.isNamespaceDefined(this.name.getNamespaceURI())) {
            throw new DictionaryException(ERR_NOT_DEFINED_NAMESPACE, this.name.toPrefixString(), this.name.getNamespaceURI(), model.getName().toPrefixString());
        }
        this.dataType = propertyType;
    }

    void resolveDependencies(ModelQuery query) {
        String javaClass = this.dataType.getJavaClassName();
        if (javaClass == null) {
            throw new DictionaryException(ERR_JAVA_CLASS_NOT_SPECIFIED, this.name.toPrefixString());
        }
        try {
            Class.forName(javaClass);
        }
        catch (ClassNotFoundException e) {
            throw new DictionaryException(ERR_JAVA_CLASS_INVALID, javaClass, this.name.toPrefixString(), e);
        }
    }

    public String toString() {
        return this.getName().toString();
    }

    @Override
    public ModelDefinition getModel() {
        return this.model;
    }

    @Override
    public QName getName() {
        return this.name;
    }

    @Override
    public String getTitle() {
        return this.getTitle(this.staticMessageLookup);
    }

    @Override
    public String getDescription() {
        return this.getDescription(this.staticMessageLookup);
    }

    @Override
    public String getTitle(MessageLookup messageLookup) {
        String value = M2Label.getLabel(this.model, messageLookup, "datatype", this.name, "title");
        if (value == null) {
            value = this.dataType.getTitle();
        }
        return value;
    }

    @Override
    public String getDescription(MessageLookup messageLookup) {
        String value = M2Label.getLabel(this.model, messageLookup, "datatype", this.name, "description");
        if (value == null) {
            value = this.dataType.getDescription();
        }
        return value;
    }

    @Override
    public String getJavaClassName() {
        return this.dataType.getJavaClassName();
    }
}

