/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;

public abstract class ConfigFileFinder {
    private final ObjectMapper jsonObjectMapper;
    private int fileCount;

    public ConfigFileFinder(ObjectMapper jsonObjectMapper) {
        this.jsonObjectMapper = jsonObjectMapper;
    }

    public int getFileCount() {
        return this.fileCount;
    }

    public void setFileCount(int fileCount) {
        this.fileCount = fileCount;
    }

    public boolean readFiles(String path, Log log) {
        AtomicBoolean successReadingConfig = new AtomicBoolean(true);
        try {
            AtomicBoolean somethingRead = new AtomicBoolean(false);
            File jarFile = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
            if (jarFile.isFile()) {
                this.readFromJar(jarFile, path, log, successReadingConfig, somethingRead);
            } else {
                Iterator<URL> pathUrls = this.getClass().getClassLoader().getResources(path).asIterator();
                while (pathUrls.hasNext()) {
                    URL url = pathUrls.next();
                    if (url == null) continue;
                    String urlPath = URLDecoder.decode(url.getPath(), "UTF-8");
                    this.readFromDisk(urlPath, log, successReadingConfig, somethingRead);
                }
            }
            if (!somethingRead.get() && new File(path).exists()) {
                this.readFromDisk(path, log, successReadingConfig, somethingRead);
            }
            if (!somethingRead.get()) {
                log.debug((Object)("No config read from " + path));
            }
        }
        catch (IOException | URISyntaxException e) {
            log.error((Object)("Error reading from " + path), (Throwable)e);
            successReadingConfig.set(false);
        }
        return successReadingConfig.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFromJar(File jarFile, String path, Log log, AtomicBoolean successReadingConfig, AtomicBoolean somethingRead) throws IOException {
        try (JarFile jar = new JarFile(jarFile);){
            Enumeration<JarEntry> entries = jar.entries();
            String prefix = path + "/";
            ArrayList<String> names = new ArrayList<String>();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if ((!name.startsWith(prefix) || name.length() <= prefix.length()) && !name.equals(path)) continue;
                names.add(name);
            }
            Collections.sort(names);
            for (String name : names) {
                InputStreamReader reader = new InputStreamReader(this.getResourceAsStream(name));
                this.readFromReader(successReadingConfig, somethingRead, reader, "resource", name, null, log);
            }
        }
    }

    private void readFromDisk(String path, Log log, AtomicBoolean successReadingConfig, AtomicBoolean somethingRead) throws FileNotFoundException {
        File root = new File(path);
        if (root.isDirectory()) {
            File[] files = root.listFiles();
            Arrays.sort(files, (file1, file2) -> file1.getName().compareTo(file2.getName()));
            for (File file : files) {
                if (!file.isDirectory()) {
                    FileReader reader = new FileReader(file);
                    String filePath = file.getPath();
                    this.readFromReader(successReadingConfig, somethingRead, reader, "file", filePath, null, log);
                    continue;
                }
                log.debug((Object)("Skipping directory " + file.getName() + " in " + path));
            }
        } else {
            FileReader reader = new FileReader(root);
            String filePath = root.getPath();
            this.readFromReader(successReadingConfig, somethingRead, reader, "file", filePath, null, log);
        }
    }

    private InputStream getResourceAsStream(String resource) {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
        return in == null ? this.getClass().getResourceAsStream(resource) : in;
    }

    private void readFromReader(AtomicBoolean successReadingConfig, AtomicBoolean somethingRead, Reader reader, String readFrom, String path, String baseUrl, Log log) {
        somethingRead.set(true);
        boolean success = this.readFile(reader, readFrom, path, null, log);
        if (success) {
            ++this.fileCount;
        }
        boolean newSuccessReadingConfig = successReadingConfig.get();
        successReadingConfig.set(newSuccessReadingConfig &= success);
    }

    public boolean readFile(Reader reader, String readFrom, String path, String baseUrl, Log log) {
        boolean successReadingConfig = true;
        try {
            JsonNode jsonNode = (JsonNode)this.jsonObjectMapper.readValue(reader, JsonNode.class);
            String readFromMessage = readFrom + " " + path;
            if (log.isTraceEnabled()) {
                log.trace((Object)(readFromMessage + " config is: " + String.valueOf(jsonNode)));
            } else {
                log.debug((Object)(readFromMessage + " config read"));
            }
            this.readJson(jsonNode, readFromMessage, baseUrl);
        }
        catch (Exception e) {
            log.error((Object)("Error reading " + path), (Throwable)e);
            successReadingConfig = false;
        }
        return successReadingConfig;
    }

    protected abstract void readJson(JsonNode var1, String var2, String var3) throws IOException;
}

