/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.search;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.alfresco.opencmis.dictionary.CMISDictionaryService;
import org.alfresco.opencmis.dictionary.CMISNodeInfo;
import org.alfresco.opencmis.dictionary.PropertyDefinitionWrapper;
import org.alfresco.opencmis.dictionary.TypeDefinitionWrapper;
import org.alfresco.repo.search.adaptor.LuceneFunction;
import org.alfresco.repo.search.adaptor.QueryParserAdaptor;
import org.alfresco.repo.search.impl.querymodel.FunctionArgument;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.PredicateMode;
import org.alfresco.repo.search.impl.querymodel.QueryModelException;
import org.alfresco.repo.search.impl.querymodel.Selector;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;

public class CmisFunctionEvaluationContext
implements FunctionEvaluationContext {
    private static HashSet<String> EXPOSED_FIELDS = new HashSet();
    public static BaseTypeId[] STRICT_SCOPES = new BaseTypeId[]{BaseTypeId.CMIS_DOCUMENT, BaseTypeId.CMIS_FOLDER};
    public static BaseTypeId[] ALFRESCO_SCOPES = new BaseTypeId[]{BaseTypeId.CMIS_DOCUMENT, BaseTypeId.CMIS_FOLDER, BaseTypeId.CMIS_POLICY, BaseTypeId.CMIS_SECONDARY, BaseTypeId.CMIS_ITEM};
    private Map<String, NodeRef> nodeRefs;
    private Map<String, Float> scores;
    private Map<NodeRef, CMISNodeInfo> nodeInfos;
    private NodeService nodeService;
    private CMISDictionaryService cmisDictionaryService;
    private BaseTypeId[] validScopes;
    private Float score;

    public void setNodeRefs(Map<String, NodeRef> nodeRefs) {
        this.nodeRefs = nodeRefs;
    }

    public void setScores(Map<String, Float> scores) {
        this.scores = scores;
    }

    public void setNodeInfos(Map<NodeRef, CMISNodeInfo> nodeInfos) {
        this.nodeInfos = nodeInfos;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setCmisDictionaryService(CMISDictionaryService cmisDictionaryService) {
        this.cmisDictionaryService = cmisDictionaryService;
    }

    public void setValidScopes(BaseTypeId[] validScopes) {
        this.validScopes = validScopes;
    }

    @Override
    public Map<String, NodeRef> getNodeRefs() {
        return this.nodeRefs;
    }

    @Override
    public NodeService getNodeService() {
        return this.nodeService;
    }

    @Override
    public Serializable getProperty(NodeRef nodeRef, String propertyName) {
        PropertyDefinitionWrapper propertyDef = this.cmisDictionaryService.findProperty(propertyName);
        CMISNodeInfo nodeInfo = this.nodeInfos.get(nodeRef);
        if (nodeInfo == null) {
            nodeInfo = propertyDef.getPropertyAccessor().createNodeInfo(nodeRef);
            this.nodeInfos.put(nodeRef, nodeInfo);
        }
        return propertyDef.getPropertyAccessor().getValue(nodeInfo);
    }

    @Override
    public Map<String, Float> getScores() {
        return this.scores;
    }

    @Override
    public Float getScore() {
        return this.score;
    }

    public void setScore(Float score) {
        this.score = score;
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneEquality(QueryParserAdaptor<Q, S, E> lqpa, String propertyName, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws E {
        PropertyDefinitionWrapper propertyDef = this.cmisDictionaryService.findProperty(propertyName);
        return propertyDef.getPropertyLuceneBuilder().buildLuceneEquality(lqpa, value, mode, luceneFunction);
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneExists(QueryParserAdaptor<Q, S, E> lqpa, String propertyName, Boolean not) throws E {
        PropertyDefinitionWrapper propertyDef = this.cmisDictionaryService.findProperty(propertyName);
        return propertyDef.getPropertyLuceneBuilder().buildLuceneExists(lqpa, not);
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneGreaterThan(QueryParserAdaptor<Q, S, E> lqpa, String propertyName, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws E {
        PropertyDefinitionWrapper propertyDef = this.cmisDictionaryService.findProperty(propertyName);
        return propertyDef.getPropertyLuceneBuilder().buildLuceneGreaterThan(lqpa, value, mode, luceneFunction);
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneGreaterThanOrEquals(QueryParserAdaptor<Q, S, E> lqpa, String propertyName, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws E {
        PropertyDefinitionWrapper propertyDef = this.cmisDictionaryService.findProperty(propertyName);
        return propertyDef.getPropertyLuceneBuilder().buildLuceneGreaterThanOrEquals(lqpa, value, mode, luceneFunction);
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneIn(QueryParserAdaptor<Q, S, E> lqpa, String propertyName, Collection<Serializable> values, Boolean not, PredicateMode mode) throws E {
        PropertyDefinitionWrapper propertyDef = this.cmisDictionaryService.findProperty(propertyName);
        return propertyDef.getPropertyLuceneBuilder().buildLuceneIn(lqpa, values, not, mode);
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneInequality(QueryParserAdaptor<Q, S, E> lqpa, String propertyName, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws E {
        PropertyDefinitionWrapper propertyDef = this.cmisDictionaryService.findProperty(propertyName);
        return propertyDef.getPropertyLuceneBuilder().buildLuceneInequality(lqpa, value, mode, luceneFunction);
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneLessThan(QueryParserAdaptor<Q, S, E> lqpa, String propertyName, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws E {
        PropertyDefinitionWrapper propertyDef = this.cmisDictionaryService.findProperty(propertyName);
        return propertyDef.getPropertyLuceneBuilder().buildLuceneLessThan(lqpa, value, mode, luceneFunction);
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneLessThanOrEquals(QueryParserAdaptor<Q, S, E> lqpa, String propertyName, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws E {
        PropertyDefinitionWrapper propertyDef = this.cmisDictionaryService.findProperty(propertyName);
        return propertyDef.getPropertyLuceneBuilder().buildLuceneLessThanOrEquals(lqpa, value, mode, luceneFunction);
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneLike(QueryParserAdaptor<Q, S, E> lqpa, String propertyName, Serializable value, Boolean not) throws E {
        PropertyDefinitionWrapper propertyDef = this.cmisDictionaryService.findProperty(propertyName);
        return propertyDef.getPropertyLuceneBuilder().buildLuceneLike(lqpa, value, not);
    }

    @Override
    public <Q, S, E extends Throwable> String getLuceneSortField(QueryParserAdaptor<Q, S, E> lqpa, String propertyName) throws E {
        PropertyDefinitionWrapper propertyDef = this.cmisDictionaryService.findProperty(propertyName);
        return propertyDef.getPropertyLuceneBuilder().getLuceneSortField(lqpa);
    }

    @Override
    public boolean isObjectId(String propertyName) {
        return "cmis:objectId".equalsIgnoreCase(propertyName);
    }

    @Override
    public boolean isOrderable(String fieldName) {
        PropertyDefinitionWrapper propertyDef = this.cmisDictionaryService.findProperty(fieldName);
        if (propertyDef == null) {
            return false;
        }
        return propertyDef.getPropertyDefinition().isOrderable();
    }

    @Override
    public boolean isQueryable(String fieldName) {
        PropertyDefinitionWrapper propertyDef = this.cmisDictionaryService.findProperty(fieldName);
        if (propertyDef == null) {
            return true;
        }
        return propertyDef.getPropertyDefinition().isQueryable();
    }

    @Override
    public String getLuceneFieldName(String propertyName) {
        PropertyDefinitionWrapper propertyDef = this.cmisDictionaryService.findProperty(propertyName);
        if (propertyDef != null) {
            return propertyDef.getPropertyLuceneBuilder().getLuceneFieldName();
        }
        return propertyName;
    }

    @Override
    public LuceneFunction getLuceneFunction(FunctionArgument functionArgument) {
        if (functionArgument == null) {
            return LuceneFunction.FIELD;
        }
        String functionName = functionArgument.getFunction().getName();
        if (functionName.equals("Upper")) {
            return LuceneFunction.UPPER;
        }
        if (functionName.equals("Lower")) {
            return LuceneFunction.LOWER;
        }
        throw new QueryModelException("Unsupported function: " + functionName);
    }

    @Override
    public void checkFieldApplies(Selector selector, String propertyName) {
        PropertyDefinitionWrapper propDef = this.cmisDictionaryService.findPropertyByQueryName(propertyName);
        if (propDef == null) {
            if (EXPOSED_FIELDS.contains(propertyName)) {
                return;
            }
            throw new CmisInvalidArgumentException("Unknown column/property " + propertyName);
        }
        TypeDefinitionWrapper typeDef = this.cmisDictionaryService.findTypeForClass(selector.getType(), this.validScopes);
        if (typeDef == null) {
            throw new CmisInvalidArgumentException("Type unsupported in CMIS queries: " + selector.getAlias());
        }
        if (typeDef.getPropertyById(propDef.getPropertyId()) == null) {
            throw new CmisInvalidArgumentException("Invalid column for " + typeDef.getTypeDefinition(false).getQueryName() + "." + propertyName);
        }
    }

    @Override
    public boolean isMultiValued(String propertyName) {
        PropertyDefinitionWrapper propDef = this.cmisDictionaryService.findPropertyByQueryName(propertyName);
        if (propDef == null) {
            throw new CmisInvalidArgumentException("Unknown column/property " + propertyName);
        }
        return propDef.getPropertyDefinition().getCardinality() == Cardinality.MULTI;
    }

    @Override
    public String getAlfrescoPropertyName(String propertyName) {
        PropertyDefinitionWrapper propertyDef = this.cmisDictionaryService.findProperty(propertyName);
        if (propertyDef != null) {
            return propertyDef.getPropertyLuceneBuilder().getLuceneFieldName().substring(1);
        }
        throw new CmisInvalidArgumentException("Unknown column/property " + propertyName);
    }

    @Override
    public String getAlfrescoTypeName(String typeName) {
        TypeDefinitionWrapper typeDef = this.cmisDictionaryService.findType(typeName);
        if (typeDef != null) {
            return typeDef.getAlfrescoClass().toString();
        }
        throw new CmisInvalidArgumentException("Unknown type " + typeName);
    }

    static {
        EXPOSED_FIELDS.add("PATH");
        EXPOSED_FIELDS.add("TEXT");
        EXPOSED_FIELDS.add("ID");
        EXPOSED_FIELDS.add("ISROOT");
        EXPOSED_FIELDS.add("ISNODE");
        EXPOSED_FIELDS.add("TX");
        EXPOSED_FIELDS.add("PARENT");
        EXPOSED_FIELDS.add("PRIMARYPARENT");
        EXPOSED_FIELDS.add("QNAME");
        EXPOSED_FIELDS.add("CLASS");
        EXPOSED_FIELDS.add("TYPE");
        EXPOSED_FIELDS.add("EXACTTYPE");
        EXPOSED_FIELDS.add("ASPECT");
        EXPOSED_FIELDS.add("EXACTASPECT");
        EXPOSED_FIELDS.add("ALL");
        EXPOSED_FIELDS.add("ISUNSET");
        EXPOSED_FIELDS.add("ISNULL");
        EXPOSED_FIELDS.add("ISNOTNULL");
        EXPOSED_FIELDS.add("FTSSTATUS");
        EXPOSED_FIELDS.add("ASSOCTYPEQNAME");
        EXPOSED_FIELDS.add("PRIMARYASSOCTYPEQNAME");
        EXPOSED_FIELDS.add("DBID");
        EXPOSED_FIELDS.add("TAG");
        EXPOSED_FIELDS.add("TENANT");
        EXPOSED_FIELDS.add("ANCESTOR");
        EXPOSED_FIELDS.add("SITE");
        EXPOSED_FIELDS.add("TAG");
        EXPOSED_FIELDS.add("PNAME");
        EXPOSED_FIELDS.add("NPATH");
        EXPOSED_FIELDS.add("ANAME");
        EXPOSED_FIELDS.add("APATH");
        EXPOSED_FIELDS.add("DOC_TYPE");
        EXPOSED_FIELDS.add("d:" + DataTypeDefinition.ANY.getLocalName());
        EXPOSED_FIELDS.add("d:" + DataTypeDefinition.ASSOC_REF.getLocalName());
        EXPOSED_FIELDS.add("d:" + DataTypeDefinition.BOOLEAN.getLocalName());
        EXPOSED_FIELDS.add("d:" + DataTypeDefinition.CATEGORY.getLocalName());
        EXPOSED_FIELDS.add("d:" + DataTypeDefinition.CHILD_ASSOC_REF.getLocalName());
        EXPOSED_FIELDS.add("d:" + DataTypeDefinition.CONTENT.getLocalName());
        EXPOSED_FIELDS.add("d:" + DataTypeDefinition.DATE.getLocalName());
        EXPOSED_FIELDS.add("d:" + DataTypeDefinition.DATETIME.getLocalName());
        EXPOSED_FIELDS.add("d:" + DataTypeDefinition.DOUBLE.getLocalName());
        EXPOSED_FIELDS.add("d:" + DataTypeDefinition.FLOAT.getLocalName());
        EXPOSED_FIELDS.add("d:" + DataTypeDefinition.INT.getLocalName());
        EXPOSED_FIELDS.add("d:" + DataTypeDefinition.LOCALE.getLocalName());
        EXPOSED_FIELDS.add("d:" + DataTypeDefinition.LONG.getLocalName());
        EXPOSED_FIELDS.add("d:" + DataTypeDefinition.MLTEXT.getLocalName());
        EXPOSED_FIELDS.add("d:" + DataTypeDefinition.NODE_REF.getLocalName());
        EXPOSED_FIELDS.add("d:" + DataTypeDefinition.PATH.getLocalName());
        EXPOSED_FIELDS.add("d:" + DataTypeDefinition.PERIOD.getLocalName());
        EXPOSED_FIELDS.add("d:" + DataTypeDefinition.QNAME.getLocalName());
        EXPOSED_FIELDS.add("d:" + DataTypeDefinition.TEXT.getLocalName());
    }
}

