/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.BasicSearchParameters;
import org.alfresco.service.cmr.search.SearchParameters;

public class StatsParameters
implements BasicSearchParameters {
    public static final String PARAM_FIELD = "field";
    public static final String PARAM_FACET = "facet";
    public static final String FACET_PREFIX = "@";
    private final String language;
    private final String query;
    private final String filterQuery;
    private final boolean dateSearch;
    private List<StoreRef> stores = new ArrayList<StoreRef>();
    private List<Locale> locales = new ArrayList<Locale>();
    private List<SearchParameters.SortDefinition> sortDefinitions = new ArrayList<SearchParameters.SortDefinition>();
    private Map<String, String> statsParameters = new HashMap<String, String>();

    public StatsParameters(String language, String query) {
        this(language, query, null, false);
    }

    public StatsParameters(String language, String query, boolean isDateSearch) {
        this(language, query, null, isDateSearch);
    }

    public StatsParameters(String language, String query, String filterQuery, boolean isDateSearch) {
        this.language = language;
        this.query = query;
        this.filterQuery = filterQuery;
        this.dateSearch = isDateSearch;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    public String getFilterQuery() {
        return this.filterQuery;
    }

    @Override
    public List<StoreRef> getStores() {
        return this.stores;
    }

    @Override
    public List<Locale> getLocales() {
        return this.locales;
    }

    @Override
    public List<SearchParameters.SortDefinition> getSortDefinitions() {
        return this.sortDefinitions;
    }

    public Map<String, String> getStatsParameters() {
        return this.statsParameters;
    }

    public boolean isDateSearch() {
        return this.dateSearch;
    }

    public void addSort(SearchParameters.SortDefinition sortDefinition) {
        this.sortDefinitions.add(sortDefinition);
    }

    public void addStatsParameter(String name, String value) {
        this.statsParameters.put(name, value);
    }

    public void addStore(StoreRef store) {
        if (this.stores.size() != 0) {
            throw new IllegalStateException("At the moment, there can only be one stats store set for the search");
        }
        this.stores.add(store);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("StatsParameters [query=").append(this.query).append(", filterquery=").append(this.filterQuery).append(", language=").append(this.language).append(", stores=").append(this.stores).append(", locales=").append(this.locales).append(", sortDefinitions=").append(this.sortDefinitions).append(", statsParameters=").append(this.statsParameters).append(", isDateSearch=").append(this.dateSearch).append("]");
        return builder.toString();
    }
}

