/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.v0;

import java.text.MessageFormat;
import java.util.Map;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.core.v0.BaseAPI;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.HttpResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.testng.AssertJUnit;

@Component
public class RecordsAPI
extends BaseAPI {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecordsAPI.class);
    private static final String CREATE_NON_ELECTRONIC_RECORD_API = "{0}type/rma:nonElectronicDocument/formprocessor";

    public HttpResponse declareDocumentAsRecord(String user, String password, String siteID, String documentName) {
        String docNodeRef = RecordsAPI.getNodeRefSpacesStore() + this.contentService.getNodeRef(user, password, siteID, documentName);
        JSONObject requestParams = new JSONObject();
        requestParams.put("actionedUponNode", (Object)docNodeRef);
        requestParams.put("actionDefinitionName", (Object)"create-record");
        return this.doPostJsonRequest(user, password, 200, requestParams, "{0}actionQueue", new String[0]);
    }

    public HttpResponse completeRecord(String user, String password, String recordName) {
        String recNodeRef = RecordsAPI.getNodeRefSpacesStore() + this.contentService.getNodeRef(user, password, "rm", recordName);
        JSONObject requestParams = new JSONObject();
        requestParams.put("name", (Object)"declareRecord");
        requestParams.put("nodeRef", (Object)recNodeRef);
        return this.doPostJsonRequest(user, password, 200, requestParams, "{0}rma/actions/ExecutionQueue", new String[0]);
    }

    public HttpResponse rejectRecord(String user, String password, String recordName, String reason) {
        return this.rejectRecord(user, password, 200, recordName, reason);
    }

    public HttpResponse rejectRecord(String user, String password, int expectedStatusCode, String recordName, String reason) {
        String recNodeRef = RecordsAPI.getNodeRefSpacesStore() + this.contentService.getNodeRef(user, password, "rm", recordName);
        JSONObject requestParams = new JSONObject();
        requestParams.put("name", (Object)"reject");
        requestParams.put("nodeRef", (Object)recNodeRef);
        requestParams.put("params", (Object)new JSONObject().put("reason", (Object)reason));
        return this.doPostJsonRequest(user, password, expectedStatusCode, requestParams, "{0}rma/actions/ExecutionQueue", new String[0]);
    }

    public HttpResponse declareDocumentVersionAsRecord(String user, String password, String siteID, String documentName) {
        String docNodeRef = RecordsAPI.getNodeRefSpacesStore() + this.contentService.getNodeRef(user, password, siteID, documentName);
        JSONObject requestParams = new JSONObject();
        requestParams.put("actionedUponNode", (Object)docNodeRef);
        requestParams.put("actionDefinitionName", (Object)"declare-as-version-record");
        return this.doPostJsonRequest(user, password, 200, requestParams, "{0}actionQueue", new String[0]);
    }

    public <K extends Enum<?>> HttpResponse createNonElectronicRecord(String username, String password, Map<K, String> properties, String categoryName, String folderName) {
        CmisObject record;
        String recordName = properties.get((Object)BaseAPI.RMProperty.NAME);
        if (this.getRecord(username, password, folderName, recordName) != null) {
            return null;
        }
        String recordPath = "/" + categoryName;
        if (!folderName.equals("")) {
            recordPath = recordPath + "/" + folderName;
        }
        if ((record = this.getObjectByPath(username, password, RecordsAPI.getFilePlanPath() + recordPath + "/" + recordName)) != null) {
            return null;
        }
        String recordTitle = this.getPropertyValue(properties, BaseAPI.RMProperty.TITLE);
        String description = this.getPropertyValue(properties, BaseAPI.RMProperty.DESCRIPTION);
        String physicalSize = this.getPropertyValue(properties, BaseAPI.RMProperty.PHYSICAL_SIZE);
        String numberOfCopies = this.getPropertyValue(properties, BaseAPI.RMProperty.NUMBER_OF_COPIES);
        String shelf = this.getPropertyValue(properties, BaseAPI.RMProperty.SHELF);
        String storage = this.getPropertyValue(properties, BaseAPI.RMProperty.STORAGE_LOCATION);
        String box = this.getPropertyValue(properties, BaseAPI.RMProperty.BOX);
        String file = this.getPropertyValue(properties, BaseAPI.RMProperty.FILE);
        String parentNodeRef = this.getItemNodeRef(username, password, recordPath);
        JSONObject requestParams = new JSONObject();
        requestParams.put("alf_destination", (Object)(RecordsAPI.getNodeRefSpacesStore() + parentNodeRef));
        requestParams.put("prop_cm_name", (Object)recordName);
        requestParams.put("prop_cm_title", (Object)recordTitle);
        requestParams.put("prop_cm_description", (Object)description);
        requestParams.put("prop_rma_physicalSize", (Object)physicalSize);
        requestParams.put("prop_rma_numberOfCopies", (Object)numberOfCopies);
        requestParams.put("prop_rma_storageLocation", (Object)storage);
        requestParams.put("prop_rma_shelf", (Object)shelf);
        requestParams.put("prop_rma_box", (Object)box);
        requestParams.put("prop_rma_file", (Object)file);
        return this.doPostJsonRequest(username, password, 200, requestParams, CREATE_NON_ELECTRONIC_RECORD_API, new String[0]);
    }

    public void uploadElectronicRecord(String username, String password, Map<BaseAPI.RMProperty, String> properties, String folderName, CMISUtil.DocumentType documentType) {
        String recordName = this.getPropertyValue(properties, BaseAPI.RMProperty.NAME);
        String recordContent = this.getPropertyValue(properties, BaseAPI.RMProperty.CONTENT);
        boolean success = this.getRecord(username, password, folderName, recordName) != null || this.contentService.createDocumentInFolder(username, password, "rm", folderName, documentType, recordName, recordContent) != null;
        AssertJUnit.assertTrue((String)("Failed to upload electronic record to " + folderName), (boolean)success);
    }

    public void deleteRecord(String username, String password, String recordName, String categoryName, String folderName) {
        String recordPath = "/" + categoryName;
        if (!folderName.equals("")) {
            recordPath = recordPath + "/" + folderName;
        }
        this.deleteItem(username, password, recordPath + "/" + recordName);
    }

    public CmisObject getRecord(String username, String password, String folderName, String recordName) {
        for (CmisObject record : this.contentService.getFolderObject(this.contentService.getCMISSession(username, password), "rm", folderName).getChildren()) {
            if (!record.getName().startsWith(recordName)) continue;
            return record;
        }
        return null;
    }

    public String getRecordFullName(String username, String password, String folderName, String recordPartialName) {
        CmisObject record = this.getRecord(username, password, folderName, recordPartialName);
        if (record != null) {
            return record.getName();
        }
        return "";
    }

    public Pair<Boolean, String> shareDocument(String user, String password, String nodeId) throws JSONException {
        JSONObject response = this.doPostRequest(user, password, null, MessageFormat.format("{0}internal/shared/share/workspace/SpacesStore/{1}", "{0}", nodeId), new String[0]);
        try {
            if (response.has("sharedId")) {
                return Pair.of((Object)true, (Object)response.getString("sharedId"));
            }
        }
        catch (JSONException e) {
            LOGGER.info("Unable to extract response parameter", (Throwable)e);
        }
        return Pair.of((Object)false, (Object)String.valueOf(response.getJSONObject("status").getInt("code")));
    }

    public HttpResponse hideRecord(String user, String password, String nodeId) {
        String docNodeRef = RecordsAPI.getNodeRefSpacesStore() + nodeId;
        JSONObject requestParams = new JSONObject();
        requestParams.put("actionedUponNode", (Object)docNodeRef);
        requestParams.put("actionDefinitionName", (Object)"hide-record");
        return this.doPostJsonRequest(user, password, 200, requestParams, "{0}actionQueue", new String[0]);
    }

    public String getRecordNodeRef(String username, String password, String recordName, String recordPath) {
        return RecordsAPI.getNodeRefSpacesStore() + this.getItemNodeRef(username, password, recordPath + "/" + recordName);
    }
}

