/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.recordcategories;

import org.alfresco.rest.core.v0.BaseAPI;
import org.alfresco.rest.core.v0.RMEvents;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.model.recordcategory.RetentionPeriodProperty;
import org.alfresco.rest.rm.community.utils.CoreUtil;
import org.alfresco.rest.v0.service.DispositionScheduleService;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class MoveRecCategoriesWithRSTests
extends BaseRMRestTest {
    private RecordCategory rootCategory;
    private RecordCategory rootCategory2;
    private Record elRecord;
    private Record nonElRecord;
    @Autowired
    private DispositionScheduleService dispositionScheduleService;

    @BeforeMethod
    private void setUpMoveRecCategoriesWithRSTests() {
        Step.STEP((String)"Create record category with retention schedule and apply it to records.");
        this.rootCategory = this.createRootCategory(RandomData.getRandomName((String)"rootCategory1"));
        this.dispositionScheduleService.createCategoryRetentionSchedule(this.rootCategory.getName(), Boolean.valueOf(true));
        Step.STEP((String)"Create record category with retention schedule and apply it to records.");
        this.rootCategory2 = this.createRootCategory(RandomData.getRandomName((String)"rootCategory2"));
        this.dispositionScheduleService.createCategoryRetentionSchedule(this.rootCategory2.getName(), Boolean.valueOf(true));
    }

    @Test
    @AlfrescoTest(jira="APPS-1005")
    public void testInheritWhenMoveToDifferentRSStep() throws Exception {
        Step.STEP((String)"Add retention schedule cut off step after 1 day period.");
        this.dispositionScheduleService.addCutOffAfterPeriodStep(this.rootCategory.getName(), "day|1", RetentionPeriodProperty.CREATED_DATE);
        Step.STEP((String)"Add retention schedule destroy step after 1 Day period.");
        this.dispositionScheduleService.addDestroyWithGhostingAfterPeriodStep(this.rootCategory.getName(), "day|1", RetentionPeriodProperty.CUT_OFF_DATE);
        Step.STEP((String)"Create a subcategory with a record folder and records.");
        RecordCategoryChild subCategory = this.createSubCategoryWithRecords();
        Step.STEP((String)"Add retention schedule retain step after 2 day period.");
        this.dispositionScheduleService.addRetainAfterPeriodStep(this.rootCategory2.getName(), "day|2");
        Step.STEP((String)"Add retention schedule destroy step after 2 Day period.");
        this.dispositionScheduleService.addDestroyWithGhostingAfterPeriodStep(this.rootCategory2.getName(), "day|2", RetentionPeriodProperty.DATE_FILED);
        Step.STEP((String)"Move the subcategory within the rootCategory2.");
        this.getRestAPIFactory().getNodeAPI((RepoTestModel)CoreUtil.toContentModel(subCategory.getId())).move(CoreUtil.createBodyForMoveCopy(this.rootCategory2.getId()));
        this.assertStatusCode(HttpStatus.OK);
        Step.STEP((String)"Check that both records inherit rootCategory2 retention schedule");
        this.elRecord = this.getRestAPIFactory().getRecordsAPI().getRecord(this.elRecord.getId());
        this.nonElRecord = this.getRestAPIFactory().getRecordsAPI().getRecord(this.nonElRecord.getId());
        Assert.assertTrue((boolean)this.elRecord.getProperties().getRecordSearchDispositionActionName().equalsIgnoreCase(BaseAPI.RM_ACTIONS.END_RETENTION.getAction()), (String)"Disposition action should be retain");
        Assert.assertTrue((boolean)this.elRecord.getProperties().getRecordSearchDispositionPeriod().equalsIgnoreCase("day"), (String)"Disposition period property should be day");
        Assert.assertTrue((boolean)this.elRecord.getProperties().getRecordSearchDispositionPeriodExpression().equalsIgnoreCase("2"), (String)"Disposition period expression should be 2");
        Assert.assertTrue((boolean)this.nonElRecord.getProperties().getRecordSearchDispositionActionName().equalsIgnoreCase(BaseAPI.RM_ACTIONS.END_RETENTION.getAction()), (String)"Disposition action should be retain");
        Assert.assertTrue((boolean)this.nonElRecord.getProperties().getRecordSearchDispositionPeriod().equalsIgnoreCase("day"), (String)"Disposition period property should be day");
        Assert.assertTrue((boolean)this.nonElRecord.getProperties().getRecordSearchDispositionPeriodExpression().equalsIgnoreCase("2"), (String)"Disposition period expression should be 2");
    }

    @Test
    @AlfrescoTest(jira="APPS-1004")
    public void testInheritWhenMoveToDifferentRSStepOnEventBase() throws Exception {
        Step.STEP((String)"Add retention schedule retain step after 1 day period.");
        this.dispositionScheduleService.addRetainAfterPeriodStep(this.rootCategory.getName(), "day|1");
        Step.STEP((String)"Add retention schedule destroy step after 1 Day period.");
        this.dispositionScheduleService.addDestroyWithGhostingAfterPeriodStep(this.rootCategory.getName(), "day|1", RetentionPeriodProperty.CUT_OFF_DATE);
        Step.STEP((String)"Create a subcategory with a record folder and records.");
        RecordCategoryChild subCategory = this.createSubCategoryWithRecords();
        Step.STEP((String)"Add retention schedule cut off step on event case closed.");
        this.dispositionScheduleService.addCutOffAfterEventStep(this.rootCategory2.getName(), RMEvents.CASE_CLOSED.getEventName());
        Step.STEP((String)"Add retention schedule destroy step after 1 Day period.");
        this.dispositionScheduleService.addDestroyWithGhostingAfterPeriodStep(this.rootCategory2.getName(), "day|2", RetentionPeriodProperty.DATE_FILED);
        Step.STEP((String)"Move the subcategory within the rootCategory2.");
        this.getRestAPIFactory().getNodeAPI((RepoTestModel)CoreUtil.toContentModel(subCategory.getId())).move(CoreUtil.createBodyForMoveCopy(this.rootCategory2.getId()));
        this.assertStatusCode(HttpStatus.OK);
        Step.STEP((String)"Check that both records inherit rootCategory2 retention schedule");
        this.elRecord = this.getRestAPIFactory().getRecordsAPI().getRecord(this.elRecord.getId());
        this.nonElRecord = this.getRestAPIFactory().getRecordsAPI().getRecord(this.nonElRecord.getId());
        Assert.assertTrue((boolean)this.elRecord.getProperties().getRecordSearchDispositionActionName().equalsIgnoreCase(BaseAPI.RM_ACTIONS.CUT_OFF.getAction()), (String)"Disposition action should be cut off");
        Assert.assertTrue((boolean)this.elRecord.getProperties().getRecordSearchDispositionPeriod().equalsIgnoreCase("none"), (String)"Disposition period property should none");
        Assert.assertTrue((boolean)this.elRecord.getProperties().getRecordSearchDispositionPeriodExpression().equalsIgnoreCase("0"), (String)"Disposition period expression should be 0");
        Assert.assertTrue((boolean)this.elRecord.getProperties().getRecordSearchDispositionEvents().contains(RMEvents.CASE_CLOSED.getEventName()), (String)"Disposition event list doesn't contain case closed event");
        Assert.assertTrue((boolean)this.nonElRecord.getProperties().getRecordSearchDispositionActionName().equalsIgnoreCase(BaseAPI.RM_ACTIONS.CUT_OFF.getAction()), (String)"Disposition action should be cut off");
        Assert.assertTrue((boolean)this.nonElRecord.getProperties().getRecordSearchDispositionPeriod().equalsIgnoreCase("none"), (String)"Disposition period property should be none");
        Assert.assertTrue((boolean)this.nonElRecord.getProperties().getRecordSearchDispositionPeriodExpression().equalsIgnoreCase("0"), (String)"Disposition period expression should be 0");
        Assert.assertTrue((boolean)this.nonElRecord.getProperties().getRecordSearchDispositionEvents().contains(RMEvents.CASE_CLOSED.getEventName()), (String)"Disposition event list doesn't contain case closed event");
    }

    @Test
    @AlfrescoTest(jira="APPS-1004")
    public void testInheritWhenMoveToSameStepDifferentEvent() throws Exception {
        Step.STEP((String)"Add retention schedule cut off on case closed.");
        this.dispositionScheduleService.addCutOffAfterEventStep(this.rootCategory.getName(), RMEvents.CASE_CLOSED.getEventName());
        Step.STEP((String)"Add retention schedule destroy step after 1 Day period.");
        this.dispositionScheduleService.addDestroyWithGhostingAfterPeriodStep(this.rootCategory.getName(), "day|1", RetentionPeriodProperty.CUT_OFF_DATE);
        Step.STEP((String)"Create a subcategory with a record folder and records.");
        RecordCategoryChild subCategory = this.createSubCategoryWithRecords();
        Step.STEP((String)"Add retention schedule cut off step on event separation.");
        this.dispositionScheduleService.addCutOffAfterEventStep(this.rootCategory2.getName(), RMEvents.OBSOLETE.getEventName());
        Step.STEP((String)"Add retention schedule destroy step after 2 Day period.");
        this.dispositionScheduleService.addDestroyWithGhostingAfterPeriodStep(this.rootCategory2.getName(), "day|2", RetentionPeriodProperty.DATE_FILED);
        Step.STEP((String)"Move the subcategory within the rootCategory2.");
        this.getRestAPIFactory().getNodeAPI((RepoTestModel)CoreUtil.toContentModel(subCategory.getId())).move(CoreUtil.createBodyForMoveCopy(this.rootCategory2.getId()));
        this.assertStatusCode(HttpStatus.OK);
        Step.STEP((String)"Check that both records inherit rootCategory2 retention schedule");
        this.elRecord = this.getRestAPIFactory().getRecordsAPI().getRecord(this.elRecord.getId());
        this.nonElRecord = this.getRestAPIFactory().getRecordsAPI().getRecord(this.nonElRecord.getId());
        Assert.assertTrue((boolean)this.elRecord.getProperties().getRecordSearchDispositionActionName().equalsIgnoreCase(BaseAPI.RM_ACTIONS.CUT_OFF.getAction()), (String)"Disposition action should be cut off");
        Assert.assertTrue((boolean)this.elRecord.getProperties().getRecordSearchDispositionPeriod().equalsIgnoreCase("none"), (String)"Disposition period property should be none");
        Assert.assertTrue((boolean)this.elRecord.getProperties().getRecordSearchDispositionPeriodExpression().equalsIgnoreCase("0"), (String)"Disposition period expression should be 0");
        Assert.assertFalse((boolean)this.elRecord.getProperties().getRecordSearchDispositionEvents().contains(RMEvents.CASE_CLOSED.getEventName()), (String)"Event list contain the event from the previous RS ");
        Assert.assertTrue((boolean)this.elRecord.getProperties().getRecordSearchDispositionEvents().contains(RMEvents.OBSOLETE.getEventName()), (String)"Event list doesn't contain the event from the current RS ");
        Assert.assertTrue((boolean)this.nonElRecord.getProperties().getRecordSearchDispositionActionName().equalsIgnoreCase(BaseAPI.RM_ACTIONS.CUT_OFF.getAction()), (String)"Disposition action should be cut off");
        Assert.assertTrue((boolean)this.nonElRecord.getProperties().getRecordSearchDispositionPeriod().equalsIgnoreCase("none"), (String)"Disposition period property should be none");
        Assert.assertTrue((boolean)this.nonElRecord.getProperties().getRecordSearchDispositionPeriodExpression().equalsIgnoreCase("0"), (String)"Disposition period expression should be 0");
        Assert.assertFalse((boolean)this.nonElRecord.getProperties().getRecordSearchDispositionEvents().contains(RMEvents.CASE_CLOSED.getEventName()), (String)"Event list contain the event from the previous RS ");
        Assert.assertTrue((boolean)this.nonElRecord.getProperties().getRecordSearchDispositionEvents().contains(RMEvents.OBSOLETE.getEventName()), (String)"Event list doesn't contain the event from the current RS ");
    }

    @AfterMethod(alwaysRun=true)
    public void cleanupMoveRecCategoriesWithRSTests() {
        this.getRestAPIFactory().getRecordCategoryAPI().deleteRecordCategory(this.rootCategory.getId());
        this.getRestAPIFactory().getRecordCategoryAPI().deleteRecordCategory(this.rootCategory2.getId());
    }

    private RecordCategoryChild createSubCategoryWithRecords() {
        Step.STEP((String)"Create a subcategory with a record folder");
        RecordCategoryChild subCategory = this.createRecordCategory(this.rootCategory.getId(), RandomData.getRandomName((String)"subCategory"));
        RecordCategoryChild recFolder = this.createFolder(subCategory.getId(), RandomData.getRandomName((String)"recFolder"));
        Step.STEP((String)"Create 2 records in the record folder. Complete one of them.");
        this.elRecord = this.createElectronicRecord(recFolder.getId(), RandomData.getRandomName((String)"elRecord"));
        this.nonElRecord = this.createNonElectronicRecord(recFolder.getId(), RandomData.getRandomName((String)"nonElRecord"));
        this.getRestAPIFactory().getRecordsAPI().completeRecord(this.nonElRecord.getId());
        return subCategory;
    }
}

