/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.audit;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.audit.AuditEvents;
import org.alfresco.rest.rm.community.model.user.UserRoles;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.v0.HoldsAPI;
import org.alfresco.rest.v0.service.RMAuditService;
import org.alfresco.rest.v0.service.RoleService;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@AlfrescoTest(jira="RM-6859")
public class AuditDeleteHoldTests
extends BaseRMRestTest {
    private final String PREFIX = CommonTestUtils.generateTestPrefix(AuditDeleteHoldTests.class);
    private final String HOLD = this.PREFIX + "holdToBeDeleted";
    private final String HOLD2 = this.PREFIX + "deleteHold";
    @Autowired
    private RMAuditService rmAuditService;
    @Autowired
    private HoldsAPI holdsAPI;
    @Autowired
    private RoleService roleService;
    private UserModel rmAdmin;
    private UserModel rmManager;
    private String holdNodeRef;

    @BeforeClass(alwaysRun=true)
    public void preconditionForAuditDeleteHoldTests() {
        Step.STEP((String)"Create a new hold.");
        this.holdNodeRef = this.holdsAPI.createHoldAndGetNodeRef(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.HOLD, "Active content to be reviewed for the CASE McDermott, FINRA ", "Generalized hold case for tests");
        Step.STEP((String)"Create 2 users with different permissions for the created hold.");
        this.rmAdmin = this.roleService.createUserWithRMRole(UserRoles.ROLE_RM_ADMIN.roleId);
        this.rmManager = this.roleService.createUserWithRMRole(UserRoles.ROLE_RM_MANAGER.roleId);
    }

    @Test
    public void deleteHoldEventIsAudited() {
        Step.STEP((String)"Create a new hold.");
        String holdRef = this.holdsAPI.createHoldAndGetNodeRef(this.rmAdmin.getUsername(), this.rmAdmin.getPassword(), this.HOLD2, "Active content to be reviewed for the CASE McDermott, FINRA ", "Generalized hold case for tests");
        this.rmAuditService.clearAuditLog();
        Step.STEP((String)"Delete the created hold.");
        this.holdsAPI.deleteHold(this.rmAdmin, holdRef);
        Step.STEP((String)"Check the audit log contains the entry for the deleted hold with the hold details.");
        this.rmAuditService.checkAuditLogForEvent(this.getAdminUser(), AuditEvents.DELETE_HOLD, this.rmAdmin, this.HOLD2, Collections.singletonList(ImmutableMap.of((Object)"new", (Object)"", (Object)"previous", (Object)this.HOLD2, (Object)"name", (Object)"Hold Name")));
    }

    @Test
    public void unsuccessfulDeleteHoldIsNotAudited() {
        this.rmAuditService.clearAuditLog();
        Step.STEP((String)"Try to delete a hold by an user with no Read permissions over the hold.");
        this.holdsAPI.deleteHold(this.rmManager.getUsername(), this.rmManager.getPassword(), this.holdNodeRef, 500);
        Step.STEP((String)"Check the audit log doesn't contain the entry for the unsuccessful delete hold.");
        AssertJUnit.assertTrue((String)"The list of events should not contain Delete Hold entry ", (boolean)this.rmAuditService.getAuditEntriesFilteredByEvent(this.getAdminUser(), AuditEvents.DELETE_HOLD).isEmpty());
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpAuditDeleteHoldTests() {
        this.holdsAPI.deleteHold(this.getAdminUser(), this.holdNodeRef);
        Arrays.asList(this.rmAdmin, this.rmManager).forEach(user -> ((DataUser)this.getDataUser().usingAdmin()).deleteUser(user));
    }
}

