/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.base;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.alfresco.dataprep.ContentService;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestAPIFactory;
import org.alfresco.rest.model.RestNodeModel;
import org.alfresco.rest.rm.community.base.TestData;
import org.alfresco.rest.rm.community.model.fileplan.FilePlan;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.model.recordfolder.RecordFolder;
import org.alfresco.rest.rm.community.model.recordfolder.RecordFolderEntry;
import org.alfresco.rest.rm.community.model.recordfolder.RecordFolderProperties;
import org.alfresco.rest.rm.community.model.site.RMSite;
import org.alfresco.rest.rm.community.model.transfercontainer.TransferContainer;
import org.alfresco.rest.rm.community.model.unfiledcontainer.UnfiledContainer;
import org.alfresco.rest.rm.community.model.unfiledcontainer.UnfiledContainerChild;
import org.alfresco.rest.rm.community.model.unfiledcontainer.UnfiledContainerChildEntry;
import org.alfresco.rest.rm.community.requests.gscore.api.RMSiteAPI;
import org.alfresco.rest.rm.community.requests.gscore.api.RecordCategoryAPI;
import org.alfresco.rest.rm.community.requests.gscore.api.RecordFolderAPI;
import org.alfresco.rest.rm.community.requests.gscore.api.RecordsAPI;
import org.alfresco.rest.rm.community.utils.CoreUtil;
import org.alfresco.rest.rm.community.utils.FilePlanComponentsUtil;
import org.alfresco.rest.rm.community.utils.RMSiteUtil;
import org.alfresco.rest.search.RestRequestQueryModel;
import org.alfresco.rest.search.SearchRequest;
import org.alfresco.rest.v0.SearchAPI;
import org.alfresco.utility.Utility;
import org.alfresco.utility.data.DataUserAIS;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;

public class BaseRMRestTest
extends RestTest {
    @Autowired
    private RestAPIFactory restAPIFactory;
    @Autowired
    protected DataUserAIS dataUser;
    @Autowired
    private ContentService contentService;
    @Autowired
    private SearchAPI searchApi;
    protected static final String iso8601_DateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";

    protected void assertStatusCode(HttpStatus statusCode) {
        this.getRestAPIFactory().getRmRestWrapper().assertStatusCodeIs(statusCode);
    }

    protected UserModel getAdminUser() {
        return this.getDataUser().getAdminUser();
    }

    @DataProvider(name="validRootContainers")
    public Object[][] getValidRootContainers() {
        return new String[][]{{this.createCategoryFolderInFilePlan().getId(), "rma:recordFolder"}, {"-unfiled-", "rma:unfiledRecordContainer"}, {this.createUnfiledContainerChild("-unfiled-", "Unfiled Folder " + RandomData.getRandomAlphanumeric(), "rma:unfiledRecordFolder").getId(), "rma:unfiledRecordFolder"}};
    }

    @BeforeClass(alwaysRun=true)
    public void checkServerHealth() {
        this.createRMSiteIfNotExists();
    }

    public void createRMSiteIfNotExists() {
        RMSiteAPI rmSiteAPI = this.getRestAPIFactory().getRMSiteAPI();
        if (!rmSiteAPI.existsRMSite()) {
            rmSiteAPI.createRMSite(RMSiteUtil.createStandardRMSiteModel());
            this.assertStatusCode(HttpStatus.CREATED);
        }
    }

    public void createRMSite(RMSite rmSiteModel) {
        RMSiteAPI rmSiteAPI = this.getRestAPIFactory().getRMSiteAPI();
        if (rmSiteAPI.existsRMSite()) {
            rmSiteAPI.deleteRMSite();
            this.assertStatusCode(HttpStatus.NO_CONTENT);
        }
        rmSiteAPI.createRMSite(rmSiteModel);
        this.assertStatusCode(HttpStatus.CREATED);
    }

    public RecordCategory createRootCategory(String categoryName) {
        return this.createRootCategory(this.getAdminUser(), categoryName, TestData.RECORD_CATEGORY_TITLE);
    }

    public RecordCategory createRootCategory(UserModel userModel, String categoryName) {
        return this.createRootCategory(userModel, categoryName, TestData.RECORD_CATEGORY_TITLE);
    }

    public RecordCategory createRootCategory(String categoryName, String categoryTitle) {
        return this.createRootCategory(this.getAdminUser(), categoryName, categoryTitle);
    }

    public RecordCategory createRootCategory(UserModel userModel, String categoryName, String categoryTitle) {
        RecordCategory recordCategoryModel = FilePlanComponentsUtil.createRecordCategoryModel(categoryName, categoryTitle);
        return this.getRestAPIFactory().getFilePlansAPI(userModel).createRootRecordCategory(recordCategoryModel, "-filePlan-");
    }

    public RecordCategoryChild createRecordCategoryChild(UserModel user, String recordCategoryId, String name, String type) {
        RecordCategoryChild recordCategoryChildModel = FilePlanComponentsUtil.createRecordCategoryChildModel(name, type);
        return this.getRestAPIFactory().getRecordCategoryAPI(user).createRecordCategoryChild(recordCategoryChildModel, recordCategoryId);
    }

    public RecordCategoryChild createRecordCategoryChild(String recordCategoryId, String name, String type) {
        return this.createRecordCategoryChild(this.getAdminUser(), recordCategoryId, name, type);
    }

    public RecordCategoryChild createRecordCategory(String recordCategoryId, String name) {
        return this.createRecordCategoryChild(this.getAdminUser(), recordCategoryId, name, "rma:recordCategory");
    }

    public RecordCategoryChild createRecordFolder(String recordCategoryId, String name) {
        return this.createRecordCategoryChild(this.getAdminUser(), recordCategoryId, name, "rma:recordFolder");
    }

    public RecordCategoryChild createFolder(UserModel user, String recordCategoryId, String name) {
        RecordCategoryChild recordFolderModel = FilePlanComponentsUtil.createRecordCategoryChildModel(name, "rma:recordFolder");
        return this.getRestAPIFactory().getRecordCategoryAPI(user).createRecordCategoryChild(recordFolderModel, recordCategoryId);
    }

    public RecordCategoryChild createFolder(String recordCategoryId, String name) {
        return this.createFolder(this.getAdminUser(), recordCategoryId, name);
    }

    public UnfiledContainerChild createUnfiledRecordsFolderChild(UserModel user, String parentId, String childName, String nodeType) {
        UnfiledContainerChild childModel = FilePlanComponentsUtil.createUnfiledContainerChildModel(childName, nodeType);
        UnfiledContainerChild child = this.getRestAPIFactory().getUnfiledRecordFoldersAPI(user).createUnfiledRecordFolderChild(childModel, parentId);
        this.assertStatusCode(HttpStatus.CREATED);
        return child;
    }

    public UnfiledContainerChild createUnfiledRecordsFolderChild(String parentId, String childName, String nodeType) {
        return this.createUnfiledRecordsFolderChild(this.getAdminUser(), parentId, childName, nodeType);
    }

    public UnfiledContainerChild createUnfiledContainerChild(UserModel user, String parentId, String childName, String nodeType) {
        UnfiledContainerChild child = null;
        UnfiledContainerChild childModel = FilePlanComponentsUtil.createUnfiledContainerChildModel(childName, nodeType);
        child = "cm:content".equals(nodeType) ? this.getRestAPIFactory().getUnfiledContainersAPI(user).uploadRecord(childModel, parentId, FilePlanComponentsUtil.createTempFile(TestData.ELECTRONIC_RECORD_NAME, TestData.ELECTRONIC_RECORD_NAME)) : this.getRestAPIFactory().getUnfiledContainersAPI(user).createUnfiledContainerChild(childModel, parentId);
        this.assertStatusCode(HttpStatus.CREATED);
        return child;
    }

    public UnfiledContainerChild createUnfiledContainerChild(String parentId, String childName, String nodeType) {
        return this.createUnfiledContainerChild(this.getAdminUser(), parentId, childName, nodeType);
    }

    protected RecordFolder closeFolder(String folderId) {
        RecordFolder recordFolderModel = RecordFolder.builder().properties(RecordFolderProperties.builder().isClosed(Boolean.valueOf(true)).build()).build();
        RecordFolder updateRecordFolder = this.getRestAPIFactory().getRecordFolderAPI().updateRecordFolder(recordFolderModel, folderId);
        this.assertStatusCode(HttpStatus.OK);
        return updateRecordFolder;
    }

    public Record completeRecord(String recordId) {
        RecordsAPI recordsAPI = this.getRestAPIFactory().getRecordsAPI();
        List aspects = recordsAPI.getRecord(recordId).getAspectNames();
        Assert.assertTrue((boolean)aspects.contains("rma:record"));
        Assert.assertFalse((boolean)aspects.contains("rma:declaredRecord"));
        aspects.add("rma:declaredRecord");
        Record updateRecord = recordsAPI.updateRecord(Record.builder().aspectNames(aspects).build(), recordId);
        this.assertStatusCode(HttpStatus.OK);
        return updateRecord;
    }

    public RecordCategoryChild createCategoryFolderInFilePlan(UserModel user) {
        RecordCategory recordCategory = this.createRootCategory(user, "Category " + RandomData.getRandomAlphanumeric());
        return this.createFolder(user, recordCategory.getId(), "Folder " + RandomData.getRandomAlphanumeric());
    }

    public RecordCategoryChild createCategoryFolderInFilePlan() {
        return this.createCategoryFolderInFilePlan(this.getAdminUser());
    }

    public UnfiledContainer getUnfiledContainerAsUser(UserModel user, String componentId) {
        return this.getRestAPIFactory().getUnfiledContainersAPI(user).getUnfiledContainer(componentId);
    }

    public UnfiledContainer getUnfiledContainer(String componentId) {
        return this.getUnfiledContainerAsUser(this.getAdminUser(), componentId);
    }

    public TransferContainer getTransferContainerAsUser(UserModel user, String componentId) {
        return this.getRestAPIFactory().getTransferContainerAPI(user).getTransferContainer(componentId);
    }

    public TransferContainer getTransferContainer(String componentId) {
        return this.getTransferContainerAsUser(this.getAdminUser(), componentId);
    }

    public FilePlan getFilePlanAsUser(UserModel user, String componentId) {
        return this.getRestAPIFactory().getFilePlansAPI(user).getFilePlan(componentId);
    }

    public FilePlan getFilePlan(String componentId) {
        return this.getFilePlanAsUser(this.getAdminUser(), componentId);
    }

    public void deleteFolder(SiteModel siteModel, FolderModel folder) {
        this.contentService.deleteTree(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), siteModel.getId(), folder.getName());
    }

    public Record createElectronicRecord(String parentId, String name) {
        return this.createElectronicRecord(parentId, name, null);
    }

    public Record createElectronicRecord(String parentId, String name, UserModel user) {
        RecordFolderAPI recordFolderAPI = this.restAPIFactory.getRecordFolderAPI(user);
        Record recordModel = Record.builder().name(name).nodeType("cm:content").build();
        return recordFolderAPI.createRecord(recordModel, parentId);
    }

    public Record createNonElectronicRecord(String parentId, String name) {
        return this.createNonElectronicRecord(parentId, name, null);
    }

    public Record createNonElectronicRecord(String parentId, String name, UserModel user) {
        RecordFolderAPI recordFolderAPI = this.restAPIFactory.getRecordFolderAPI(user);
        Record recordModel = Record.builder().name(name).nodeType("rma:nonElectronicDocument").build();
        return recordFolderAPI.createRecord(recordModel, parentId);
    }

    public void deleteRecordFolder(String recordFolderId) {
        RecordFolderAPI recordFolderAPI = this.restAPIFactory.getRecordFolderAPI();
        recordFolderAPI.deleteRecordFolder(recordFolderId);
    }

    public void deleteRecord(String recordId) {
        RecordsAPI recordsAPI = this.restAPIFactory.getRecordsAPI();
        recordsAPI.deleteRecord(recordId);
    }

    public void deleteRecordCategory(String recordCategoryId) {
        RecordCategoryAPI recordCategoryAPI = this.restAPIFactory.getRecordCategoryAPI();
        recordCategoryAPI.deleteRecordCategory(recordCategoryId);
    }

    public List<String> searchForContentAsUser(UserModel user, String term) {
        String query = "cm:name:*" + term + "*";
        return this.searchForContentAsUser(user, query, "afts");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> searchForContentAsUser(UserModel user, String q, String queryLanguage) {
        this.getRestAPIFactory().getRmRestWrapper().authenticateUser(user);
        RestRequestQueryModel queryReq = new RestRequestQueryModel();
        SearchRequest query = new SearchRequest(queryReq);
        queryReq.setQuery(q);
        queryReq.setLanguage(queryLanguage);
        ArrayList<String> names = new ArrayList<String>();
        int counter = 0;
        int waitInMilliSeconds = 7000;
        while (counter < 4) {
            BaseRMRestTest baseRMRestTest = this;
            synchronized (baseRMRestTest) {
                try {
                    ((Object)((Object)this)).wait(waitInMilliSeconds);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            List searchResults = this.getRestAPIFactory().getRmRestWrapper().withSearchAPI().search(query).getEntries();
            if (searchResults != null && !searchResults.isEmpty()) {
                searchResults.forEach(childNode -> names.add(childNode.onModel().getName()));
                break;
            }
            ++counter;
            waitInMilliSeconds *= 2;
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> searchForRMContentAsUser(UserModel user, String term, String sortby, boolean includeFolders, boolean includeCategories, List<String> expectedResults) {
        List<String> results = new ArrayList<String>();
        int counter = 0;
        int waitInMilliSeconds = 7000;
        while (counter < 4) {
            BaseRMRestTest baseRMRestTest = this;
            synchronized (baseRMRestTest) {
                try {
                    ((Object)((Object)this)).wait(waitInMilliSeconds);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            results = this.searchApi.searchForNodeNamesAsUser(user.getUsername(), user.getPassword(), term, sortby, includeFolders, includeCategories);
            if (!results.isEmpty() && results.containsAll(expectedResults)) break;
            ++counter;
            waitInMilliSeconds *= 2;
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String searchForRMContentAsUser(UserModel user, String term, String nodeRef, String propertyName, String sortby, boolean includeFolders, boolean includeCategories, String expectedResults) {
        String result = "";
        int counter = 0;
        int waitInMilliSeconds = 5000;
        while (counter < 4) {
            BaseRMRestTest baseRMRestTest = this;
            synchronized (baseRMRestTest) {
                try {
                    ((Object)((Object)this)).wait(waitInMilliSeconds);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            result = this.searchApi.searchForNodePropertyAsUser(user.getUsername(), user.getPassword(), nodeRef, propertyName, term, sortby, includeFolders, includeCategories);
            if (!result.isEmpty() && result.contains(expectedResults)) break;
            ++counter;
            waitInMilliSeconds *= 2;
        }
        return result;
    }

    public ContentModel getDocumentLibrary(UserModel usermodel, SiteModel testSite) throws Exception {
        ContentModel siteModel = new ContentModel();
        siteModel.setNodeRef(testSite.getGuid());
        this.restClient.authenticateUser(usermodel);
        List nodes = this.restClient.withCoreAPI().usingNode((RepoTestModel)siteModel).listChildren().getEntries().stream().collect(Collectors.toList());
        ContentModel documentLibrary = new ContentModel();
        documentLibrary.setName(((RestNodeModel)nodes.get(0)).onModel().getName());
        documentLibrary.setNodeRef(((RestNodeModel)nodes.get(0)).onModel().getId());
        return documentLibrary;
    }

    protected boolean hasRecordAspect(FileModel testFile) throws Exception {
        return this.hasAspect(testFile, "rma:record");
    }

    private boolean hasAspect(FileModel testFile, String aspectName) throws Exception {
        return this.getRestAPIFactory().getNodeAPI((RepoTestModel)testFile).getNode().getAspectNames().contains(aspectName);
    }

    protected boolean hasAspect(String nodeId, String aspectName) throws Exception {
        return this.hasAspect(CoreUtil.toFileModel(nodeId), aspectName);
    }

    protected boolean isMatchingRecordInUnfiledRecords(FileModel testFile) {
        try {
            Utility.sleep((int)1000, (int)10000, () -> {
                Optional<UnfiledContainerChildEntry> matchingRecord = this.getRestAPIFactory().getUnfiledContainersAPI().getUnfiledContainerChildren("-unfiled-").getEntries().stream().filter(e -> e.getEntry().getId().equals(testFile.getNodeRefWithoutVersion())).findAny();
                Assert.assertTrue((boolean)matchingRecord.isPresent());
            });
            return true;
        }
        catch (AssertionError | Exception e) {
            return false;
        }
    }

    protected boolean isMatchingRecordInRecordFolder(FileModel testFile, RecordCategoryChild recFolder) {
        try {
            Utility.sleep((int)1000, (int)10000, () -> {
                Optional<RecordFolderEntry> matchingRecord = this.getRestAPIFactory().getRecordFolderAPI().getRecordFolderChildren(recFolder.getId()).getEntries().stream().filter(e -> e.getEntry().getId().equals(testFile.getNodeRefWithoutVersion())).findAny();
                Assert.assertTrue((boolean)matchingRecord.isPresent());
            });
            return true;
        }
        catch (AssertionError | Exception e) {
            return false;
        }
    }

    protected boolean isRecordVersionInUnfiledRecords(FileModel testFile, String version) {
        try {
            Utility.sleep((int)1000, (int)10000, () -> {
                UnfiledContainerChildEntry matchingRecord = this.getRestAPIFactory().getUnfiledContainersAPI().getUnfiledContainerChildren("-unfiled-", "include=properties,aspectNames").getEntries().stream().filter(e -> e.getEntry().getName().contains(testFile.getName().replace(".txt", "")) && e.getEntry().getProperties().getVersionedNodeRef().equals(testFile.getNodeRefWithoutVersion()) && e.getEntry().getProperties().getRecordVersionLabel().equalsIgnoreCase(version)).findFirst().get();
                Assert.assertTrue((boolean)this.hasAspect(matchingRecord.getEntry().getId(), "rmv:versionRecord"));
            });
            return true;
        }
        catch (AssertionError | Exception e) {
            return false;
        }
    }

    protected boolean isRecordVersionInRecordFolder(FileModel testFile, RecordCategoryChild recordFolder, String version) {
        try {
            Utility.sleep((int)1000, (int)10000, () -> {
                RecordFolderEntry matchingRecord = this.getRestAPIFactory().getRecordFolderAPI().getRecordFolderChildren(recordFolder.getId(), "include=properties,aspectNames").getEntries().stream().filter(e -> e.getEntry().getName().contains(testFile.getName().replace(".txt", "")) && e.getEntry().getProperties().getVersionedNodeRef().equals(testFile.getNodeRefWithoutVersion()) && e.getEntry().getProperties().getRecordVersionLabel().equalsIgnoreCase(version)).findFirst().get();
                Assert.assertTrue((boolean)this.hasAspect(matchingRecord.getEntry().getId(), "rmv:versionRecord"));
            });
            return true;
        }
        catch (AssertionError | Exception e) {
            return false;
        }
    }

    protected String getIso8601Date(int previousDays) {
        Date date = new Date(System.currentTimeMillis());
        Date previousDate = new Date(date.getTime() - (long)previousDays);
        SimpleDateFormat sdf = new SimpleDateFormat(iso8601_DateFormat);
        sdf.setTimeZone(TimeZone.getDefault());
        return sdf.format(previousDate);
    }

    protected JSONObject editDispositionDateJson() {
        JSONObject requestParams = new JSONObject();
        requestParams.put("name", (Object)"editDispositionActionAsOfDate");
        JSONObject params = new JSONObject();
        requestParams.put("params", (Object)params);
        JSONObject asOfDate = new JSONObject();
        params.put("asOfDate", (Object)asOfDate);
        asOfDate.put("iso8601", (Object)this.getIso8601Date(1));
        return requestParams;
    }

    protected RestAPIFactory getRestAPIFactory() {
        return this.restAPIFactory;
    }

    protected DataUserAIS getDataUser() {
        return this.dataUser;
    }

    protected ContentService getContentService() {
        return this.contentService;
    }

    protected SearchAPI getSearchApi() {
        return this.searchApi;
    }
}

