/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.smoke;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import org.alfresco.rest.model.RestNodeBodyMoveCopyModel;
import org.alfresco.rest.model.RestNodeModel;
import org.alfresco.rest.requests.Node;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.fileplan.FilePlan;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.model.recordcategory.RetentionPeriodProperty;
import org.alfresco.rest.rm.community.model.user.UserRoles;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.v0.LinksAPI;
import org.alfresco.rest.v0.RMRolesAndActionsAPI;
import org.alfresco.rest.v0.RecordFoldersAPI;
import org.alfresco.rest.v0.RecordsAPI;
import org.alfresco.rest.v0.service.DispositionScheduleService;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.UserModel;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DispositionScheduleLinkedRecordsTest
extends BaseRMRestTest {
    @Autowired
    private RMRolesAndActionsAPI rmRolesAndActionsAPI;
    @Autowired
    private DispositionScheduleService dispositionScheduleService;
    @Autowired
    private LinksAPI linksAPI;
    @Autowired
    private RecordsAPI recordsAPI;
    @Autowired
    private RecordFoldersAPI recordFoldersAPI;
    private static final String TEST_PREFIX = CommonTestUtils.generateTestPrefix(DispositionScheduleLinkedRecordsTest.class);
    private RecordCategory Category1;
    private RecordCategoryChild CopyCatFolder;
    private RecordCategoryChild folder1;
    private RecordCategoryChild CatFolder;
    private RecordCategoryChild folder2;
    private static final String categoryRM3077 = TEST_PREFIX + "RM-3077_manager_sees_me";
    private static final String copyCategoryRM3077 = "Copy_of_" + categoryRM3077;
    private static final String folderRM3077 = "RM-3077_folder_" + categoryRM3077;
    private static final String copyFolderRM3077 = "Copy_of_" + folderRM3077;
    private final String folder = TEST_PREFIX + "RM-2937 folder ghosting";
    private static final String firstCategoryRM3060 = TEST_PREFIX + "RM-3060_category_record";
    private static final String secondCategoryRM3060 = "Copy_of_" + firstCategoryRM3060;
    private static final String firstFolderRM3060 = TEST_PREFIX + "RM-3060_folder";
    private static final String secondFolderRM3060 = TEST_PREFIX + "RM-3060_disposition_on_Record_Level";
    private static final String electronicRecordRM3060 = TEST_PREFIX + "RM-3060_electronic_1_record";
    private static final String nonElectronicRecordRM3060 = TEST_PREFIX + "RM-3060_non-electronic_record";
    private static final String firstCategoryRM1622 = TEST_PREFIX + "RM-1622_category_record";
    private static final String secondCategoryRM1622 = "Copy_of_" + firstCategoryRM1622;
    private static final String firstFolderRM1622 = TEST_PREFIX + "RM-1622_folder";
    private static final String electronicRecordRM1622 = TEST_PREFIX + "RM-1622_electronic_1_record";
    private static final String secondFolderRM1622 = TEST_PREFIX + "RM-1622_disposition_on_Record_Level";
    private static final String TRANSFER_LOCATION = TEST_PREFIX + "RM-3060_transferred_records";
    public static final String TRANSFER_TYPE = "rma:transferred";
    private FilePlan filePlanModel;
    private UserModel rmAdmin;
    private UserModel rmManager;

    @BeforeClass(alwaysRun=true)
    public void setupDispositionScheduleLinkedRecordsTest() {
        this.createRMSiteIfNotExists();
        this.filePlanModel = this.getRestAPIFactory().getFilePlansAPI().getFilePlan("-filePlan-");
        this.rmAdmin = this.getDataUser().createRandomTestUser();
        this.rmRolesAndActionsAPI.assignRoleToUser(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), this.rmAdmin.getUsername(), UserRoles.ROLE_RM_ADMIN.roleId);
        this.rmManager = this.getDataUser().createRandomTestUser();
        this.rmRolesAndActionsAPI.assignRoleToUser(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), this.rmManager.getUsername(), UserRoles.ROLE_RM_MANAGER.roleId);
    }

    private String copyCategory(UserModel user, String categoryId, String copyName) {
        RestNodeModel restNodeModel;
        RepoTestModel repoTestModel = new RepoTestModel(){};
        repoTestModel.setNodeRef(categoryId);
        RestNodeBodyMoveCopyModel copyDestinationInfo = new RestNodeBodyMoveCopyModel();
        copyDestinationInfo.setTargetParentId(this.filePlanModel.getId());
        copyDestinationInfo.setName(copyName);
        try {
            restNodeModel = this.getRestAPIFactory().getNodeAPI(user, repoTestModel).copy(copyDestinationInfo);
        }
        catch (Exception e) {
            throw new RuntimeException("Problem copying category.", e);
        }
        return restNodeModel.getId();
    }

    private Node getNode(String recordId) {
        RepoTestModel repoTestModel = new RepoTestModel(){};
        repoTestModel.setNodeRef(recordId);
        return this.getRestAPIFactory().getNodeAPI(repoTestModel);
    }

    private String getTransferId(HttpResponse httpResponse, String nodeRef) {
        HttpEntity entity = httpResponse.getEntity();
        String responseString = null;
        try {
            responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject result = new JSONObject(responseString);
        return result.getJSONObject("results").get(nodeRef).toString();
    }

    @Test
    @AlfrescoTest(jira="RM-1622")
    public void sameLevelDispositionScheduleStepsPeriodsCalculation() throws Exception {
        RecordCategory catsameLevel1 = this.getRestAPIFactory().getFilePlansAPI(this.rmAdmin).createRootRecordCategory(RecordCategory.builder().name(firstCategoryRM1622).build(), "-filePlan-");
        RecordCategory catsameLevel2 = this.getRestAPIFactory().getFilePlansAPI(this.rmAdmin).createRootRecordCategory(RecordCategory.builder().name(secondCategoryRM1622).build(), "-filePlan-");
        this.dispositionScheduleService.createCategoryRetentionSchedule(firstCategoryRM1622, Boolean.valueOf(true));
        this.dispositionScheduleService.addCutOffAfterPeriodStep(firstCategoryRM1622, "day|1", RetentionPeriodProperty.DATE_FILED);
        RecordCategoryChild firstFolderRecordCategoryChild = this.createRecordFolder(catsameLevel1.getId(), firstFolderRM1622);
        Record firstElectronicRecord = this.createElectronicRecord(firstFolderRecordCategoryChild.getId(), electronicRecordRM1622);
        String elRecordFullName = this.recordsAPI.getRecordFullName(this.getDataUser().getAdminUser().getUsername(), this.getDataUser().getAdminUser().getPassword(), firstFolderRM1622, electronicRecordRM1622);
        String elRecordNameNodeRef = this.recordsAPI.getRecordNodeRef(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), elRecordFullName, "/" + firstCategoryRM1622 + "/" + firstFolderRM1622);
        this.recordsAPI.completeRecord(this.getDataUser().getAdminUser().getUsername(), this.getDataUser().getAdminUser().getPassword(), elRecordFullName);
        RecordCategoryChild secondFolderRecordCategoryChild = this.createRecordFolder(catsameLevel2.getId(), secondFolderRM1622);
        String elRecordNameNodeRefs = this.recordsAPI.getRecordNodeRef(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), elRecordFullName, "/" + firstCategoryRM1622 + "/" + firstFolderRM1622);
        ArrayList<CallSite> recordLists = new ArrayList<CallSite>();
        recordLists.add((CallSite)((Object)("workspace://SpacesStore/" + firstElectronicRecord.getId())));
        this.linksAPI.linkRecord(this.getDataUser().getAdminUser().getUsername(), this.getDataUser().getAdminUser().getPassword(), 200, secondCategoryRM1622 + "/" + secondFolderRM1622, recordLists);
        this.recordFoldersAPI.postRecordAction(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.editDispositionDateJson(), elRecordNameNodeRefs);
    }

    @Test(dependsOnMethods={"sameLevelDispositionScheduleStepsPeriodsCalculation"})
    public void deleteLongestPeriodTestPrecondition() {
        this.getRestAPIFactory().getRMSiteAPI().deleteRMSite();
        this.assertStatusCode(HttpStatus.NO_CONTENT);
    }
}

