/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.v0.service;

import java.util.HashSet;
import java.util.Set;
import org.alfresco.rest.core.RestAPIFactory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.user.UserPermissions;
import org.alfresco.rest.rm.community.model.user.UserRoles;
import org.alfresco.rest.v0.RMRolesAndActionsAPI;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataUserAIS;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class RoleService {
    @Autowired
    private RMRolesAndActionsAPI rmRolesAndActionsAPI;
    @Autowired
    private DataUserAIS dataUser;
    @Autowired
    private RestAPIFactory restAPIFactory;

    public Set<String> getRoleCapabilities(String roleName) {
        return this.getRmRolesAndActionsAPI().getCapabilitiesForRole(this.getDataUser().getAdminUser().getUsername(), this.getDataUser().getAdminUser().getPassword(), roleName);
    }

    public void addCapabilitiesToRole(UserRoles role, Set<String> capabilities) {
        HashSet<String> roleCapabilities = new HashSet<String>(this.getRoleCapabilities(role.roleId));
        roleCapabilities.addAll(capabilities);
        this.getRmRolesAndActionsAPI().updateRole(this.getDataUser().getAdminUser().getUsername(), this.getDataUser().getAdminUser().getPassword(), role.roleId, role.displayName, roleCapabilities);
    }

    public void removeCapabilitiesFromRole(UserRoles role, Set<String> capabilities) {
        Set<String> roleCapabilities = this.getRoleCapabilities(role.roleId);
        roleCapabilities.removeAll(capabilities);
        this.getRmRolesAndActionsAPI().updateRole(this.getDataUser().getAdminUser().getUsername(), this.getDataUser().getAdminUser().getPassword(), role.roleId, role.displayName, roleCapabilities);
    }

    public void assignUserPermissionsOnCategoryAndRMRole(UserModel user, String categoryId, UserPermissions userPermission, String userRole) {
        this.getRestAPIFactory().getRMUserAPI().addUserPermission(categoryId, user, userPermission);
        this.getRmRolesAndActionsAPI().assignRoleToUser(this.getDataUser().getAdminUser().getUsername(), this.getDataUser().getAdminUser().getPassword(), user.getUsername(), userRole);
    }

    public UserModel createUserWithRMRole(String userRole) {
        UserModel rmUser = this.getDataUser().createRandomTestUser();
        this.getRestAPIFactory().getRMUserAPI().assignRoleToUser(rmUser.getUsername(), userRole);
        this.getRestAPIFactory().getRmRestWrapper().assertStatusCodeIs(HttpStatus.OK);
        return rmUser;
    }

    public UserModel createUserWithRMRoleAndCategoryPermission(String userRole, RecordCategory recordCategory, UserPermissions userPermission) {
        return this.createUserWithRMRoleAndRMNodePermission(userRole, recordCategory.getId(), userPermission);
    }

    public UserModel createUserWithRMRoleAndRMNodePermission(String userRole, String componentId, UserPermissions userPermission) {
        UserModel rmUser = this.createUserWithRMRole(userRole);
        this.getRestAPIFactory().getRMUserAPI().addUserPermission(componentId, rmUser, userPermission);
        this.getRestAPIFactory().getRmRestWrapper().assertStatusCodeIs(HttpStatus.OK);
        return rmUser;
    }

    public UserModel createCollaboratorWithRMRoleAndPermission(SiteModel siteModel, RecordCategory recordCategory, UserRoles userRole, UserPermissions userPermission) {
        return this.createUserWithSiteRoleRMRoleAndPermission(siteModel, UserRole.SiteCollaborator, recordCategory.getId(), userRole, userPermission);
    }

    public UserModel createUserWithSiteRoleRMRoleAndPermission(SiteModel siteModel, UserRole userSiteRole, String rmNodeId, UserRoles userRole, UserPermissions userPermission) {
        UserModel rmUser = this.createUserWithRMRoleAndRMNodePermission(userRole.roleId, rmNodeId, userPermission);
        this.getDataUser().addUserToSite(rmUser, siteModel, userSiteRole);
        return rmUser;
    }

    protected RMRolesAndActionsAPI getRmRolesAndActionsAPI() {
        return this.rmRolesAndActionsAPI;
    }

    protected DataUserAIS getDataUser() {
        return this.dataUser;
    }

    protected RestAPIFactory getRestAPIFactory() {
        return this.restAPIFactory;
    }
}

