/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.rules;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.model.rules.ActionsOnRule;
import org.alfresco.rest.rm.community.model.rules.RuleDefinition;
import org.alfresco.rest.rm.community.model.user.UserPermissions;
import org.alfresco.rest.rm.community.model.user.UserRoles;
import org.alfresco.rest.rm.community.requests.gscore.api.UnfiledContainerAPI;
import org.alfresco.rest.rm.community.smoke.FileAsRecordTests;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.v0.RulesAPI;
import org.alfresco.rest.v0.service.RoleService;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class FileVersionAsRecordRuleTest
extends BaseRMRestTest {
    private UserModel nonRMuser;
    private UserModel rmManager;
    private RecordCategory category_manager;
    private RecordCategory category_admin;
    private RecordCategoryChild folder_admin;
    private RecordCategoryChild folder_manager;
    private static final String CATEGORY_MANAGER = "catManager" + CommonTestUtils.generateTestPrefix(FileAsRecordTests.class);
    private static final String CATEGORY_ADMIN = "catAdmin" + CommonTestUtils.generateTestPrefix(FileAsRecordTests.class);
    private static final String FOLDER_MANAGER = "recordFolder" + CommonTestUtils.generateTestPrefix(FileAsRecordTests.class);
    private static final String FOLDER_ADMIN = "recordFolder" + CommonTestUtils.generateTestPrefix(FileAsRecordTests.class);
    private FolderModel testFolder;
    private FileModel document;
    private FileModel inPlaceRecord;
    @Autowired
    private RoleService roleService;
    @Autowired
    private RulesAPI rulesAPI;

    @BeforeClass(alwaysRun=true)
    public void createTestPrecondition() {
        Step.STEP((String)"Create the RM site if doesn't exist");
        this.createRMSiteIfNotExists();
        Step.STEP((String)"Create a user");
        this.nonRMuser = this.dataUser.createRandomTestUser("testUser");
        Step.STEP((String)"Create a collaboration site");
        this.testSite = ((DataSite)this.dataSite.usingUser(this.nonRMuser)).createPublicRandomSite();
        Step.STEP((String)"Create a document with the user without RM role");
        this.document = ((DataContent)this.dataContent.usingSite(this.testSite)).usingUser(this.nonRMuser).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Step.STEP((String)"Create two categories with two folders");
        this.category_manager = this.createRootCategory(CATEGORY_MANAGER);
        this.category_admin = this.createRootCategory(CATEGORY_ADMIN);
        this.folder_admin = this.createFolder(this.category_admin.getId(), FOLDER_ADMIN);
        this.folder_manager = this.createFolder(this.category_manager.getId(), FOLDER_MANAGER);
        Step.STEP((String)"Create an rm user and give filling permission over CATEGORY_MANAGER record category");
        new RecordCategory();
        RecordCategory recordCategory = RecordCategory.builder().id(this.category_manager.getId()).build();
        this.rmManager = this.roleService.createCollaboratorWithRMRoleAndPermission(this.testSite, recordCategory, UserRoles.ROLE_RM_MANAGER, UserPermissions.PERMISSION_FILING);
        Step.STEP((String)"Create a collaboration folder with a rule set to declare and file version as record to a record folder");
        RecordCategoryChild folderWithRule = this.createFolder(recordCategory.getId(), RandomData.getRandomName((String)"recordFolder"));
        RuleDefinition ruleDefinition = RuleDefinition.createNewRule().title("name").description("description").applyToChildren(true).actions(Collections.singletonList(ActionsOnRule.DECLARE_AS_RECORD.getActionValue()));
        this.rulesAPI.createRule(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), "workspace/SpacesStore/" + folderWithRule.getId(), ruleDefinition);
        this.assertStatusCode(HttpStatus.CREATED);
    }

    @Test
    public void declareVersionAsRecordRuleAsRMUserWithFilingPermissions() {
        Step.STEP((String)"Create a collaboration folder");
        this.testFolder = ((DataContent)this.dataContent.usingSite(this.testSite)).usingUser(this.rmManager).createFolder();
        Step.STEP((String)"Create a rule with Declare as Record action and check that user can select a record folder.");
        new RecordCategory();
        RecordCategory recordCategory = RecordCategory.builder().id(this.category_manager.getId()).build();
        RecordCategoryChild folderWithRule = this.createFolder(recordCategory.getId(), RandomData.getRandomName((String)"recordFolder"));
        RuleDefinition ruleDefinition = RuleDefinition.createNewRule().title("name").description("description").applyToChildren(true).actions(Collections.singletonList(ActionsOnRule.DECLARE_AS_RECORD.getActionValue()));
        this.rulesAPI.createRule(this.rmManager.getUsername(), this.rmManager.getPassword(), "workspace/SpacesStore/" + this.testFolder.getNodeRef(), ruleDefinition);
        this.assertStatusCode(HttpStatus.CREATED);
    }

    @Test
    public void declareVersionAsRecordRuleAsNonRMUser() {
        Step.STEP((String)"Create a collaboration folder");
        this.testFolder = ((DataContent)this.dataContent.usingSite(this.testSite)).usingUser(this.nonRMuser).createFolder();
        Step.STEP((String)"Create a rule with Declare as Record action and check that user can select a record folder.");
        new RecordCategory();
        RecordCategory recordCategory = RecordCategory.builder().id(this.category_manager.getId()).build();
        RuleDefinition ruleDefinition = RuleDefinition.createNewRule().title("name").description("description").applyToChildren(true).actions(Collections.singletonList(ActionsOnRule.DECLARE_AS_RECORD.getActionValue()));
        this.rulesAPI.createRule(this.nonRMuser.getUsername(), this.nonRMuser.getPassword(), "workspace/SpacesStore/" + this.testFolder.getNodeRef(), ruleDefinition);
        this.assertStatusCode(HttpStatus.CREATED);
    }

    @Test
    public void triggerDeclareToUnfiledRuleAsNonRMUser() throws Exception {
        Step.STEP((String)"Create a collaboration folder with a rule set to declare and file as record without a record folder location");
        FileModel inplaceRecord = ((DataContent)this.dataContent.usingSite(this.testSite)).usingUser(this.nonRMuser).createContent(new FileModel("declareAndFileToIntoUnfiledRecordFolder", FileType.TEXT_PLAIN));
        new RecordCategory();
        RecordCategory recordCategory = RecordCategory.builder().id(this.category_manager.getId()).build();
        RuleDefinition ruleDefinition = RuleDefinition.createNewRule().title("name").description("description").applyToChildren(true).actions(Collections.singletonList(ActionsOnRule.DECLARE_AS_RECORD.getActionValue()));
        this.rulesAPI.createRule(this.nonRMuser.getUsername(), this.nonRMuser.getPassword(), "workspace/SpacesStore/" + inplaceRecord.getNodeRef(), ruleDefinition);
        this.assertStatusCode(HttpStatus.CREATED);
        Step.STEP((String)"Create as nonRMuser a new file into the previous folder in order to trigger the rule");
        this.inPlaceRecord = ((DataContent)this.dataContent.usingUser(this.nonRMuser).usingResource((ContentModel)this.testFolder)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        UnfiledContainerAPI unfiledContainersAPI = this.getRestAPIFactory().getUnfiledContainersAPI();
        List matchingRecords = unfiledContainersAPI.getUnfiledContainerChildren("-unfiled-").getEntries().stream().filter(e -> e.getEntry().getId().equals(inplaceRecord.getNodeRefWithoutVersion())).collect(Collectors.toList());
    }

    @AfterClass(alwaysRun=true)
    public void cleanupDeclareVersionAsRecordRuleTests() {
        Step.STEP((String)"Delete the collaboration site");
        ((DataSite)this.dataSite.usingUser(this.nonRMuser)).deleteSite(this.testSite);
        Step.STEP((String)"Delete Users");
        this.dataUser.deleteUser(this.nonRMuser);
        this.dataUser.deleteUser(this.rmManager);
        Step.STEP((String)"Delete categories");
        this.getRestAPIFactory().getFilePlansAPI().getRootRecordCategories("-filePlan-").getEntries().forEach(recordCategoryEntry -> this.deleteRecordCategory(recordCategoryEntry.getEntry().getId()));
    }
}

