/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.audit;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.rm.community.audit.AuditAddToHoldTests;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.audit.AuditEntry;
import org.alfresco.rest.rm.community.model.audit.AuditEvents;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.model.recordfolder.RecordFolder;
import org.alfresco.rest.rm.community.model.user.UserRoles;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.v0.HoldsAPI;
import org.alfresco.rest.v0.service.RMAuditService;
import org.alfresco.rest.v0.service.RoleService;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNot;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class AuditHoldsTest
extends BaseRMRestTest {
    private final String PREFIX = CommonTestUtils.generateTestPrefix(AuditAddToHoldTests.class);
    private final String HOLD1 = this.PREFIX + "hold1";
    private SiteModel publicSite;
    private FileModel testFile;
    @Autowired
    private RMAuditService rmAuditService;
    @Autowired
    private HoldsAPI holdsAPI;
    @Autowired
    private RoleService roleService;
    private UserModel rmAdmin;
    private RecordCategory recordCategory;
    private RecordCategoryChild recordFolder1;
    private RecordCategoryChild recordFolder2;
    private List<AuditEntry> auditEntries;
    private String hold1NodeRef;
    public static final String RECORD_FOLDER_THREE = "record-folder-three";

    @BeforeClass(alwaysRun=true)
    public void preconditionForAuditAddToHoldTests() {
        this.createRMSiteIfNotExists();
        this.rmAdmin = this.roleService.createUserWithRMRole(UserRoles.ROLE_RM_ADMIN.roleId);
        Step.STEP((String)"Create a hold");
        this.hold1NodeRef = this.holdsAPI.createHoldAndGetNodeRef(this.rmAdmin.getUsername(), this.rmAdmin.getPassword(), this.HOLD1, "Active content to be reviewed for the CASE McDermott, FINRA ", "Generalized hold case for tests");
        Step.STEP((String)"Create a collaboration site with a test file.");
        this.publicSite = ((DataSite)this.dataSite.usingAdmin()).createPublicRandomSite();
        this.testFile = ((DataContent)this.dataContent.usingAdmin().usingSite(this.publicSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Step.STEP((String)"Create a record category with 2 folders and 1 record");
        this.recordCategory = this.createRootCategory(RandomData.getRandomName((String)"recordCategory"));
        this.recordFolder1 = this.createRecordFolder(this.recordCategory.getId(), this.PREFIX + "recFolder1");
        this.recordFolder2 = this.createRecordFolder(this.recordCategory.getId(), this.PREFIX + "recFolder2");
        Record recordToBeAdded = this.createElectronicRecord(this.recordFolder1.getId(), this.PREFIX + "record");
        this.assertStatusCode(HttpStatus.CREATED);
        Step.STEP((String)"Add some items to the hold, then remove them from the hold");
        List<String> itemsList = Arrays.asList(this.testFile.getNodeRefWithoutVersion(), recordToBeAdded.getId(), this.recordFolder2.getId());
        List<String> holdsList = Collections.singletonList(this.HOLD1);
        this.holdsAPI.addItemToHold(this.rmAdmin.getUsername(), this.rmAdmin.getPassword(), recordToBeAdded.getId(), this.HOLD1);
        this.holdsAPI.removeItemsFromHolds(this.rmAdmin.getUsername(), this.rmAdmin.getPassword(), itemsList, holdsList);
        Step.STEP((String)"Delete the record folder that was held");
        this.getRestAPIFactory().getRecordFolderAPI().deleteRecordFolder(this.recordFolder2.getId());
        Step.STEP((String)"Rename the parent of the record that was held");
        RecordFolder recordFolder = RecordFolder.builder().name(RECORD_FOLDER_THREE).build();
        this.getRestAPIFactory().getRecordFolderAPI().updateRecordFolder(recordFolder, this.recordFolder1.getId());
    }

    @DataProvider(name="holdsEvents")
    public Object[][] getHoldEvents() {
        return new AuditEvents[][]{{AuditEvents.ADD_TO_HOLD}, {AuditEvents.REMOVE_FROM_HOLD}};
    }

    @Test(dataProvider="holdsEvents")
    public void checkItemPathLink(AuditEvents event) {
        this.auditEntries = this.rmAuditService.getAuditEntriesFilteredByEvent(this.getAdminUser(), event);
        AssertJUnit.assertFalse((String)"Audit results should not be empty", (this.auditEntries.size() == 0 ? 1 : 0) != 0);
        String auditedEvent = String.valueOf(event) + " - " + this.testFile.getName();
        AssertJUnit.assertTrue((String)("Audit results should contain one " + auditedEvent + " event"), (boolean)this.auditEntries.stream().anyMatch(e -> e.getEvent().startsWith(event.eventDisplayName)));
        Step.STEP((String)"Check the audit log contains only an entry for add to hold.");
        MatcherAssert.assertThat(this.auditEntries, (Matcher)CoreMatchers.is((Matcher)IsNot.not((Matcher)Matchers.empty())));
    }

    @AfterClass(alwaysRun=true)
    private void cleanup() {
        ((DataSite)this.dataSite.usingAdmin()).deleteSite(this.publicSite);
        this.deleteRecordFolder(this.recordFolder1.getId());
        this.deleteRecordFolder(this.recordFolder2.getId());
        this.deleteRecordCategory(this.recordCategory.getId());
        this.rmAuditService.clearAuditLog();
    }
}

