/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.records;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.core.v0.BaseAPI;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.base.TestData;
import org.alfresco.rest.rm.community.model.record.RecordContent;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.model.unfiledcontainer.UnfiledContainerChild;
import org.alfresco.rest.rm.community.model.user.UserPermissions;
import org.alfresco.rest.rm.community.requests.gscore.api.UnfiledContainerAPI;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.rm.community.utils.FilePlanComponentsUtil;
import org.alfresco.rest.v0.RMRolesAndActionsAPI;
import org.alfresco.rest.v0.RecordsAPI;
import org.alfresco.rest.v0.SearchAPI;
import org.alfresco.utility.Utility;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.apache.http.HttpResponse;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Assert;
import org.springframework.beans.factory.annotation.Autowired;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class SearchRecordsTests
extends BaseRMRestTest {
    private Optional<UserModel> nonRmSiteUser;
    private Optional<UserModel> rm_user_search;
    private Optional<UserModel> rm_manager;
    private Optional<UserModel> rm_admin_search;
    public static final String ROLE_RM_MANAGER = "RecordsManager";
    private final String TEST_PREFIX = CommonTestUtils.generateTestPrefix(SearchRecordsTests.class);
    private final String CATEGORY_ALL = this.TEST_PREFIX + "everybody's category";
    private final String FOLDER_SEARCH = this.TEST_PREFIX + "basic search folder";
    private final String FOLDER_ADMIN_ONLY = this.TEST_PREFIX + "rm admin category";
    private final String CATEGORY_ADMIN_ONLY = this.TEST_PREFIX + "rm admin category";
    public static final String ROLE_RM_USER = "User";
    public static final String ADMIN = "Administrator";
    private final String ELECTRONIC_RECORD = this.TEST_PREFIX + " Electronic";
    private final String UNFILED_ELECTRONIC_RECORD = this.TEST_PREFIX + " Unfiled Electronic";
    private final String NON_ELECTRONIC_RECORD = this.TEST_PREFIX + " Non-Electronic";
    private final String ADMIN_ELECTRONIC_RECORD = this.TEST_PREFIX + " admin Electronic";
    public static final String TITLE = "Title";
    public static final String DESCRIPTION = "Description";
    public static final String TEST_CONTENT = "This is some test content";
    private RecordCategory categoryAll;
    private RecordCategory category_Admin_Only;
    @Autowired
    private RMRolesAndActionsAPI rmRolesAndActionsAPI;
    @Autowired
    private SearchAPI searchAPI;
    @Autowired
    private RecordsAPI recordsAPI;

    @BeforeClass(alwaysRun=true)
    public void createRecordsForSearch() {
        this.createRMSiteIfNotExists();
        this.nonRmSiteUser = Optional.ofNullable(this.getDataUser().createRandomTestUser());
        this.createRMManager();
        this.createRMUser();
        this.createRMAdmin();
        this.categoryAll = this.createCategoryIfDoesNotExist(this.CATEGORY_ALL);
        this.createRecordFolderInCategory(this.FOLDER_SEARCH, this.categoryAll);
        this.category_Admin_Only = this.createCategoryIfDoesNotExist(this.CATEGORY_ADMIN_ONLY);
        this.createRecordFolderInCategory(this.FOLDER_ADMIN_ONLY, this.category_Admin_Only);
        this.uploadElectronicRecordInContainer(this.ELECTRONIC_RECORD, this.FOLDER_SEARCH);
        this.createNonElectronicRecordInContainer(this.NON_ELECTRONIC_RECORD, this.CATEGORY_ALL, this.FOLDER_SEARCH);
        this.uploadElectronicRecordInContainer(this.ADMIN_ELECTRONIC_RECORD, this.FOLDER_ADMIN_ONLY);
        UnfiledContainerChild electronicRecord = UnfiledContainerChild.builder().name(this.UNFILED_ELECTRONIC_RECORD).nodeType("cm:content").content(RecordContent.builder().mimeType("text/plain").build()).build();
        this.getRecordsFromUnfiledRecordsContainer(electronicRecord);
    }

    @Test(priority=1)
    public void searchResultsWithRecordCategoryIdentifier() {
        AtomicBoolean electronicRecordFound = new AtomicBoolean(false);
        AtomicReference items = new AtomicReference();
        AtomicBoolean recordCategoryIdentifier = new AtomicBoolean(false);
        Step.STEP((String)"Open the record search page and search by the items created");
        try {
            Utility.sleep((int)1000, (int)40000, () -> {
                JSONObject searchResult = this.searchAPI.rmSearch(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), "rm", "keywords:" + this.TEST_PREFIX + "*", "records/true,undeclared/true,vital/false,folders/false,categories/false,frozen/false,cutoff/false", "rma:identifier/asc");
                items.set((JSONArray)searchResult.get("items"));
                Assert.assertFalse((String)"Site Consumer not able to find the document.", (boolean)((JSONArray)searchResult.get("items")).isEmpty());
            });
        }
        catch (InterruptedException e) {
            Assert.fail((String)"InterruptedException received while waiting for results.");
        }
        Step.STEP((String)"Check that the records from file plan have the record category identifier displayed");
        List searchList = IntStream.range(0, ((JSONArray)items.get()).length()).mapToObj(i -> ((JSONArray)items.get()).get(i)).collect(Collectors.toList());
        searchList.stream().forEach(x -> {
            Map<String, String> reconstructedUtilMap = Arrays.stream(x.toString().split(",")).map(s -> s.split(":")).collect(Collectors.toMap(s -> s[0], s -> s[1]));
            if (reconstructedUtilMap.get("\"name\"").contains(this.TEST_PREFIX + " Electronic")) {
                electronicRecordFound.set(true);
            }
        });
        Assert.assertFalse((String)("The File Name with the Prefix " + this.TEST_PREFIX + " as Electronic Record was not found."), (!electronicRecordFound.get() ? 1 : 0) != 0);
        Step.STEP((String)"Change the search filter to return only record folders and record categories");
        try {
            Utility.sleep((int)1000, (int)40000, () -> {
                JSONObject searchResult = this.searchAPI.rmSearch(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), "rm", "keywords:" + this.TEST_PREFIX + "*", "records/false,undeclared/true,vital/false,folders/true,categories/true,frozen/false,cutoff/false", "rma:identifier/asc");
                items.set((JSONArray)searchResult.get("items"));
                Assert.assertFalse((String)"Site Consumer not able to find the document.", (boolean)((JSONArray)searchResult.get("items")).isEmpty());
            });
        }
        catch (InterruptedException e) {
            Assert.fail((String)"InterruptedException received while waiting for results.");
        }
        Step.STEP((String)"Check that the records folders and categories don't have a record category identifier displayed");
        List recordFolderSearchList = IntStream.range(0, ((JSONArray)items.get()).length()).mapToObj(i -> ((JSONArray)items.get()).get(i)).collect(Collectors.toList());
        recordFolderSearchList.stream().forEach(x -> {
            Map<String, String> reconstructedUtilMap = Arrays.stream(x.toString().split(",")).map(s -> s.split(":")).collect(Collectors.toMap(s -> s[0], s -> s[1]));
            if (null != reconstructedUtilMap.get("\"rma_recordCategoryIdentifier\"")) {
                recordCategoryIdentifier.set(true);
            }
        });
        Assert.assertFalse((String)("Record Category Identifier displayed for " + this.TEST_PREFIX + "."), (boolean)recordCategoryIdentifier.get());
    }

    @Test(priority=2)
    public void nonRMUserSearchResults() {
        try {
            Utility.sleep((int)1000, (int)40000, () -> {
                List stringList = this.searchAPI.searchForDocumentsAsUser(this.nonRmSiteUser.get().getUsername(), this.nonRmSiteUser.get().getPassword(), this.ELECTRONIC_RECORD);
                Assert.assertFalse((String)("The file with search term " + this.ELECTRONIC_RECORD + " was found using RM Not Site User " + this.nonRmSiteUser.get().getUsername()), (boolean)this.getResult(this.ELECTRONIC_RECORD, stringList));
            });
        }
        catch (InterruptedException e) {
            Assert.fail((String)"InterruptedException received while waiting for results.");
        }
        try {
            Utility.sleep((int)1000, (int)40000, () -> {
                List stringList = this.searchAPI.searchForDocumentsAsUser(this.nonRmSiteUser.get().getUsername(), this.nonRmSiteUser.get().getPassword(), this.UNFILED_ELECTRONIC_RECORD);
                Assert.assertFalse((String)("The file with search term " + this.UNFILED_ELECTRONIC_RECORD + " was not found using RM Not Site User " + this.nonRmSiteUser.get().getUsername()), (boolean)this.getResult(this.UNFILED_ELECTRONIC_RECORD, stringList));
            });
        }
        catch (InterruptedException e) {
            Assert.fail((String)"InterruptedException received while waiting for results.");
        }
        try {
            Utility.sleep((int)1000, (int)40000, () -> {
                List stringList = this.searchAPI.searchForDocumentsAsUser(this.nonRmSiteUser.get().getUsername(), this.nonRmSiteUser.get().getPassword(), this.NON_ELECTRONIC_RECORD);
                Assert.assertFalse((String)("The file with search term " + this.NON_ELECTRONIC_RECORD + " was not found using RM Not Site User " + this.nonRmSiteUser.get().getUsername()), (boolean)this.getResult(this.NON_ELECTRONIC_RECORD, stringList));
            });
        }
        catch (InterruptedException e) {
            Assert.fail((String)"InterruptedException received while waiting for results.");
        }
        try {
            Utility.sleep((int)1000, (int)40000, () -> {
                List stringList = this.searchAPI.searchForDocumentsAsUser(this.nonRmSiteUser.get().getUsername(), this.nonRmSiteUser.get().getPassword(), this.ADMIN_ELECTRONIC_RECORD);
                Assert.assertFalse((String)("The file with search term " + this.ADMIN_ELECTRONIC_RECORD + " was not found using RM Not Site User " + this.nonRmSiteUser.get().getUsername()), (boolean)this.getResult(this.ADMIN_ELECTRONIC_RECORD, stringList));
            });
        }
        catch (InterruptedException e) {
            Assert.fail((String)"InterruptedException received while waiting for results.");
        }
    }

    @Test(priority=3)
    public void rmUserSearchResults() {
        this.getRestAPIFactory().getRMUserAPI().addUserPermission(this.categoryAll.getId(), this.rm_user_search.get(), UserPermissions.PERMISSION_READ_RECORDS);
        this.getRestAPIFactory().getRMUserAPI().addUserPermission(this.categoryAll.getId(), this.rm_user_search.get(), UserPermissions.PERMISSION_FILE_RECORDS);
        try {
            Utility.sleep((int)1000, (int)40000, () -> {
                List stringList = this.searchAPI.searchForDocumentsAsUser(this.rm_user_search.get().getUsername(), this.rm_user_search.get().getPassword(), this.ELECTRONIC_RECORD);
                org.testng.Assert.assertTrue((boolean)this.getResult(this.ELECTRONIC_RECORD, stringList), (String)("The file with search term" + this.ELECTRONIC_RECORD + " was not found using RM User " + this.rm_user_search.get().getUsername()));
            });
        }
        catch (InterruptedException e) {
            Assert.fail((String)"InterruptedException received while waiting for results.");
        }
        try {
            Utility.sleep((int)1000, (int)40000, () -> {
                List stringList = this.searchAPI.searchForDocumentsAsUser(this.rm_user_search.get().getUsername(), this.rm_user_search.get().getPassword(), this.UNFILED_ELECTRONIC_RECORD);
                org.testng.Assert.assertTrue((boolean)this.getResult(this.UNFILED_ELECTRONIC_RECORD, stringList), (String)("The file with search term" + this.UNFILED_ELECTRONIC_RECORD + " was not found using RM User " + this.rm_user_search.get().getUsername()));
            });
        }
        catch (InterruptedException e) {
            Assert.fail((String)"InterruptedException received while waiting for results.");
        }
        try {
            Utility.sleep((int)1000, (int)40000, () -> {
                List stringList = this.searchAPI.searchForDocumentsAsUser(this.rm_user_search.get().getUsername(), this.rm_user_search.get().getPassword(), this.NON_ELECTRONIC_RECORD);
                org.testng.Assert.assertTrue((boolean)this.getResult(this.NON_ELECTRONIC_RECORD, stringList), (String)("The file with search term" + this.NON_ELECTRONIC_RECORD + " was not found using RM User " + this.rm_user_search.get().getUsername()));
            });
        }
        catch (InterruptedException e) {
            Assert.fail((String)"InterruptedException received while waiting for results.");
        }
        try {
            Utility.sleep((int)1000, (int)40000, () -> {
                List stringList = this.searchAPI.searchForDocumentsAsUser(this.rm_user_search.get().getUsername(), this.rm_user_search.get().getPassword(), this.ADMIN_ELECTRONIC_RECORD);
                Assert.assertFalse((String)("The file with search term" + this.ADMIN_ELECTRONIC_RECORD + " was not found using RM User " + this.rm_user_search.get().getUsername()), (boolean)this.getResult(this.ADMIN_ELECTRONIC_RECORD, stringList));
            });
        }
        catch (InterruptedException e) {
            Assert.fail((String)"InterruptedException received while waiting for results.");
        }
    }

    @Test(priority=4)
    public void rmManagerSearchResults() {
        this.getRestAPIFactory().getRMUserAPI().addUserPermission(this.categoryAll.getId(), this.rm_manager.get(), UserPermissions.PERMISSION_READ_RECORDS);
        try {
            Utility.sleep((int)1000, (int)40000, () -> {
                List stringList = this.searchAPI.searchForDocumentsAsUser(this.rm_manager.get().getUsername(), this.rm_manager.get().getPassword(), this.ELECTRONIC_RECORD);
                org.testng.Assert.assertTrue((boolean)this.getResult(this.ELECTRONIC_RECORD, stringList), (String)("The file with search term " + this.ELECTRONIC_RECORD + " was not found using RM manager User " + this.rm_manager.get().getUsername()));
            });
        }
        catch (InterruptedException e) {
            Assert.fail((String)"InterruptedException received while waiting for results.");
        }
        try {
            Utility.sleep((int)1000, (int)40000, () -> {
                List stringList = this.searchAPI.searchForDocumentsAsUser(this.rm_manager.get().getUsername(), this.rm_manager.get().getPassword(), this.UNFILED_ELECTRONIC_RECORD);
                org.testng.Assert.assertTrue((boolean)this.getResult(this.UNFILED_ELECTRONIC_RECORD, stringList), (String)("The file with search term " + this.UNFILED_ELECTRONIC_RECORD + " was not found using RM manager User " + this.rm_manager.get().getUsername()));
            });
        }
        catch (InterruptedException e) {
            Assert.fail((String)"InterruptedException received while waiting for results.");
        }
        try {
            Utility.sleep((int)1000, (int)40000, () -> {
                List stringList = this.searchAPI.searchForDocumentsAsUser(this.rm_manager.get().getUsername(), this.rm_manager.get().getPassword(), this.NON_ELECTRONIC_RECORD);
                org.testng.Assert.assertTrue((boolean)this.getResult(this.NON_ELECTRONIC_RECORD, stringList), (String)("The file with search term " + this.NON_ELECTRONIC_RECORD + " was not found using RM manager User " + this.rm_manager.get().getUsername()));
            });
        }
        catch (InterruptedException e) {
            Assert.fail((String)"InterruptedException received while waiting for results.");
        }
        try {
            Utility.sleep((int)1000, (int)40000, () -> {
                List stringList = this.searchAPI.searchForDocumentsAsUser(this.rm_manager.get().getUsername(), this.rm_manager.get().getPassword(), this.ADMIN_ELECTRONIC_RECORD);
                Assert.assertFalse((String)("The file with search term" + this.ADMIN_ELECTRONIC_RECORD + " was found using RM manager User " + this.rm_manager.get().getUsername()), (boolean)this.getResult(this.ADMIN_ELECTRONIC_RECORD, stringList));
            });
        }
        catch (InterruptedException e) {
            Assert.fail((String)"InterruptedException received while waiting for results.");
        }
    }

    @Test(priority=5)
    public void rmAdminSearchResults() {
        try {
            Utility.sleep((int)1000, (int)40000, () -> {
                List stringList = this.searchAPI.searchForDocumentsAsUser(this.rm_admin_search.get().getUsername(), this.rm_admin_search.get().getPassword(), this.ELECTRONIC_RECORD);
                org.testng.Assert.assertTrue((boolean)this.getResult(this.ELECTRONIC_RECORD, stringList), (String)("The file with search term " + this.ELECTRONIC_RECORD + " was not found using RM Admin User " + this.rm_admin_search.get().getUsername()));
            });
        }
        catch (InterruptedException e) {
            Assert.fail((String)"InterruptedException received while waiting for results.");
        }
        try {
            Utility.sleep((int)1000, (int)40000, () -> {
                List stringList = this.searchAPI.searchForDocumentsAsUser(this.rm_admin_search.get().getUsername(), this.rm_admin_search.get().getPassword(), this.UNFILED_ELECTRONIC_RECORD);
                org.testng.Assert.assertTrue((boolean)this.getResult(this.UNFILED_ELECTRONIC_RECORD, stringList), (String)("The file with search term " + this.UNFILED_ELECTRONIC_RECORD + " was not found using RM Admin User " + this.rm_admin_search.get().getUsername()));
            });
        }
        catch (InterruptedException e) {
            Assert.fail((String)"InterruptedException received while waiting for results.");
        }
        try {
            Utility.sleep((int)1000, (int)40000, () -> {
                List stringList = this.searchAPI.searchForDocumentsAsUser(this.rm_admin_search.get().getUsername(), this.rm_admin_search.get().getPassword(), this.NON_ELECTRONIC_RECORD);
                org.testng.Assert.assertTrue((boolean)this.getResult(this.NON_ELECTRONIC_RECORD, stringList), (String)("The file with search term " + this.NON_ELECTRONIC_RECORD + " was not found using RM Admin User " + this.rm_admin_search.get().getUsername()));
            });
        }
        catch (InterruptedException e) {
            Assert.fail((String)"InterruptedException received while waiting for results.");
        }
    }

    private void createRMManager() {
        this.rm_manager = Optional.ofNullable(this.getDataUser().createRandomTestUser());
        this.rmRolesAndActionsAPI.assignRoleToUser(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), this.rm_manager.get().getUsername(), ROLE_RM_MANAGER);
    }

    private void createRMUser() {
        this.rm_user_search = Optional.ofNullable(this.getDataUser().createRandomTestUser());
        this.rmRolesAndActionsAPI.assignRoleToUser(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), this.rm_user_search.get().getUsername(), ROLE_RM_USER);
    }

    private void createRMAdmin() {
        this.rm_admin_search = Optional.ofNullable(this.getDataUser().createRandomTestUser());
        this.rmRolesAndActionsAPI.assignRoleToUser(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), this.rm_admin_search.get().getUsername(), ADMIN);
    }

    private RecordCategory createCategoryIfDoesNotExist(String CATEGORY_ALL) {
        return this.createRootCategory(((DataUser)this.getDataUser().usingAdmin()).getAdminUser(), CATEGORY_ALL);
    }

    private RecordCategoryChild createRecordFolderInCategory(String FOLDER_SEARCH, RecordCategory recordCategory) {
        return this.createFolder(((DataUser)this.getDataUser().usingAdmin()).getAdminUser(), recordCategory.getId(), FOLDER_SEARCH);
    }

    private void uploadElectronicRecordInContainer(String electronic_record, String folder_search) {
        this.recordsAPI.uploadElectronicRecord(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), this.getDefaultElectronicRecordProperties(electronic_record), folder_search, CMISUtil.DocumentType.TEXT_PLAIN);
    }

    protected HttpResponse createNonElectronicRecordInContainer(String name, String categoryName, String folderName) {
        HashMap<BaseAPI.RMProperty, String> defaultProperties = new HashMap<BaseAPI.RMProperty, String>();
        defaultProperties.put(BaseAPI.RMProperty.NAME, name);
        defaultProperties.put(BaseAPI.RMProperty.TITLE, TITLE);
        defaultProperties.put(BaseAPI.RMProperty.DESCRIPTION, DESCRIPTION);
        return this.recordsAPI.createNonElectronicRecord(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), defaultProperties, categoryName, folderName);
    }

    public Map<BaseAPI.RMProperty, String> getDefaultElectronicRecordProperties(String recordName) {
        HashMap<BaseAPI.RMProperty, String> defaultProperties = new HashMap<BaseAPI.RMProperty, String>();
        defaultProperties.put(BaseAPI.RMProperty.NAME, recordName);
        defaultProperties.put(BaseAPI.RMProperty.TITLE, TITLE);
        defaultProperties.put(BaseAPI.RMProperty.DESCRIPTION, DESCRIPTION);
        defaultProperties.put(BaseAPI.RMProperty.CONTENT, TEST_CONTENT);
        return defaultProperties;
    }

    @AfterClass(alwaysRun=true)
    public void standardSearchTeardown() {
        this.deleteRecordCategory(this.categoryAll.getId());
        this.deleteRecordCategory(this.category_Admin_Only.getId());
        Optional.of(this.nonRmSiteUser).ifPresent(x -> this.getDataUser().deleteUser((UserModel)x.get()));
        Optional.of(this.rm_user_search).ifPresent(x -> this.getDataUser().deleteUser((UserModel)x.get()));
        Optional.of(this.rm_manager).ifPresent(x -> this.getDataUser().deleteUser((UserModel)x.get()));
        Optional.of(this.rm_admin_search).ifPresent(x -> this.getDataUser().deleteUser((UserModel)x.get()));
    }

    private boolean getResult(String partialRecordName, List<String> searchResults) {
        if (null != searchResults) {
            for (String searchResult : searchResults) {
                if (!searchResult.startsWith(partialRecordName)) continue;
                return true;
            }
        }
        return false;
    }

    private Object[][] getRecordsFromUnfiledRecordsContainer(UnfiledContainerChild electronicRecord) {
        UnfiledContainerAPI unfiledContainersAPI = this.getRestAPIFactory().getUnfiledContainersAPI();
        return new String[][]{{unfiledContainersAPI.uploadRecord(electronicRecord, "-unfiled-", FilePlanComponentsUtil.createTempFile(TestData.ELECTRONIC_RECORD_NAME, TestData.ELECTRONIC_RECORD_NAME)).getId()}};
    }
}

