/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.hold;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import java.io.File;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.core.JsonBodyGenerator;
import org.alfresco.rest.core.v0.BaseAPI;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.common.ReviewPeriod;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.model.recordfolder.RecordFolder;
import org.alfresco.rest.rm.community.model.recordfolder.RecordFolderProperties;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.rm.community.utils.CoreUtil;
import org.alfresco.rest.v0.HoldsAPI;
import org.alfresco.rest.v0.RMRolesAndActionsAPI;
import org.alfresco.rest.v0.service.DispositionScheduleService;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.Utility;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@AlfrescoTest(jira="RM-6903")
public class PreventActionsOnFrozenContentTests
extends BaseRMRestTest {
    private static final String HOLD_ONE = "HOLD" + CommonTestUtils.generateTestPrefix(PreventActionsOnFrozenContentTests.class);
    private static String holdNodeRef;
    private static FileModel contentHeld;
    private static File updatedFile;
    private static FolderModel folderModel;
    private static RecordCategoryChild recordFolder;
    private static Record recordFrozen;
    private static Record recordNotHeld;
    private static RecordCategory categoryWithRS;
    @Autowired
    private HoldsAPI holdsAPI;
    @Autowired
    private DispositionScheduleService dispositionScheduleService;
    @Autowired
    private RMRolesAndActionsAPI rmRolesAndActionsAPI;

    @BeforeClass(alwaysRun=true)
    public void preconditionForPreventActionsOnFrozenContent() {
        Step.STEP((String)"Create a hold.");
        holdNodeRef = this.holdsAPI.createHoldAndGetNodeRef(this.getAdminUser().getUsername(), this.getAdminUser().getUsername(), HOLD_ONE, "Active content to be reviewed for the CASE McDermott, FINRA ", "Generalized hold case for tests");
        Step.STEP((String)"Create a test file.");
        this.testSite = ((DataSite)this.dataSite.usingAdmin()).createPublicRandomSite();
        contentHeld = ((DataContent)this.dataContent.usingAdmin().usingSite(this.testSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Step.STEP((String)"Add the file to the hold.");
        this.holdsAPI.addItemToHold(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), contentHeld.getNodeRefWithoutVersion(), HOLD_ONE);
        Step.STEP((String)"Get a file resource.");
        updatedFile = Utility.getResourceTestDataFile((String)"SampleTextFile_10kb.txt");
        Step.STEP((String)"Create a folder withing the test site .");
        folderModel = ((DataContent)this.dataContent.usingAdmin().usingSite(this.testSite)).createFolder();
        Step.STEP((String)"Create a record folder with some records");
        recordFolder = this.createCategoryFolderInFilePlan();
        recordFrozen = this.createElectronicRecord(recordFolder.getId(), RandomData.getRandomName((String)"elRecordFrozen"));
        recordNotHeld = this.createElectronicRecord(recordFolder.getId(), RandomData.getRandomName((String)"elRecordNotHeld"));
        this.assertStatusCode(HttpStatus.CREATED);
        Step.STEP((String)"Add the record to the hold.");
        this.holdsAPI.addItemToHold(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), recordFrozen.getId(), HOLD_ONE);
    }

    @Test
    public void editPropertiesForContentHeld() throws Exception {
        Step.STEP((String)"Update name property of the held content");
        JsonObject nameUpdated = Json.createObjectBuilder().add("name", "HeldNameUpdated").build();
        this.restClient.authenticateUser(this.getAdminUser()).withCoreAPI().usingNode((RepoTestModel)contentHeld).updateNode(nameUpdated.toString());
        Step.STEP((String)"Check the request failed.");
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
        this.restClient.assertLastError().containsSummary("Frozen content can't be updated.");
    }

    @Test
    @AlfrescoTest(jira="RM-6925")
    public void updateContentForFrozenFile() throws Exception {
        Step.STEP((String)"Update content of the held file");
        this.restClient.authenticateUser(this.getAdminUser()).withCoreAPI().usingNode((RepoTestModel)contentHeld).updateNodeContent(updatedFile);
        Step.STEP((String)"Check the request failed.");
        this.restClient.assertStatusCodeIs(HttpStatus.INTERNAL_SERVER_ERROR);
        this.restClient.assertLastError().containsSummary("Frozen content can't be updated.");
    }

    @Test
    public void deleteFrozenFile() throws Exception {
        Step.STEP((String)"Delete frozen file");
        this.restClient.authenticateUser(this.getAdminUser()).withCoreAPI().usingNode((RepoTestModel)contentHeld).deleteNode(contentHeld.getNodeRefWithoutVersion());
        Step.STEP((String)"Check the request failed.");
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
        this.restClient.assertLastError().containsSummary("Frozen content can't be deleted.");
    }

    @Test
    @AlfrescoTest(jira="RM-6924")
    public void copyFrozenFile() {
        Step.STEP((String)"Copy frozen file");
        String postBody = JsonBodyGenerator.keyValueJson((String)"targetParentId", (String)folderModel.getNodeRef());
        this.getRestAPIFactory().getNodeAPI((RepoTestModel)contentHeld).copyNode(postBody);
        Step.STEP((String)"Check the request failed.");
        this.assertStatusCode(HttpStatus.FORBIDDEN);
        this.getRestAPIFactory().getRmRestWrapper().assertLastError().containsSummary("Permission was denied");
    }

    @Test
    public void moveFrozenFile() throws Exception {
        Step.STEP((String)"Move frozen file");
        this.getRestAPIFactory().getNodeAPI((RepoTestModel)contentHeld).move(CoreUtil.createBodyForMoveCopy(folderModel.getNodeRef()));
        Step.STEP((String)"Check the request failed.");
        this.assertStatusCode(HttpStatus.FORBIDDEN);
        this.getRestAPIFactory().getRmRestWrapper().assertLastError().containsSummary("Frozen content can't be moved.");
    }

    @Test
    @AlfrescoTest(jira="RM-6929")
    public void updateRecordFolderVitalProperties() {
        Step.STEP((String)"Update the vital record properties for the record folder");
        RecordFolder recordFolderToUpdate = RecordFolder.builder().properties(RecordFolderProperties.builder().vitalRecordIndicator(Boolean.valueOf(true)).reviewPeriod(new ReviewPeriod("month", "1")).build()).build();
        RecordFolder updatedRecordFolder = this.getRestAPIFactory().getRecordFolderAPI().updateRecordFolder(recordFolderToUpdate, recordFolder.getId());
        this.assertStatusCode(HttpStatus.OK);
        Assert.assertTrue((boolean)updatedRecordFolder.getAspectNames().contains("rma:vitalRecordDefinition"));
        Step.STEP((String)"Check the frozen record was not marked as vital");
        recordFrozen = this.getRestAPIFactory().getRecordsAPI().getRecord(recordFrozen.getId());
        AssertJUnit.assertFalse((boolean)recordFrozen.getAspectNames().contains("rma:vitalRecord"));
        Assert.assertTrue((boolean)recordFrozen.getProperties().getRecordSearchVitalRecordReviewPeriod().contains("month"));
        Assert.assertTrue((boolean)recordFrozen.getProperties().getRecordSearchVitalRecordReviewPeriodExpression().contains("1"));
        Step.STEP((String)"Check the record not held was marked as vital");
        recordNotHeld = this.getRestAPIFactory().getRecordsAPI().getRecord(recordNotHeld.getId());
        Assert.assertTrue((boolean)recordNotHeld.getAspectNames().contains("rma:vitalRecord"));
        Assert.assertNotNull((Object)recordNotHeld.getProperties().getReviewAsOf());
        Assert.assertTrue((boolean)recordNotHeld.getProperties().getRecordSearchVitalRecordReviewPeriod().contains("month"));
        Assert.assertTrue((boolean)recordNotHeld.getProperties().getRecordSearchVitalRecordReviewPeriodExpression().contains("1"));
    }

    @Test
    @AlfrescoTest(jira="RM-6929")
    public void createDispositionScheduleOnCategoryWithHeldChildren() {
        Step.STEP((String)"Create a retention schedule on the category with frozen children");
        RecordCategory categoryWithRS = this.getRestAPIFactory().getRecordCategoryAPI().getRecordCategory(recordFolder.getParentId());
        this.dispositionScheduleService.createCategoryRetentionSchedule(categoryWithRS.getName(), Boolean.valueOf(false));
        this.dispositionScheduleService.addCutOffImmediatelyStep(categoryWithRS.getName());
        this.dispositionScheduleService.addDestroyWithGhostingImmediatelyAfterCutOff(categoryWithRS.getName());
        Step.STEP((String)"Check the record folder has a disposition schedule");
        RecordFolder folderWithRS = this.getRestAPIFactory().getRecordFolderAPI().getRecordFolder(recordFolder.getId());
        Assert.assertNotNull((Object)folderWithRS.getProperties().getRecordSearchDispositionAuthority());
        Assert.assertNotNull((Object)folderWithRS.getProperties().getRecordSearchDispositionInstructions());
    }

    @Test
    @AlfrescoTest(jira="RM-6931")
    public void retainActionOnFrozenHeldRecords() {
        Step.STEP((String)"Add a category with a disposition schedule.");
        categoryWithRS = this.createRootCategory(RandomData.getRandomName((String)"CategoryWithRS"));
        this.dispositionScheduleService.createCategoryRetentionSchedule(categoryWithRS.getName(), Boolean.valueOf(true));
        this.dispositionScheduleService.addRetainAfterPeriodStep(categoryWithRS.getName(), "immediately");
        this.dispositionScheduleService.addDestroyWithGhostingImmediatelyAfterCutOff(categoryWithRS.getName());
        Step.STEP((String)"Create record folder with a record.");
        RecordCategoryChild folder = this.createFolder(categoryWithRS.getId(), RandomData.getRandomName((String)"RecFolder"));
        Record record = this.createElectronicRecord(folder.getId(), RandomData.getRandomName((String)"elRecord"));
        this.completeRecord(record.getId());
        Step.STEP((String)"Add the record to the hold");
        this.holdsAPI.addItemToHold(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), record.getId(), HOLD_ONE);
        Step.STEP((String)"Execute the retain action");
        this.rmRolesAndActionsAPI.executeAction(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), record.getName(), BaseAPI.RM_ACTIONS.END_RETENTION, null, 500);
        Step.STEP((String)"Check the record search disposition properties");
        Record recordUpdated = this.getRestAPIFactory().getRecordsAPI().getRecord(record.getId());
        Assert.assertTrue((boolean)recordUpdated.getProperties().getRecordSearchDispositionActionName().contains(BaseAPI.RM_ACTIONS.END_RETENTION.getAction()));
        Assert.assertTrue((boolean)recordUpdated.getProperties().getRecordSearchDispositionPeriod().contains("immediately"));
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpPreventActionsOnFrozenContent() {
        this.holdsAPI.deleteHold(this.getAdminUser(), holdNodeRef);
        ((DataSite)this.dataSite.usingAdmin()).deleteSite(this.testSite);
        this.deleteRecordCategory(recordFolder.getParentId());
        this.deleteRecordCategory(categoryWithRS.getId());
    }
}

