/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.records;

import java.util.HashMap;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.core.v0.APIUtils;
import org.alfresco.rest.core.v0.BaseAPI;
import org.alfresco.rest.model.RestNodeModel;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.requests.gscore.api.RecordFolderAPI;
import org.alfresco.rest.rm.community.requests.gscore.api.UnfiledRecordFolderAPI;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.rm.community.utils.CoreUtil;
import org.alfresco.rest.v0.RMRolesAndActionsAPI;
import org.alfresco.rest.v0.RecordsAPI;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.http.HttpResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class FileUnfiledRecordsTests
extends BaseRMRestTest {
    private final String TEST_PREFIX = CommonTestUtils.generateTestPrefix(FileUnfiledRecordsTests.class);
    private final String RM_ADMIN = this.TEST_PREFIX + "rm_admin";
    public static final String NODE_REF_WORKSPACE_SPACES_STORE = "workspace://SpacesStore/";
    private UserModel testUser;
    private SiteModel testSite;
    private String unfiledRecordFolderId;
    private UserModel RmAdminUser;
    private RecordCategory rootCategory;
    private RecordCategoryChild recordFolder;
    private final String recordName = "RM-2790 record";
    private final String recordTitle = "RM-2790 record title";
    private final String recordDescription = "RM-2790 record description";
    @Autowired
    private RMRolesAndActionsAPI rmRolesAndActionsAPI;
    @Autowired
    private RecordsAPI recordsAPI;

    @BeforeClass(alwaysRun=true)
    public void preConditions() {
        Step.STEP((String)"Create RM Site");
        this.createRMSiteIfNotExists();
        Step.STEP((String)"Create RM Admin user");
        this.rmRolesAndActionsAPI.createUserAndAssignToRole(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.RM_ADMIN, this.getAdminUser().getPassword(), "Administrator");
        this.RmAdminUser = new UserModel(this.RM_ADMIN, this.getAdminUser().getPassword());
        Step.STEP((String)"Create collab_user user");
        this.testUser = this.getDataUser().createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingAdmin()).createPublicRandomSite();
        this.getDataUser().addUserToSite(this.testUser, this.testSite, UserRole.SiteContributor);
    }

    @Test
    @AlfrescoTest(jira="RM-2790")
    public void fileUnfiledRecords() throws Exception {
        Step.STEP((String)"Upload the document to test site and then make it reacord");
        FileModel uploadedDocbyCollabUser = ((DataContent)this.dataContent.usingSite(this.testSite)).usingUser(this.testUser).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Record uploadedDocRecordbyCollabUser = this.getRestAPIFactory().getFilesAPI(this.testUser).declareAsRecord(uploadedDocbyCollabUser.getNodeRefWithoutVersion());
        this.assertStatusCode(HttpStatus.CREATED);
        Step.STEP((String)"Create root level category");
        this.rootCategory = this.createRootCategory(this.RmAdminUser, RandomData.getRandomName((String)"Category"));
        Step.STEP((String)"Create the record folder inside the rootCategory");
        this.recordFolder = this.createFolder(this.RmAdminUser, this.rootCategory.getId(), RandomData.getRandomName((String)"Folder"));
        Step.STEP((String)"Create a non-electronic record by completing some of the fields");
        HashMap<BaseAPI.RMProperty, String> non_electronic_records_properties = new HashMap<BaseAPI.RMProperty, String>();
        non_electronic_records_properties.put(BaseAPI.RMProperty.TITLE, "RM-2790 record title");
        non_electronic_records_properties.put(BaseAPI.RMProperty.DESCRIPTION, "RM-2790 record description");
        non_electronic_records_properties.put(BaseAPI.RMProperty.NAME, "RM-2790 record");
        non_electronic_records_properties.put(BaseAPI.RMProperty.PHYSICAL_SIZE, "");
        non_electronic_records_properties.put(BaseAPI.RMProperty.NUMBER_OF_COPIES, "");
        non_electronic_records_properties.put(BaseAPI.RMProperty.SHELF, "");
        non_electronic_records_properties.put(BaseAPI.RMProperty.STORAGE_LOCATION, "");
        non_electronic_records_properties.put(BaseAPI.RMProperty.BOX, "");
        non_electronic_records_properties.put(BaseAPI.RMProperty.FILE, "");
        HttpResponse nonElectronicRecordHttpResponse = this.recordsAPI.createNonElectronicRecord(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), non_electronic_records_properties, this.rootCategory.getName(), this.recordFolder.getName());
        String nonElectronicRecordId = this.getNodeRef(nonElectronicRecordHttpResponse);
        Step.STEP((String)"Check the non-electronic record has been created");
        this.assertStatusCode(HttpStatus.CREATED);
        Step.STEP((String)"Create a electronic record by completing some of the fields");
        HashMap<BaseAPI.RMProperty, String> electronic_records_properties = new HashMap<BaseAPI.RMProperty, String>();
        electronic_records_properties.put(BaseAPI.RMProperty.DESCRIPTION, "RM-2790 record description");
        electronic_records_properties.put(BaseAPI.RMProperty.NAME, "RM-2790 record");
        this.recordsAPI.uploadElectronicRecord(this.RmAdminUser.getUsername(), this.RmAdminUser.getPassword(), electronic_records_properties, this.recordFolder.getName(), CMISUtil.DocumentType.TEXT_PLAIN);
        CmisObject electronicRecord = this.recordsAPI.getRecord(this.RmAdminUser.getUsername(), this.RmAdminUser.getPassword(), this.recordFolder.getName(), (String)electronic_records_properties.get(BaseAPI.RMProperty.NAME));
        Step.STEP((String)"Check the electronic record has been created");
        this.assertStatusCode(HttpStatus.CREATED);
        Step.STEP((String)"Create a root folder under FilePlan - Unfiled");
        String unFiledFolder = this.createUnFileFolder();
        Step.STEP((String)"Move all the Unfiled Records to unFiledFolder");
        RestNodeModel uploadDocRestNodeModel = this.getRestAPIFactory().getNodeAPI((RepoTestModel)CoreUtil.toContentModel(uploadedDocRecordbyCollabUser.getId())).move(CoreUtil.createBodyForMoveCopy(unFiledFolder));
        RestNodeModel nonElectronicDocRestNodeModel = this.getRestAPIFactory().getNodeAPI((RepoTestModel)CoreUtil.toContentModel(nonElectronicRecordId)).move(CoreUtil.createBodyForMoveCopy(unFiledFolder));
        RestNodeModel electronicDocRestNodeModel = this.getRestAPIFactory().getNodeAPI((RepoTestModel)CoreUtil.toContentModel(electronicRecord.getId())).move(CoreUtil.createBodyForMoveCopy(unFiledFolder));
        Step.STEP((String)"Move all the Record present in the unFiledFolder to Folder inside Root Category");
        this.getRestAPIFactory().getNodeAPI((RepoTestModel)CoreUtil.toContentModel(uploadDocRestNodeModel.getId())).move(CoreUtil.createBodyForMoveCopy(this.recordFolder.getId()));
        this.getRestAPIFactory().getNodeAPI((RepoTestModel)CoreUtil.toContentModel(nonElectronicDocRestNodeModel.getId())).move(CoreUtil.createBodyForMoveCopy(this.recordFolder.getId()));
        this.getRestAPIFactory().getNodeAPI((RepoTestModel)CoreUtil.toContentModel(electronicDocRestNodeModel.getId())).move(CoreUtil.createBodyForMoveCopy(this.recordFolder.getId()));
        this.getRestAPIFactory().getRecordsAPI().deleteRecord(uploadDocRestNodeModel.getId());
        this.getRestAPIFactory().getRecordsAPI().deleteRecord(nonElectronicDocRestNodeModel.getId());
        this.getRestAPIFactory().getRecordsAPI().deleteRecord(electronicDocRestNodeModel.getId());
        UnfiledRecordFolderAPI unfiledRecordFoldersAPI = this.getRestAPIFactory().getUnfiledRecordFoldersAPI();
        unfiledRecordFoldersAPI.deleteUnfiledRecordFolder(unFiledFolder);
        RecordFolderAPI recordFolderAPI = this.getRestAPIFactory().getRecordFolderAPI();
        String recordFolderId = this.recordFolder.getId();
        recordFolderAPI.deleteRecordFolder(recordFolderId);
    }

    @AfterClass(alwaysRun=true)
    public void deletePreConditions() {
        Step.STEP((String)"Delete the created rootCategory along with corresponding record folders/records present in it");
        this.getRestAPIFactory().getRecordCategoryAPI().deleteRecordCategory(this.rootCategory.getId());
    }

    private String createUnFileFolder() {
        String categoryName = "RM-2790 record Category name " + RandomData.getRandomAlphanumeric();
        this.unfiledRecordFolderId = this.createUnfiledContainerChild("-unfiled-", categoryName + RandomData.getRandomAlphanumeric(), "rma:unfiledRecordFolder").getId();
        return this.unfiledRecordFolderId;
    }

    private String getNodeRef(HttpResponse httpResponse) {
        return APIUtils.convertHTTPResponseToJSON((HttpResponse)httpResponse).getString("persistedObject").replace(NODE_REF_WORKSPACE_SPACES_STORE, "");
    }
}

