/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.unfiledcontainers;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.base.DataProviderClass;
import org.alfresco.rest.rm.community.model.fileplan.FilePlan;
import org.alfresco.rest.rm.community.model.unfiledcontainer.UnfiledContainer;
import org.alfresco.rest.rm.community.model.unfiledcontainer.UnfiledContainerChild;
import org.alfresco.rest.rm.community.model.unfiledcontainer.UnfiledContainerChildCollection;
import org.alfresco.rest.rm.community.model.unfiledcontainer.UnfiledContainerChildProperties;
import org.alfresco.rest.rm.community.model.unfiledcontainer.UnfiledRecordFolder;
import org.alfresco.rest.rm.community.utils.FilePlanComponentsUtil;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.report.Bug;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class UnfiledContainerTests
extends BaseRMRestTest {
    private static final int NUMBER_OF_CHILDREN = 10;
    private final List<UnfiledContainerChild> unfiledChildren = new ArrayList<UnfiledContainerChild>();

    @DataProvider(name="unfiledFolderTypes")
    public static Object[][] unfiledFolderTypes() {
        return new String[][]{{"rma:unfiledRecordFolder"}, {"cm:folder"}};
    }

    @Test(description="Get the unfiled records container")
    public void getUnfiledRecordsContainer() {
        UnfiledContainer container = this.getRestAPIFactory().getUnfiledContainersAPI().getUnfiledContainer("-unfiled-");
        this.assertStatusCode(HttpStatus.OK);
        Assert.assertEquals((String)container.getNodeType(), (String)"rma:unfiledRecordContainer");
    }

    @Test(description="Rename unfiled container")
    public void renameUnfiledContainer() {
        String newContainerName = "RenamedUnfiledContainer (" + RandomData.getRandomAlphanumeric() + ")";
        UnfiledContainer unfiledContainerUpdate = UnfiledContainer.builder().name(newContainerName).build();
        UnfiledContainer renamedUnfiledContainer = this.getRestAPIFactory().getUnfiledContainersAPI().updateUnfiledContainer(unfiledContainerUpdate, "-unfiled-");
        this.assertStatusCode(HttpStatus.OK);
        Assert.assertEquals((String)renamedUnfiledContainer.getName(), (String)newContainerName);
        FilePlan filePlan = this.getRestAPIFactory().getFilePlansAPI().getFilePlan("-filePlan-");
        Assert.assertEquals((String)renamedUnfiledContainer.getParentId(), (String)filePlan.getId());
    }

    @Test(description="Create unfiled record folder child in unfiled root container", dataProvider="unfiledFolderTypes")
    public void createUnfiledRecordFolderChild(String folderType) {
        String unfiledRecordFolderName = "UnfiledRecordFolder-" + RandomData.getRandomAlphanumeric();
        UnfiledContainerChild unfiledRecordFolderChild = this.createUnfiledContainerChild("-unfiled-", unfiledRecordFolderName, folderType);
        this.unfiledChildren.add(unfiledRecordFolderChild);
        Assert.assertNotNull((Object)unfiledRecordFolderChild.getId());
        Assert.assertFalse((boolean)unfiledRecordFolderChild.getIsRecord());
        Assert.assertTrue((boolean)unfiledRecordFolderChild.getIsUnfiledRecordFolder());
        Assert.assertEquals((String)unfiledRecordFolderChild.getName(), (String)unfiledRecordFolderName);
        Assert.assertEquals((String)unfiledRecordFolderChild.getNodeType(), (String)"rma:unfiledRecordFolder");
        Assert.assertEquals((String)unfiledRecordFolderChild.getCreatedByUser().getId(), (String)this.getAdminUser().getUsername());
        UnfiledRecordFolder unfiledRecordFolder = this.getRestAPIFactory().getUnfiledRecordFoldersAPI().getUnfiledRecordFolder(unfiledRecordFolderChild.getId());
        UnfiledContainerChildProperties unfiledRecordFolderChildProperties = unfiledRecordFolder.getProperties();
        Assert.assertEquals((String)unfiledRecordFolderChildProperties.getTitle(), (String)("Title for " + unfiledRecordFolderName));
        Assert.assertNotNull((Object)unfiledRecordFolderChildProperties.getIdentifier());
        Assert.assertEquals((String)unfiledRecordFolder.getParentId(), (String)this.getRestAPIFactory().getUnfiledContainersAPI().getUnfiledContainer("-unfiled-").getId());
    }

    @Test(description="Create duplicate unfiled folder child", dataProvider="unfiledFolderTypes")
    @Bug(id="RM-5116, RM-5148")
    public void createDuplicateUnfiledFolderChild(String folderType) {
        String unfiledRecordFolderName = "UnfiledRecordFolder-" + RandomData.getRandomAlphanumeric();
        UnfiledContainerChild unfiledRecordFolderChild = this.createUnfiledContainerChild("-unfiled-", unfiledRecordFolderName, folderType);
        this.assertStatusCode(HttpStatus.CREATED);
        this.unfiledChildren.add(unfiledRecordFolderChild);
        Assert.assertEquals((String)unfiledRecordFolderChild.getName(), (String)unfiledRecordFolderName);
        UnfiledContainerChild unfiledRecordFolderDuplicate = this.getRestAPIFactory().getUnfiledContainersAPI().createUnfiledContainerChild(FilePlanComponentsUtil.createUnfiledContainerChildModel(unfiledRecordFolderName, folderType), "-unfiled-");
        this.assertStatusCode(HttpStatus.CONFLICT);
        unfiledRecordFolderDuplicate = this.getRestAPIFactory().getUnfiledContainersAPI().createUnfiledContainerChild(FilePlanComponentsUtil.createUnfiledContainerChildModel(unfiledRecordFolderName, folderType), "-unfiled-", "autoRename=true");
        this.assertStatusCode(HttpStatus.CREATED);
        this.unfiledChildren.add(unfiledRecordFolderDuplicate);
        Assert.assertNotEquals((Object)unfiledRecordFolderDuplicate.getName(), (Object)unfiledRecordFolderName);
        Assert.assertTrue((boolean)unfiledRecordFolderDuplicate.getName().startsWith(unfiledRecordFolderName));
    }

    @Test(description="Create unfiled record folder child in unfiled root container")
    public void createUnfiledRecordFolderChildWithRelativePathNotSuported() {
        String relativePath = LocalDateTime.now().getYear() + "/" + String.valueOf(LocalDateTime.now().getMonth()) + "/" + LocalDateTime.now().getDayOfMonth();
        UnfiledContainerChild unfiledFolderModel = UnfiledContainerChild.builder().name(RandomData.getRandomName((String)"UnfiledRecordFolder")).nodeType("rma:unfiledRecordFolder").relativePath(relativePath).build();
        this.getRestAPIFactory().getUnfiledContainersAPI().createUnfiledContainerChild(unfiledFolderModel, "-unfiled-");
        this.assertStatusCode(HttpStatus.BAD_REQUEST);
    }

    @Test(description="Create non-electronic record child in unfiled root container")
    public void createNonElectronicRecordChild() {
        String recordName = "NERecord-" + RandomData.getRandomAlphanumeric();
        UnfiledContainerChild unfiledRecord = this.createUnfiledContainerChild("-unfiled-", recordName, "rma:nonElectronicDocument");
        this.unfiledChildren.add(unfiledRecord);
        Assert.assertNotNull((Object)unfiledRecord.getId());
        Assert.assertTrue((boolean)unfiledRecord.getIsRecord());
        Assert.assertEquals((String)unfiledRecord.getNodeType(), (String)"rma:nonElectronicDocument");
        UnfiledContainer container = this.getRestAPIFactory().getUnfiledContainersAPI().getUnfiledContainer("-unfiled-");
        Assert.assertEquals((String)unfiledRecord.getParentId(), (String)container.getId());
        String identifier = unfiledRecord.getProperties().getIdentifier();
        Assert.assertNotNull((Object)identifier);
        Assert.assertEquals((String)unfiledRecord.getName(), (String)(recordName + " (" + identifier + ")"));
    }

    @Test(description="Create electronic record child in unfiled root container")
    public void createElectronicRecordChild() {
        String recordName = "ERecord-" + RandomData.getRandomAlphanumeric();
        UnfiledContainerChild unfiledRecord = this.createUnfiledContainerChild("-unfiled-", recordName, "cm:content");
        this.unfiledChildren.add(unfiledRecord);
        Assert.assertNotNull((Object)unfiledRecord.getId());
        Assert.assertTrue((boolean)unfiledRecord.getIsRecord());
        Assert.assertEquals((String)unfiledRecord.getNodeType(), (String)"cm:content");
        UnfiledContainer container = this.getRestAPIFactory().getUnfiledContainersAPI().getUnfiledContainer("-unfiled-");
        Assert.assertEquals((String)unfiledRecord.getParentId(), (String)container.getId());
        String identifier = unfiledRecord.getProperties().getIdentifier();
        Assert.assertNotNull((Object)identifier);
        Assert.assertEquals((String)unfiledRecord.getName(), (String)(recordName + " (" + identifier + ")"));
    }

    @Test(description="Get children of the root unfiled root container")
    public void getUnfiledRootContainerChildren() {
        LinkedList<UnfiledContainerChild> createdChildren = new LinkedList<UnfiledContainerChild>();
        for (int i = 0; i < 10; ++i) {
            String childType = i % 3 == 0 ? "cm:content" : (i % 3 == 1 ? "rma:nonElectronicDocument" : "rma:unfiledRecordFolder");
            UnfiledContainerChild child = this.createUnfiledContainerChild("-unfiled-", RandomData.getRandomAlphanumeric(), childType);
            Assert.assertNotNull((Object)child.getId());
            createdChildren.add(child);
        }
        UnfiledContainerChildCollection listedChildren = this.getRestAPIFactory().getUnfiledContainersAPI().getUnfiledContainerChildren("-unfiled-", "include=properties");
        this.assertStatusCode(HttpStatus.OK);
        UnfiledContainer unfiledContainer = this.getRestAPIFactory().getUnfiledContainersAPI().getUnfiledContainer("-unfiled-");
        LinkedList verifiedChildren = new LinkedList();
        listedChildren.getEntries().forEach(c -> {
            UnfiledContainerChild containerChild = c.getEntry();
            String childId = containerChild.getId();
            Assert.assertNotNull((Object)childId);
            this.logger.info((Object)("Checking child " + childId));
            try {
                UnfiledContainerChild createdComponent = createdChildren.stream().filter(child -> child.getId().equals(childId)).findFirst().orElseThrow();
                Assert.assertEquals((String)containerChild.getCreatedByUser().getId(), (String)this.getAdminUser().getUsername());
                Assert.assertEquals((String)containerChild.getParentId(), (String)unfiledContainer.getId());
                if (containerChild.getNodeType().equals("rma:unfiledRecordFolder")) {
                    Assert.assertFalse((boolean)containerChild.getIsRecord());
                } else {
                    Assert.assertTrue((boolean)containerChild.getIsRecord());
                    Assert.assertTrue((boolean)containerChild.getName().contains(containerChild.getProperties().getIdentifier()), (String)"Records don't have in name the identifier");
                }
                Assert.assertEquals((String)createdComponent.getName(), (String)containerChild.getName());
                Assert.assertEquals((String)createdComponent.getNodeType(), (String)containerChild.getNodeType());
                Assert.assertNotNull((Object)createdComponent.getProperties().getIdentifier());
                verifiedChildren.add(createdComponent);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        });
        Assert.assertTrue((boolean)verifiedChildren.containsAll(createdChildren));
        Assert.assertTrue((boolean)createdChildren.containsAll(verifiedChildren));
        this.unfiledChildren.addAll(createdChildren);
    }

    @Test(dataProvider="invalidRootTypes", dataProviderClass=DataProviderClass.class, description="Only unfiled records folders and records  can be created as children for unfiled container root")
    public void createInvalidUnfiledChildren(String filePlanComponentType) {
        String unfiledRecordFolderName = "UnfiledRecordFolder-" + RandomData.getRandomAlphanumeric();
        this.logger.info((Object)("creating " + filePlanComponentType));
        UnfiledContainerChild unfiledFolderModel = FilePlanComponentsUtil.createUnfiledContainerChildModel(unfiledRecordFolderName, filePlanComponentType);
        this.getRestAPIFactory().getUnfiledContainersAPI().createUnfiledContainerChild(unfiledFolderModel, "-unfiled-");
        this.assertStatusCode(HttpStatus.UNPROCESSABLE_ENTITY);
    }

    @Test(description="Create a record with custom record identifier in unfiled container")
    public void createRecordWithCustomIdentifier() {
        String recordName = "customIdRecord-" + RandomData.getRandomAlphanumeric();
        String customIdentifier = "customId";
        UnfiledContainerChildProperties propertiesModel = UnfiledContainerChildProperties.builder().identifier(customIdentifier).build();
        UnfiledContainerChild childModel = UnfiledContainerChild.builder().name(recordName).nodeType("cm:content").properties(propertiesModel).build();
        UnfiledContainerChild child = this.getRestAPIFactory().getUnfiledContainersAPI().createUnfiledContainerChild(childModel, "-unfiled-");
        this.assertStatusCode(HttpStatus.CREATED);
        this.unfiledChildren.add(child);
        Assert.assertEquals((String)child.getProperties().getIdentifier(), (String)customIdentifier);
        Assert.assertEquals((String)child.getName(), (String)(recordName + " (" + customIdentifier + ")"));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.unfiledChildren.forEach(unfiledChild -> {
            if (unfiledChild.getIsRecord().booleanValue()) {
                this.getRestAPIFactory().getRecordsAPI().deleteRecord(unfiledChild.getId());
            } else {
                this.getRestAPIFactory().getUnfiledRecordFoldersAPI().deleteUnfiledRecordFolder(unfiledChild.getId());
            }
        });
    }
}

