/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.smoke;

import java.util.concurrent.atomic.AtomicReference;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.model.recordfolder.RecordFolderCollection;
import org.alfresco.rest.rm.community.model.recordfolder.RecordFolderEntry;
import org.alfresco.rest.rm.community.model.user.UserPermissions;
import org.alfresco.rest.rm.community.model.user.UserRoles;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.rm.community.utils.CoreUtil;
import org.alfresco.rest.v0.RecordCategoriesAPI;
import org.alfresco.rest.v0.service.RoleService;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.Utility;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.util.AssertionErrors;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class FileAsRecordTests
extends BaseRMRestTest {
    private static final String CATEGORY_MANAGER = "catManager" + CommonTestUtils.generateTestPrefix(FileAsRecordTests.class);
    private static final String CATEGORY_ADMIN = "catAdmin" + CommonTestUtils.generateTestPrefix(FileAsRecordTests.class);
    private static final String FOLDER_MANAGER = "recordFolder" + CommonTestUtils.generateTestPrefix(FileAsRecordTests.class);
    private static final String FOLDER_ADMIN = "recordFolder" + CommonTestUtils.generateTestPrefix(FileAsRecordTests.class);
    private UserModel nonRMuser;
    private UserModel rmManager;
    private SiteModel testSite;
    private FileModel document;
    private FileModel documentDeclared;
    private RecordCategory category_manager;
    private RecordCategory category_admin;
    private RecordCategoryChild folder_admin;
    private RecordCategoryChild folder_manager;
    @Autowired
    private DataSite dataSite;
    @Autowired
    private DataContent dataContent;
    @Autowired
    private RoleService roleService;
    @Autowired
    private RecordCategoriesAPI recordCategoriesAPI;

    @BeforeClass(alwaysRun=true)
    public void preconditionForFileAsRecordRecordTests() {
        Step.STEP((String)"Create the RM site if doesn't exist");
        this.createRMSiteIfNotExists();
        Step.STEP((String)"Create a user");
        this.nonRMuser = this.dataUser.createRandomTestUser("testUser");
        Step.STEP((String)"Create a collaboration site");
        this.testSite = ((DataSite)this.dataSite.usingUser(this.nonRMuser)).createPublicRandomSite();
        Step.STEP((String)"Create a document with the user without RM role");
        this.document = ((DataContent)this.dataContent.usingSite(this.testSite)).usingUser(this.nonRMuser).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Step.STEP((String)"Create two categories with two folders");
        this.category_manager = this.createRootCategory(CATEGORY_MANAGER);
        this.category_admin = this.createRootCategory(CATEGORY_ADMIN);
        this.folder_admin = this.createFolder(this.category_admin.getId(), FOLDER_ADMIN);
        this.folder_manager = this.createFolder(this.category_manager.getId(), FOLDER_MANAGER);
        Step.STEP((String)"Create an rm user and give filling permission over CATEGORY_MANAGER record category");
        new RecordCategory();
        RecordCategory recordCategory = RecordCategory.builder().id(this.category_manager.getId()).build();
        this.rmManager = this.roleService.createCollaboratorWithRMRoleAndPermission(this.testSite, recordCategory, UserRoles.ROLE_RM_MANAGER, UserPermissions.PERMISSION_FILING);
    }

    @Test
    @AlfrescoTest(jira="RM-6780")
    public void checkFileAsRecordToRecordFolder() throws Exception {
        AtomicReference apiChildren = new AtomicReference();
        Step.STEP((String)"Create a document with the user with RM role");
        this.documentDeclared = ((DataContent)this.dataContent.usingSite(this.testSite)).usingUser(this.rmManager).createContent(new FileModel("checkDeclareAndFileToRecordFolder", FileType.TEXT_PLAIN));
        Step.STEP((String)"Declare and file into  a record folder the document uploaded");
        this.getRestAPIFactory().getActionsAPI(this.rmManager).declareAndFile((RepoTestModel)this.documentDeclared, Utility.buildPath((String)CATEGORY_MANAGER, (String[])new String[]{FOLDER_MANAGER}));
        Step.STEP((String)"Check the file is a record within the collaboration site");
        try {
            Utility.sleep((int)1000, (int)40000, () -> {
                JSONObject collaboratorSearchJson = this.getSearchApi().liveSearchForDocuments(this.rmManager.getUsername(), this.rmManager.getPassword(), this.documentDeclared.getName());
                AssertionErrors.assertTrue((String)"Rm Manager not able to find the document.", (collaboratorSearchJson.getJSONArray("items").length() != 0 ? 1 : 0) != 0);
            });
        }
        catch (InterruptedException e) {
            Assert.fail((String)"InterruptedException received while waiting for results.");
        }
        Step.STEP((String)"Check the record is filed into the record folder.");
        try {
            Utility.sleep((int)1000, (int)40000, () -> apiChildren.set((RecordFolderCollection)((RestModels)this.getRestAPIFactory().getRecordFolderAPI(this.rmManager).getRecordFolderChildren(this.folder_manager.getId(), "include=properties").assertThat().entriesListIsNotEmpty()).assertThat().entriesListIsNotEmpty()));
        }
        catch (InterruptedException e) {
            Assert.fail((String)"InterruptedException received while waiting for results.");
        }
        Assert.assertEquals((String)((RecordFolderEntry)((RecordFolderCollection)apiChildren.get()).getEntries().get(0)).getEntry().getProperties().getOriginalName(), (String)this.documentDeclared.getName());
    }

    @Test
    @AlfrescoTest(jira="RM-6780")
    public void fileAsRecordToUnfiledRecordFolder() throws Exception {
        Step.STEP((String)"Create a document with the user without RM role");
        FileModel inplaceRecord = ((DataContent)this.dataContent.usingSite(this.testSite)).usingUser(this.rmManager).createContent(new FileModel("declareAndFileToIntoUnfiledRecordFolder", FileType.TEXT_PLAIN));
        Step.STEP((String)"Click on Declare and file without selecting a record folder");
        this.getRestAPIFactory().getActionsAPI(this.rmManager).declareAndFile((RepoTestModel)inplaceRecord, "");
        Step.STEP((String)"Check the file is declared in unfiled record folder");
        Assert.assertTrue((boolean)this.isMatchingRecordInUnfiledRecords(inplaceRecord), (String)"Record should be filed to Unfiled Records folder");
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpForFileAsRecordRecordTests() {
        Step.STEP((String)"Delete the collaboration site");
        ((DataSite)this.dataSite.usingUser(this.nonRMuser)).deleteSite(this.testSite);
        Step.STEP((String)"Empty the trashcan.");
        this.restClient.authenticateUser(this.nonRMuser).withCoreAPI().usingTrashcan().deleteNodeFromTrashcan((RepoTestModel)CoreUtil.toContentModel(this.testSite.getId()));
        this.getRestAPIFactory().getUnfiledContainersAPI(this.rmManager).getUnfiledContainerChildren("-unfiled-").getEntries().stream().forEach(x -> this.getRestAPIFactory().getRecordsAPI().deleteRecord(x.getEntry().getId()));
        Step.STEP((String)"Cleanup Documents inside folders");
        Step.STEP((String)"Delete folders");
        this.getRestAPIFactory().getRecordFolderAPI().deleteRecordFolder(this.folder_admin.getId());
        this.getRestAPIFactory().getRecordFolderAPI().deleteRecordFolder(this.folder_manager.getId());
        Step.STEP((String)"Delete categories");
        this.recordCategoriesAPI.deleteCategory(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), this.category_manager.getName());
        this.recordCategoriesAPI.deleteCategory(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), this.category_admin.getName());
        Step.STEP((String)"Delete Users");
        this.dataUser.deleteUser(this.nonRMuser);
        this.dataUser.deleteUser(this.rmManager);
    }
}

