/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.requests.gscore.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.http.ContentType;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.alfresco.rest.core.RMRestWrapper;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.rm.community.model.recordfolder.RecordFolder;
import org.alfresco.rest.rm.community.model.recordfolder.RecordFolderCollection;
import org.alfresco.rest.rm.community.requests.RMModelRequest;
import org.alfresco.rest.rm.community.util.FilePlanComponentMixIn;
import org.alfresco.rest.rm.community.util.ParameterCheck;
import org.alfresco.rest.rm.community.util.PojoUtility;
import org.springframework.http.HttpMethod;
import org.testng.Assert;

public class RecordFolderAPI
extends RMModelRequest {
    public RecordFolderAPI(RMRestWrapper rmRestWrapper) {
        super(rmRestWrapper);
    }

    public void deleteRecordFolder(String recordFolderId) {
        ParameterCheck.mandatoryString("recordFolderId", recordFolderId);
        this.getRmRestWrapper().processEmptyModel(RestRequest.simpleRequest((HttpMethod)HttpMethod.DELETE, (String)"record-folders/{recordFolderId}", (String[])new String[]{recordFolderId}));
    }

    public RecordFolder getRecordFolder(String recordFolderId) {
        ParameterCheck.mandatoryString("recordFolderId", recordFolderId);
        return this.getRecordFolder(recordFolderId, "");
    }

    public RecordFolder getRecordFolder(String recordFolderId, String parameters) {
        ParameterCheck.mandatoryString("recordFolderId", recordFolderId);
        return this.getRmRestWrapper().processModel(RecordFolder.class, RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)"record-folders/{recordFolderId}?{parameters}", (String[])new String[]{recordFolderId, parameters}));
    }

    public RecordFolder updateRecordFolder(RecordFolder recordFolderModel, String recordFolderId) {
        ParameterCheck.mandatoryObject("recordFolderModel", (Object)recordFolderModel);
        ParameterCheck.mandatoryString("recordFolderId", recordFolderId);
        return this.updateRecordFolder(recordFolderModel, recordFolderId, "");
    }

    public RecordFolder updateRecordFolder(RecordFolder recordFolderModel, String recordFolderId, String parameters) {
        ParameterCheck.mandatoryObject("recordFolderModel", (Object)recordFolderModel);
        ParameterCheck.mandatoryString("recordFolderId", recordFolderId);
        return this.getRmRestWrapper().processModel(RecordFolder.class, RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)PojoUtility.toJson((Object)recordFolderModel), (String)"record-folders/{recordFolderId}?{parameters}", (String[])new String[]{recordFolderId, parameters}));
    }

    public RecordFolderCollection getRecordFolderChildren(String recordFolderId) {
        ParameterCheck.mandatoryString("recordFolderId", recordFolderId);
        return this.getRecordFolderChildren(recordFolderId, "");
    }

    public RecordFolderCollection getRecordFolderChildren(String recordFolderId, String parameters) {
        ParameterCheck.mandatoryString("recordFolderId", recordFolderId);
        return this.getRmRestWrapper().processModels(RecordFolderCollection.class, RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)"record-folders/{recordFolderId}/records?{parameters}", (String[])new String[]{recordFolderId, parameters}));
    }

    public Record createRecord(Record recordModel, String recordFolderId) {
        ParameterCheck.mandatoryObject("recordModel", (Object)recordModel);
        ParameterCheck.mandatoryString("recordFolderId", recordFolderId);
        return this.createRecord(recordModel, recordFolderId, "");
    }

    public Record createRecord(Record recordModel, String recordFolderId, File recordContent) throws RuntimeException {
        JsonNode root;
        ParameterCheck.mandatoryString("recordFolderId", recordFolderId);
        ParameterCheck.mandatoryObject("recordContent", recordContent);
        ParameterCheck.mandatoryObject("recordModel", (Object)recordModel);
        if (!recordModel.getNodeType().equals("cm:content")) {
            Assert.fail((String)"Only electronic records are supported");
        }
        RequestSpecBuilder builder = this.getRmRestWrapper().configureRequestSpec();
        try {
            root = new ObjectMapper().readTree(PojoUtility.toJson((Object)recordModel, Record.class, FilePlanComponentMixIn.class));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to convert model to JSON.", e);
        }
        Iterator fieldNames = root.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            builder.addMultiPart(fieldName, root.get(fieldName).asText(), ContentType.JSON.name());
        }
        builder.addMultiPart("filedata", recordContent, ContentType.BINARY.name());
        return this.createRecord(recordModel, recordFolderId);
    }

    public Record createRecord(Record recordModel, String recordFolderId, String parameters) {
        ParameterCheck.mandatoryObject("recordModel", (Object)recordModel);
        ParameterCheck.mandatoryString("recordFolderId", recordFolderId);
        return this.getRmRestWrapper().processModel(Record.class, RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)PojoUtility.toJson((Object)recordModel), (String)"record-folders/{recordFolderId}/records?{parameters}", (String[])new String[]{recordFolderId, parameters}));
    }
}

