/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.retentionschedule;

import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.retentionschedule.RetentionSchedule;
import org.alfresco.rest.rm.community.model.retentionschedule.RetentionScheduleCollection;
import org.alfresco.rest.v0.RMRolesAndActionsAPI;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.UserModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class RetentionScheduleTests
extends BaseRMRestTest {
    private RecordCategory recordCategory;
    private RetentionSchedule createdRetentionSchedule;
    private UserModel nonRMuser;
    @Autowired
    private RMRolesAndActionsAPI rmRolesAndActionsAPI;

    @BeforeClass(alwaysRun=true)
    public void preconditionForRetentionScheduleTests() {
        this.createRMSiteIfNotExists();
        this.nonRMuser = this.dataUser.createRandomTestUser("testUser");
        this.recordCategory = this.createRootCategory(RandomData.getRandomName((String)"recordCategory"));
    }

    @Test(priority=1)
    public void createRetentionScheduleFor403() {
        RetentionSchedule retentionSchedule = new RetentionSchedule();
        this.getRestAPIFactory().getRetentionScheduleAPI(this.nonRMuser).createRetentionSchedule(retentionSchedule, this.recordCategory.getId());
        this.assertStatusCode(HttpStatus.FORBIDDEN);
    }

    @Test(priority=2)
    public void createRetentionScheduleFor404() {
        RetentionSchedule retentionSchedule = new RetentionSchedule();
        this.getRestAPIFactory().getRetentionScheduleAPI().createRetentionSchedule(retentionSchedule, RandomData.getRandomAlphanumeric());
        this.assertStatusCode(HttpStatus.NOT_FOUND);
    }

    @Test(priority=3)
    public void createRetentionScheduleFor401() {
        RetentionSchedule retentionSchedule = new RetentionSchedule();
        this.createdRetentionSchedule = this.getRestAPIFactory().getRetentionScheduleAPI(new UserModel(this.getAdminUser().getUsername(), "wrongPassword")).createRetentionSchedule(retentionSchedule, this.recordCategory.getId());
        this.assertStatusCode(HttpStatus.UNAUTHORIZED);
    }

    @Test(priority=4)
    public void createRetentionScheduleFor201() {
        RetentionSchedule retentionSchedule = new RetentionSchedule();
        String authority = "authority" + RandomData.getRandomAlphanumeric();
        String instructions = "instructions" + RandomData.getRandomAlphanumeric();
        boolean isRecordLevel = false;
        retentionSchedule.setAuthority(authority);
        retentionSchedule.setInstructions(instructions);
        retentionSchedule.setIsRecordLevel(isRecordLevel);
        this.createdRetentionSchedule = this.getRestAPIFactory().getRetentionScheduleAPI().createRetentionSchedule(retentionSchedule, this.recordCategory.getId());
        this.assertStatusCode(HttpStatus.CREATED);
        AssertJUnit.assertEquals((String)this.createdRetentionSchedule.getAuthority(), (String)authority);
        AssertJUnit.assertEquals((String)this.createdRetentionSchedule.getInstructions(), (String)instructions);
        Assert.assertFalse((boolean)this.createdRetentionSchedule.getIsRecordLevel());
        Assert.assertNotNull((Object)this.createdRetentionSchedule.getId());
    }

    @Test(priority=5)
    public void createRetentionScheduleFor409() {
        RetentionSchedule retentionSchedule = new RetentionSchedule();
        this.getRestAPIFactory().getRetentionScheduleAPI().createRetentionSchedule(retentionSchedule, this.recordCategory.getId());
        this.assertStatusCode(HttpStatus.CONFLICT);
    }

    @Test(priority=6)
    public void retentionScheduleWith403() {
        this.getRestAPIFactory().getRetentionScheduleAPI(this.nonRMuser).getRetentionSchedule(this.recordCategory.getId());
        this.assertStatusCode(HttpStatus.FORBIDDEN);
    }

    @Test(priority=7)
    public void retentionScheduleWith404() {
        this.getRestAPIFactory().getRetentionScheduleAPI().getRetentionSchedule(RandomData.getRandomAlphanumeric());
        this.assertStatusCode(HttpStatus.NOT_FOUND);
    }

    @Test(priority=8)
    public void retentionScheduleWith401() {
        this.getRestAPIFactory().getRetentionScheduleAPI(new UserModel(this.getAdminUser().getUsername(), "wrongPassword")).getRetentionSchedule(this.recordCategory.getId());
        this.assertStatusCode(HttpStatus.UNAUTHORIZED);
    }

    @Test(priority=9)
    public void retentionScheduleWith200() {
        RetentionScheduleCollection retentionScheduleCollection = this.getRestAPIFactory().getRetentionScheduleAPI().getRetentionSchedule(this.recordCategory.getId());
        this.assertStatusCode(HttpStatus.OK);
        retentionScheduleCollection.getEntries().forEach(c -> {
            RetentionSchedule retentionSchedule = c.getEntry();
            String retentionScheduleId = retentionSchedule.getId();
            Assert.assertNotNull((Object)retentionScheduleId);
            this.logger.info((Object)("Checking retention schedule " + retentionScheduleId));
            AssertJUnit.assertEquals((String)this.createdRetentionSchedule.getId(), (String)retentionScheduleId);
            AssertJUnit.assertEquals((String)this.createdRetentionSchedule.getParentId(), (String)retentionSchedule.getParentId());
            AssertJUnit.assertEquals((String)this.createdRetentionSchedule.getAuthority(), (String)retentionSchedule.getAuthority());
            AssertJUnit.assertEquals((String)this.createdRetentionSchedule.getInstructions(), (String)retentionSchedule.getInstructions());
            AssertJUnit.assertEquals((boolean)this.createdRetentionSchedule.getIsRecordLevel(), (boolean)retentionSchedule.getIsRecordLevel());
            AssertJUnit.assertEquals((boolean)this.createdRetentionSchedule.isUnpublishedUpdates(), (boolean)retentionSchedule.isUnpublishedUpdates());
        });
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpRetentionScheduleTests() {
        this.rmRolesAndActionsAPI.deleteAllItemsInContainer(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), "rm", this.recordCategory.getName());
        this.deleteRecordCategory(this.recordCategory.getId());
        this.dataUser.deleteUser(this.nonRMuser);
    }
}

